/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.resolver.internal.resource.ServletResource;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;

public class ServletResourceProvider
extends ResourceProvider<Object> {
    private Servlet servlet;
    private Set<String> resourcePaths;

    ServletResourceProvider(Servlet servlet, Set<String> resourcePaths) {
        this.servlet = servlet;
        this.resourcePaths = resourcePaths;
    }

    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
        if (this.resourcePaths.contains(path)) {
            return new ServletResource(ctx.getResourceResolver(), this.servlet, path);
        }
        ResourceProvider parentProvider = ctx.getParentResourceProvider();
        if (parentProvider != null) {
            Resource useParent = parent instanceof ServletResource ? null : parent;
            return parentProvider.getResource(ctx.getParentResolveContext(), path, resourceContext, useParent);
        }
        return null;
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        ResourceProvider parentProvider = ctx.getParentResourceProvider();
        if (parentProvider != null) {
            return parentProvider.listChildren(ctx.getParentResolveContext(), parent);
        }
        return null;
    }

    Servlet getServlet() {
        return this.servlet;
    }

    Iterator<String> getServletPathIterator() {
        return this.resourcePaths.iterator();
    }

    public String[] getServletPaths() {
        return this.resourcePaths.toArray(new String[this.resourcePaths.size()]);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": servlet=" + this.servlet.getClass().getName() + ", paths=" + Arrays.toString(this.getServletPaths());
    }
}

