/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.request.SlingRequestListener;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptResolver;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.servlets.resolver.internal.DecomposedURL;
import org.apache.sling.servlets.resolver.internal.ScriptResource;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultErrorHandlerServlet;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultServlet;
import org.apache.sling.servlets.resolver.internal.helper.AbstractResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.NamedScriptResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.ResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.SlingServletConfig;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProvider;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProviderFactory;
import org.apache.sling.servlets.resolver.jmx.SlingServletResolverCacheMBean;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.servlets.resolver.SlingServletResolver", service={ServletResolver.class, SlingScriptResolver.class, ErrorHandler.class, SlingRequestListener.class}, property={"service.description=Apache Sling Servlet Resolver and Error Handler", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class SlingServletResolver
implements ServletResolver,
SlingScriptResolver,
SlingRequestListener,
ErrorHandler,
EventHandler,
ResourceChangeListener,
ExternalResourceChangeListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(SlingServletResolver.class);
    private static final String REF_SERVLET = "Servlet";
    @Reference(target="(name=org.apache.sling)")
    private ServletContext servletContext;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(target="(subServiceName=scripts)")
    private ServiceUserMapped scriptServiceUserMapped;
    @Reference(target="(subServiceName=console)")
    private ServiceUserMapped consoleServiceUserMapped;
    @Reference
    private ScriptEngineManager scriptEngineManager;
    private List<String> scriptEnginesExtensions = new ArrayList<String>();
    private ResourceResolver sharedScriptResolver;
    private final Map<ServiceReference<Servlet>, ServletReg> servletsByReference = new HashMap<ServiceReference<Servlet>, ServletReg>();
    private final List<PendingServlet> pendingServlets = new ArrayList<PendingServlet>();
    private BundleContext context;
    private ServletResourceProviderFactory servletResourceProviderFactory;
    private Servlet defaultServlet;
    private Servlet fallbackErrorServlet;
    private Map<AbstractResourceCollector, Servlet> cache;
    private int cacheSize;
    private volatile boolean logCacheSizeWarning;
    private ServiceRegistration<?> eventHandlerReg;
    private String[] executionPaths;
    private String[] searchPaths;
    private String[] defaultExtensions;
    private ServletResolverWebConsolePlugin plugin;
    private final ThreadLocal<ResourceResolver> perThreadScriptResolver = new ThreadLocal();
    private ServiceRegistration<SlingServletResolverCacheMBean> mbeanRegistration;
    private static final String[] NAME_PROPERTIES = new String[]{"sling.core.servletName", "component.name", "service.pid", "service.id"};

    public Servlet resolveServlet(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "resolveServlet(" + resource.getPath() + ")";
        tracker.startTimer(timerName);
        String type = resource.getResourceType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {}", (Object)resource);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = null;
        if (type != null && type.length() > 0) {
            servlet = this.resolveServletInternal(request, null, type, scriptResolver);
        }
        if (servlet == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No specific servlet found, trying default");
            }
            servlet = this.getDefaultServlet();
        }
        if (servlet == null) {
            tracker.logTimer(timerName, "Servlet resolution failed. See log for details", new Object[0]);
        } else {
            tracker.logTimer(timerName, "Using servlet {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
        }
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for resource={}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)resource);
            } else {
                LOGGER.debug("No servlet found for resource={}", (Object)resource);
            }
        }
        return servlet;
    }

    public Servlet resolveServlet(Resource resource, String scriptName) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {} with script name {}", (Object)resource, (Object)scriptName);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = this.resolveServletInternal(null, resource, scriptName, scriptResolver);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for resource {} and script name {}", new Object[]{RequestUtil.getServletName((Servlet)servlet), resource, scriptName});
            } else {
                LOGGER.debug("No servlet found for resource {} and script name {}", (Object)resource, (Object)scriptName);
            }
        }
        return servlet;
    }

    public Servlet resolveServlet(ResourceResolver resolver, String scriptName) {
        if (resolver == null) {
            throw new IllegalArgumentException("Resource resolver must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for for script name {}", (Object)scriptName);
        }
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        Servlet servlet = this.resolveServletInternal(null, null, scriptName, scriptResolver);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for script name {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptName);
            } else {
                LOGGER.debug("No servlet found for script name {}", (Object)scriptName);
            }
        }
        return servlet;
    }

    private Servlet getServlet(Resource scriptResource) {
        if (scriptResource == null) {
            return null;
        }
        if (scriptResource.getResourceResolver() == this.sharedScriptResolver || "sling/bundle/resource".equals(scriptResource.getResourceSuperType())) {
            return (Servlet)scriptResource.adaptTo(Servlet.class);
        }
        return new ScriptResource(scriptResource, this.perThreadScriptResolver, this.sharedScriptResolver).adaptTo(Servlet.class);
    }

    public SlingScript findScript(ResourceResolver resourceResolver, String name) throws SlingException {
        SlingScript script = null;
        if (name.startsWith("/")) {
            Resource resource;
            String path = ResourceUtil.normalize((String)name);
            if (this.isPathAllowed(path) && (resource = resourceResolver.getResource(path)) != null) {
                script = (SlingScript)resource.adaptTo(SlingScript.class);
            }
        } else {
            String[] path = resourceResolver.getSearchPath();
            for (int i = 0; script == null && i < path.length; ++i) {
                Resource resource;
                String scriptPath = ResourceUtil.normalize((String)(path[i] + name));
                if (!this.isPathAllowed(scriptPath) || (resource = resourceResolver.getResource(scriptPath)) == null) continue;
                script = (SlingScript)resource.adaptTo(SlingScript.class);
            }
        }
        if (script != null) {
            LOGGER.debug("findScript: Using script {} for {}", (Object)script.getScriptResource().getPath(), (Object)name);
        } else {
            LOGGER.info("findScript: No script {} found in path", (Object)name);
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(int status, String message, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling status " + status + "(" + message + ")");
            return;
        }
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "handleError:status=" + status;
        tracker.startTimer(timerName);
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        try {
            Resource resource = this.getErrorResource(request);
            ResourceCollector locationUtil = new ResourceCollector(String.valueOf(status), "sling/servlet/errorhandler", resource, this.executionPaths);
            Servlet servlet = this.getServletInternal(locationUtil, request, scriptResolver);
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, resource, scriptResolver);
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(status));
            request.setAttribute("javax.servlet.error.message", (Object)message);
            Object servletName = request.getAttribute("sling.core.current.servletName");
            if (servletName instanceof String) {
                request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            tracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            tracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Throwable throwable, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling Throwable:", throwable);
            return;
        }
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "handleError:throwable=" + throwable.getClass().getName();
        tracker.startTimer(timerName);
        ResourceResolver scriptResolver = this.getScriptResourceResolver();
        try {
            Servlet servlet = null;
            Resource resource = this.getErrorResource(request);
            for (Class<?> tClass = throwable.getClass(); servlet == null && tClass != Object.class; tClass = tClass.getSuperclass()) {
                ResourceCollector locationUtil = new ResourceCollector(tClass.getSimpleName(), "sling/servlet/errorhandler", resource, this.executionPaths);
                servlet = this.getServletInternal(locationUtil, request, scriptResolver);
            }
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, resource, scriptResolver);
            }
            request.setAttribute("javax.servlet.error.exception", (Object)throwable);
            request.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
            request.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
            tracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            tracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResolver getScriptResourceResolver() {
        ResourceResolver scriptResolver = this.perThreadScriptResolver.get();
        if (scriptResolver == null) {
            ResourceResolver resourceResolver = this.sharedScriptResolver;
            synchronized (resourceResolver) {
                this.sharedScriptResolver.refresh();
            }
            scriptResolver = this.sharedScriptResolver;
        }
        return scriptResolver;
    }

    public void onEvent(SlingRequestEvent event) {
        ResourceResolver resolver;
        if (event.getType() == SlingRequestEvent.EventType.EVENT_INIT) {
            try {
                this.perThreadScriptResolver.set(this.sharedScriptResolver.clone(null));
            }
            catch (LoginException e) {
                LOGGER.error("Unable to create new script resolver clone", (Throwable)e);
            }
        } else if (event.getType() == SlingRequestEvent.EventType.EVENT_DESTROY && (resolver = this.perThreadScriptResolver.get()) != null) {
            this.perThreadScriptResolver.remove();
            resolver.close();
        }
    }

    private Resource getErrorResource(SlingHttpServletRequest request) {
        Resource res = request.getResource();
        if (res == null) {
            res = new SyntheticResource(request.getResourceResolver(), request.getPathInfo(), "sling/servlet/errorhandler");
        }
        return res;
    }

    private Servlet resolveServletInternal(SlingHttpServletRequest request, Resource resource, String scriptName, ResourceResolver resolver) {
        AbstractResourceCollector locationUtil;
        Servlet servlet = null;
        if (scriptName.charAt(0) == '/') {
            String scriptPath = ResourceUtil.normalize((String)scriptName);
            if (this.isPathAllowed(scriptPath)) {
                Resource res = resolver.getResource(scriptPath);
                servlet = this.getServlet(res);
                if (servlet != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Servlet {} found using absolute resource type {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptName);
                }
            } else if (request != null) {
                request.getRequestProgressTracker().log("Will not look for a servlet at {0} as it is not in the list of allowed paths", new Object[]{scriptName});
            }
        }
        if (servlet == null && (servlet = this.getServletInternal(locationUtil = request != null ? ResourceCollector.create(request, this.executionPaths, this.defaultExtensions) : NamedScriptResourceCollector.create(scriptName, resource, this.executionPaths), request, resolver)) != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("getServletInternal returns servlet {}", (Object)RequestUtil.getServletName((Servlet)servlet));
        }
        return servlet;
    }

    private Servlet getServletInternal(AbstractResourceCollector locationUtil, SlingHttpServletRequest request, ResourceResolver resolver) {
        Servlet scriptServlet;
        Servlet servlet = scriptServlet = this.cache != null ? this.cache.get(locationUtil) : null;
        if (scriptServlet != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using cached servlet {}", (Object)RequestUtil.getServletName((Servlet)scriptServlet));
            }
            return scriptServlet;
        }
        Collection<Resource> candidates = locationUtil.getServlets(resolver, this.scriptEnginesExtensions);
        if (LOGGER.isDebugEnabled()) {
            if (candidates.isEmpty()) {
                LOGGER.debug("No servlet candidates found");
            } else {
                LOGGER.debug("Ordered list of servlet candidates follows");
                for (Resource candidateResource : candidates) {
                    LOGGER.debug("Servlet candidate: {}", (Object)candidateResource.getPath());
                }
            }
        }
        boolean hasOptingServlet = false;
        for (Resource candidateResource : candidates) {
            LOGGER.debug("Checking if candidate resource {} adapts to servlet and accepts request", (Object)candidateResource.getPath());
            Servlet candidate = this.getServlet(candidateResource);
            if (candidate != null) {
                boolean servletAcceptsRequest;
                boolean isOptingServlet = candidate instanceof OptingServlet;
                boolean bl = servletAcceptsRequest = !isOptingServlet || request != null && ((OptingServlet)candidate).accepts(request);
                if (servletAcceptsRequest) {
                    if (!hasOptingServlet && !isOptingServlet && this.cache != null) {
                        if (this.cache.size() < this.cacheSize) {
                            this.cache.put(locationUtil, candidate);
                        } else if (this.logCacheSizeWarning) {
                            this.logCacheSizeWarning = false;
                            LOGGER.warn("Script cache has reached its limit of {}. You might want to increase the cache size for the servlet resolver.", (Object)this.cacheSize);
                        }
                    }
                    LOGGER.debug("Using servlet provided by candidate resource {}", (Object)candidateResource.getPath());
                    return candidate;
                }
                if (isOptingServlet) {
                    hasOptingServlet = true;
                }
                LOGGER.debug("Candidate {} does not accept request, ignored", (Object)candidateResource.getPath());
                continue;
            }
            LOGGER.debug("Candidate {} does not adapt to a servlet, ignored", (Object)candidateResource.getPath());
        }
        return null;
    }

    private Servlet getDefaultServlet() {
        if (this.defaultServlet == null) {
            try {
                DefaultServlet servlet = new DefaultServlet();
                servlet.init(new SlingServletConfig(this.servletContext, null, "Apache Sling Core Default Servlet"));
                this.defaultServlet = servlet;
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize default servlet", (Throwable)se);
            }
        }
        return this.defaultServlet;
    }

    private Servlet getDefaultErrorServlet(SlingHttpServletRequest request, Resource resource, ResourceResolver resolver) {
        ResourceCollector locationUtil = new ResourceCollector("default", "sling/servlet/errorhandler", resource, this.executionPaths);
        Servlet servlet = this.getServletInternal(locationUtil, request, resolver);
        if (servlet != null) {
            return servlet;
        }
        if (this.fallbackErrorServlet == null) {
            try {
                DefaultErrorHandlerServlet defaultServlet = new DefaultErrorHandlerServlet();
                defaultServlet.init(new SlingServletConfig(this.servletContext, null, "Sling (Ad Hoc) Default Error Handler Servlet"));
                this.fallbackErrorServlet = defaultServlet;
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize error servlet", (Throwable)se);
            }
        }
        return this.fallbackErrorServlet;
    }

    private void handleError(Servlet errorHandler, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        if (request.getAttribute("javax.servlet.error.servlet_name") == null) {
            request.setAttribute("javax.servlet.error.servlet_name", (Object)errorHandler.getServletConfig().getServletName());
        }
        try {
            errorHandler.service((ServletRequest)request, (ServletResponse)response);
            response.flushBuffer();
            response.getWriter().close();
        }
        catch (Throwable t) {
            LOGGER.error("Calling the error handler resulted in an error", t);
            LOGGER.error("Original error " + request.getAttribute("javax.servlet.error.exception_type"), (Throwable)request.getAttribute("javax.servlet.error.exception"));
            IOException x = new IOException("Error handler failed: " + t.getClass().getName());
            x.initCause(t);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(BundleContext context, Config config) throws LoginException {
        ArrayList<PendingServlet> refs;
        List<PendingServlet> list = this.pendingServlets;
        synchronized (list) {
            refs = new ArrayList<PendingServlet>(this.pendingServlets);
            this.pendingServlets.clear();
            this.sharedScriptResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "scripts"));
            this.searchPaths = this.sharedScriptResolver.getSearchPath();
            this.servletResourceProviderFactory = new ServletResourceProviderFactory(config.servletresolver_servletRoot(), this.searchPaths);
            this.context = context;
        }
        this.createAllServlets(refs);
        this.executionPaths = config.servletresolver_paths();
        if (this.executionPaths != null) {
            if (this.executionPaths.length == 0) {
                this.executionPaths = null;
            } else {
                boolean hasRoot = false;
                for (int i = 0; i < this.executionPaths.length; ++i) {
                    String path = this.executionPaths[i];
                    if (path != null && path.length() != 0 && !path.equals("/")) continue;
                    hasRoot = true;
                    break;
                }
                if (hasRoot) {
                    this.executionPaths = null;
                }
            }
        }
        this.defaultExtensions = config.servletresolver_defaultExtensions();
        this.cacheSize = config.servletresolver_cacheSize();
        if (this.cacheSize > 5) {
            this.cache = new ConcurrentHashMap<AbstractResourceCollector, Servlet>(this.cacheSize);
            this.logCacheSizeWarning = true;
        } else {
            this.cacheSize = 0;
        }
        this.getDefaultServlet();
        if (this.cache != null) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("event.topics", new String[]{"javax/script/ScriptEngineFactory/*", "org/apache/sling/api/adapter/AdapterFactory/*", "org/apache/sling/scripting/core/BindingsValuesProvider/*"});
            ((Dictionary)props).put("resource.paths", "/");
            ((Dictionary)props).put("service.description", "Apache Sling Servlet Resolver and Error Handler");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            this.eventHandlerReg = context.registerService(new String[]{ResourceChangeListener.class.getName(), EventHandler.class.getName()}, (Object)this, props);
        }
        this.plugin = new ServletResolverWebConsolePlugin(context);
        if (this.cacheSize > 0) {
            try {
                Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
                ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=servletResolver,service=SlingServletResolverCache");
                ServletResolverCacheMBeanImpl mbean = new ServletResolverCacheMBeanImpl();
                this.mbeanRegistration = context.registerService(SlingServletResolverCacheMBean.class, (Object)mbean, mbeanProps);
            }
            catch (Throwable t) {
                LOGGER.debug("Unable to register mbean");
            }
        }
        this.updateScriptEngineExtensions();
    }

    private void updateScriptEngineExtensions() {
        ArrayList<String> scriptEnginesExtensions = new ArrayList<String>();
        for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
            scriptEnginesExtensions.addAll(factory.getExtensions());
        }
        this.scriptEnginesExtensions = Collections.unmodifiableList(scriptEnginesExtensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        ArrayList<ServiceReference<Servlet>> refs;
        this.context = null;
        if (this.plugin != null) {
            this.plugin.dispose();
        }
        if (this.eventHandlerReg != null) {
            this.eventHandlerReg.unregister();
            this.eventHandlerReg = null;
        }
        Map<ServiceReference<Servlet>, ServletReg> map = this.servletsByReference;
        synchronized (map) {
            refs = new ArrayList<ServiceReference<Servlet>>(this.servletsByReference.keySet());
        }
        this.destroyAllServlets(refs);
        map = this.servletsByReference;
        synchronized (map) {
            this.servletsByReference.clear();
        }
        if (this.fallbackErrorServlet != null) {
            try {
                this.fallbackErrorServlet.destroy();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.fallbackErrorServlet = null;
            }
        }
        if (this.sharedScriptResolver != null) {
            this.sharedScriptResolver.close();
            this.sharedScriptResolver = null;
        }
        this.cache = null;
        this.servletResourceProviderFactory = null;
        if (this.mbeanRegistration != null) {
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="Servlet", service=Servlet.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(|(sling.servlet.paths=*)(sling.servlet.resourceTypes=*))")
    protected void bindServlet(Servlet servlet, ServiceReference<Servlet> reference) {
        boolean directCreate = true;
        if (this.context == null) {
            List<PendingServlet> list = this.pendingServlets;
            synchronized (list) {
                if (this.context == null) {
                    this.pendingServlets.add(new PendingServlet(servlet, reference));
                    directCreate = false;
                }
            }
        }
        if (directCreate) {
            this.createServlet(servlet, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindServlet(ServiceReference<Servlet> reference) {
        List<PendingServlet> list = this.pendingServlets;
        synchronized (list) {
            Iterator<PendingServlet> iter = this.pendingServlets.iterator();
            while (iter.hasNext()) {
                PendingServlet ps = iter.next();
                if (ps.reference.compareTo(reference) != 0) continue;
                iter.remove();
                break;
            }
        }
        this.destroyServlet(reference);
    }

    private void createAllServlets(Collection<PendingServlet> pendingServlets) {
        for (PendingServlet ps : pendingServlets) {
            this.createServlet(ps.servlet, ps.reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createServlet(Servlet servlet, ServiceReference<Servlet> reference) {
        BundleContext bundleContext;
        String name = SlingServletResolver.getName(reference);
        ServletResourceProvider provider = this.servletResourceProviderFactory.create(reference, servlet);
        if (provider == null) {
            return false;
        }
        try {
            servlet.init((ServletConfig)new SlingServletConfig(this.servletContext, reference, name));
            LOGGER.debug("bindServlet: Servlet {} initialized", (Object)name);
        }
        catch (ServletException ce) {
            LOGGER.error("bindServlet: Servlet " + ServletResourceProviderFactory.getServiceReferenceInfo(reference) + " failed to initialize", (Throwable)ce);
            return false;
        }
        catch (Throwable t) {
            LOGGER.error("bindServlet: Unexpected problem initializing servlet " + ServletResourceProviderFactory.getServiceReferenceInfo(reference), t);
            return false;
        }
        boolean registered = false;
        Bundle bundle = reference.getBundle();
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            ArrayList<ServiceRegistration<ResourceProvider<Object>>> regs = new ArrayList<ServiceRegistration<ResourceProvider<Object>>>();
            try {
                for (String root : provider.getServletPaths()) {
                    ServiceRegistration reg = bundleContext.registerService(ResourceProvider.class.getName(), (Object)provider, this.createServiceProperties(reference, provider, root));
                    regs.add((ServiceRegistration<ResourceProvider<Object>>)reg);
                }
                registered = true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (registered) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Registered {}", (Object)provider);
                }
                Map<ServiceReference<Servlet>, ServletReg> map = this.servletsByReference;
                synchronized (map) {
                    this.servletsByReference.put(reference, new ServletReg(servlet, regs));
                }
            }
        }
        if (!registered) {
            LOGGER.debug("bindServlet: servlet has been unregistered in the meantime. Ignoring {}", (Object)name);
        }
        return true;
    }

    private Dictionary<String, Object> createServiceProperties(ServiceReference<Servlet> reference, ServletResourceProvider provider, String root) {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        ((Dictionary)params).put("provider.root", root);
        ((Dictionary)params).put("service.description", "ServletResourceProvider for Servlets at " + Arrays.asList(provider.getServletPaths()));
        Object rank = reference.getProperty("service.ranking");
        if (rank instanceof Integer) {
            ((Dictionary)params).put("service.ranking", rank);
        }
        return params;
    }

    private void destroyAllServlets(Collection<ServiceReference<Servlet>> refs) {
        for (ServiceReference<Servlet> serviceReference : refs) {
            this.destroyServlet(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyServlet(ServiceReference<Servlet> reference) {
        ServletReg registration;
        Map<ServiceReference<Servlet>, ServletReg> map = this.servletsByReference;
        synchronized (map) {
            registration = this.servletsByReference.remove(reference);
        }
        if (registration != null) {
            for (ServiceRegistration serviceRegistration : registration.registrations) {
                try {
                    serviceRegistration.unregister();
                }
                catch (IllegalStateException illegalStateException) {}
            }
            String name = RequestUtil.getServletName((Servlet)registration.servlet);
            LOGGER.debug("unbindServlet: Servlet {} removed", (Object)name);
            try {
                registration.servlet.destroy();
            }
            catch (Throwable throwable) {
                LOGGER.error("unbindServlet: Unexpected problem destroying servlet " + name, throwable);
            }
        }
    }

    public void handleEvent(Event event) {
        this.flushCache();
        this.updateScriptEngineExtensions();
    }

    private void flushCache() {
        this.cache.clear();
        this.logCacheSizeWarning = true;
    }

    private static String getName(ServiceReference<Servlet> reference) {
        String servletName = null;
        for (int i = 0; i < NAME_PROPERTIES.length && (servletName == null || servletName.length() == 0); ++i) {
            Object prop = reference.getProperty(NAME_PROPERTIES[i]);
            if (prop == null) continue;
            servletName = String.valueOf(prop);
        }
        return servletName;
    }

    private boolean isPathAllowed(String path) {
        return AbstractResourceCollector.isPathAllowed(path, this.executionPaths);
    }

    public void onChange(List<ResourceChange> changes) {
        boolean flushCache = false;
        for (ResourceChange change : changes) {
            String path = change.getPath();
            for (int index = 0; !flushCache && index < this.searchPaths.length; ++index) {
                if (!path.startsWith(this.searchPaths[index])) continue;
                flushCache = true;
            }
            if (!flushCache) continue;
            this.flushCache();
            break;
        }
    }

    class ServletResolverCacheMBeanImpl
    extends StandardMBean
    implements SlingServletResolverCacheMBean {
        ServletResolverCacheMBeanImpl() throws NotCompliantMBeanException {
            super(SlingServletResolverCacheMBean.class);
        }

        @Override
        public int getCacheSize() {
            return SlingServletResolver.this.cache != null ? SlingServletResolver.this.cache.size() : 0;
        }

        @Override
        public void flushCache() {
            SlingServletResolver.this.flushCache();
        }

        @Override
        public int getMaximumCacheSize() {
            return SlingServletResolver.this.cacheSize;
        }
    }

    class ServletResolverWebConsolePlugin
    extends HttpServlet {
        private static final String PARAMETER_URL = "url";
        private static final String PARAMETER_METHOD = "method";
        private ServiceRegistration<Servlet> service;

        public ServletResolverWebConsolePlugin(BundleContext context) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", "Sling Servlet Resolver Web Console Plugin");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
            ((Dictionary)props).put("felix.webconsole.label", "servletresolver");
            ((Dictionary)props).put("felix.webconsole.title", "Sling Servlet Resolver");
            ((Dictionary)props).put("felix.webconsole.css", "/servletresolver/res/ui/styles.css");
            ((Dictionary)props).put("felix.webconsole.category", "Sling");
            this.service = context.registerService(Servlet.class, (Object)this, props);
        }

        public void dispose() {
            if (this.service != null) {
                this.service.unregister();
                this.service = null;
            }
        }

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String url = request.getParameter(PARAMETER_URL);
            RequestPathInfo requestPathInfo = new DecomposedURL(url).getRequestPathInfo();
            String method = request.getParameter(PARAMETER_METHOD);
            if (StringUtils.isBlank((CharSequence)method)) {
                method = "GET";
            }
            String CONSOLE_PATH_WARNING = "<em>Note that in a real Sling request, the path might vary depending on the existence of resources that partially match it.<br/>This utility does not take this into account and uses the first dot to split between path and selectors/extension.<br/>As a workaround, you can replace dots with underline characters, for example, when testing such an URL.</em>";
            try (ResourceResolver resourceResolver = null;){
                resourceResolver = SlingServletResolver.this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "console"));
                PrintWriter pw = response.getWriter();
                pw.print("<form method='get'>");
                pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
                this.titleHtml(pw, "Servlet Resolver Test", "To check which servlet is responsible for rendering a response, enter a request path into the field and click 'Resolve' to resolve it.");
                this.tr(pw);
                this.tdLabel(pw, "URL");
                this.tdContent(pw);
                pw.print("<input type='text' name='");
                pw.print(PARAMETER_URL);
                pw.print("' value='");
                if (url != null) {
                    pw.print(ResponseUtil.escapeXml((String)url));
                }
                pw.println("' class='input' size='50'>");
                this.closeTd(pw);
                this.closeTr(pw);
                this.closeTr(pw);
                this.tr(pw);
                this.tdLabel(pw, "Method");
                this.tdContent(pw);
                pw.print("<select name='");
                pw.print(PARAMETER_METHOD);
                pw.println("'>");
                pw.println("<option value='GET'>GET</option>");
                pw.println("<option value='POST'>POST</option>");
                pw.println("</select>");
                pw.println("&nbsp;&nbsp;<input type='submit' value='Resolve' class='submit'>");
                this.closeTd(pw);
                this.closeTr(pw);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    this.tr(pw);
                    this.tdLabel(pw, "Decomposed URL");
                    this.tdContent(pw);
                    pw.println("<dl>");
                    pw.println("<dt>Path</dt>");
                    pw.print("<dd>");
                    pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getResourcePath()));
                    pw.print("<br/>");
                    pw.print("<em>Note that in a real Sling request, the path might vary depending on the existence of resources that partially match it.<br/>This utility does not take this into account and uses the first dot to split between path and selectors/extension.<br/>As a workaround, you can replace dots with underline characters, for example, when testing such an URL.</em>");
                    pw.println("</dd>");
                    pw.println("<dt>Selectors</dt>");
                    pw.print("<dd>");
                    if (requestPathInfo.getSelectors().length == 0) {
                        pw.print("&lt;none&gt;");
                    } else {
                        pw.print("[");
                        pw.print(ResponseUtil.escapeXml((String)StringUtils.join((Object[])requestPathInfo.getSelectors(), (String)", ")));
                        pw.print("]");
                    }
                    pw.println("</dd>");
                    pw.println("<dt>Extension</dt>");
                    pw.print("<dd>");
                    pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getExtension()));
                    pw.println("</dd>");
                    pw.println("</dl>");
                    pw.println("</dd>");
                    pw.println("<dt>Suffix</dt>");
                    pw.print("<dd>");
                    pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getSuffix()));
                    pw.println("</dd>");
                    pw.println("</dl>");
                    this.closeTd(pw);
                    this.closeTr(pw);
                }
                if (StringUtils.isNotBlank((CharSequence)requestPathInfo.getResourcePath())) {
                    Collection<Resource> servlets;
                    Resource resource = resourceResolver.resolve(requestPathInfo.getResourcePath());
                    if (resource.adaptTo(Servlet.class) != null) {
                        servlets = Collections.singleton(resource);
                    } else {
                        ResourceCollector locationUtil = ResourceCollector.create(resource, requestPathInfo.getExtension(), SlingServletResolver.this.executionPaths, SlingServletResolver.this.defaultExtensions, method, requestPathInfo.getSelectors());
                        servlets = locationUtil.getServlets(resourceResolver, SlingServletResolver.this.scriptEnginesExtensions);
                    }
                    this.tr(pw);
                    this.tdLabel(pw, "Candidates");
                    this.tdContent(pw);
                    if (servlets == null || servlets.isEmpty()) {
                        pw.println("Could not find a suitable servlet for this request!");
                    } else {
                        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                            pw.println("The resource given by path '");
                            pw.println(resource.getPath());
                            pw.println("' does not exist. Therefore no resource type could be determined!<br/>");
                        }
                        pw.print("Candidate servlets and scripts in order of preference for method ");
                        pw.print(ResponseUtil.escapeXml((String)method));
                        pw.println(":<br/>");
                        pw.println("<ol class='servlets'>");
                        this.outputServlets(pw, servlets.iterator());
                        pw.println("</ol>");
                    }
                    pw.println("</td>");
                    this.closeTr(pw);
                }
                pw.println("</table>");
                pw.print("</form>");
            }
        }

        private void tdContent(PrintWriter pw) {
            pw.print("<td class='content' colspan='2'>");
        }

        private void closeTd(PrintWriter pw) {
            pw.print("</td>");
        }

        private URL getResource(String path) {
            if (path.startsWith("/servletresolver/res/ui")) {
                return ((Object)((Object)this)).getClass().getResource(path.substring(16));
            }
            return null;
        }

        private void closeTr(PrintWriter pw) {
            pw.println("</tr>");
        }

        private void tdLabel(PrintWriter pw, String label) {
            pw.print("<td class='content'>");
            pw.print(ResponseUtil.escapeXml((String)label));
            pw.println("</td>");
        }

        private void tr(PrintWriter pw) {
            pw.println("<tr class='content'>");
        }

        private void outputServlets(PrintWriter pw, Iterator<Resource> iterator) {
            while (iterator.hasNext()) {
                Resource candidateResource = iterator.next();
                Servlet candidate = (Servlet)candidateResource.adaptTo(Servlet.class);
                if (candidate == null) continue;
                boolean allowed = SlingServletResolver.this.isPathAllowed(candidateResource.getPath());
                pw.print("<li>");
                if (!allowed) {
                    pw.print("<del>");
                }
                if (candidate instanceof SlingScript) {
                    pw.print(ResponseUtil.escapeXml((String)candidateResource.getPath()));
                } else {
                    boolean isOptingServlet = candidate instanceof OptingServlet;
                    pw.print(ResponseUtil.escapeXml((String)candidate.getClass().getName()));
                    if (isOptingServlet) {
                        pw.print(" (OptingServlet)");
                    }
                }
                if (!allowed) {
                    pw.print("</del>");
                }
                pw.println("</li>");
            }
        }

        private void titleHtml(PrintWriter pw, String title, String description) {
            this.tr(pw);
            pw.print("<th colspan='3' class='content container'>");
            pw.print(ResponseUtil.escapeXml((String)title));
            pw.println("</th>");
            this.closeTr(pw);
            if (description != null) {
                this.tr(pw);
                pw.print("<td colspan='3' class='content'>");
                pw.print(ResponseUtil.escapeXml((String)description));
                pw.println("</th>");
                this.closeTr(pw);
            }
        }
    }

    private static final class PendingServlet {
        public final Servlet servlet;
        public final ServiceReference<Servlet> reference;

        public PendingServlet(Servlet s, ServiceReference<Servlet> ref) {
            this.servlet = s;
            this.reference = ref;
        }
    }

    private static final class ServletReg {
        public final Servlet servlet;
        public final List<ServiceRegistration<ResourceProvider<Object>>> registrations;

        public ServletReg(Servlet s, List<ServiceRegistration<ResourceProvider<Object>>> srs) {
            this.servlet = s;
            this.registrations = srs;
        }
    }

    @ObjectClassDefinition(name="Apache Sling Servlet/Script Resolver and Error Handler", description="The Sling Servlet and Script Resolver has multiple tasks: One it is used as the ServletResolver to select the Servlet or Script to call to handle the request. Second it acts as the SlingScriptResolver and finally it manages error handling by implementing the ErrorHandler interface using the same algorithm to select error handling servlets and scripts as is used to resolve request processing servlets and scripts.")
    public static @interface Config {
        @AttributeDefinition(name="Servlet Registration Root Path", description="The default root path assumed when registering a servlet whose servlet registration properties define a relative resource type/path. It can either be a string starting with \"/\" (specifying a path prefix to be used) or a number which specifies the resource resolver's search path entry index. The default value is 0 (usually stands for \"/apps\" in the search paths). The number can be -1 which always points to the last search path entry.")
        public String servletresolver_servletRoot() default "0";

        @AttributeDefinition(name="Cache Size", description="This property configures the size of the cache used for script resolution. A value lower than 5 disables the cache.")
        public int servletresolver_cacheSize() default 200;

        @AttributeDefinition(name="Execution Paths", description="The paths to search for executable scripts. If no path is configured this is treated like the default (/ = root) which allows to execute all scripts. By configuring some paths the execution of scripts can be limited. If a configured value ends with a slash, the whole sub tree is allowed. Without a slash an exact matching script is allowed.")
        public String[] servletresolver_paths() default {"/"};

        @AttributeDefinition(name="Default Extensions", description="The list of extensions for which the default behavior will be used. This means that the last path segment of the resource type can be used as the script name.")
        public String[] servletresolver_defaultExtensions() default {"html"};
    }
}

