/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.Chunk;
import org.apache.sling.servlets.post.impl.helper.DefaultNodeNameGenerator;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.apache.sling.servlets.post.impl.operations.AbstractPostOperation;

abstract class AbstractCreateOperation
extends AbstractPostOperation {
    private final Random randomCollisionIndex = new Random();
    private NodeNameGenerator defaultNodeNameGenerator = new DefaultNodeNameGenerator();
    private NodeNameGenerator[] extraNodeNameGenerators;
    private Pattern ignoredParameterNamePattern = null;

    protected AbstractCreateOperation() {
    }

    public void setDefaultNodeNameGenerator(NodeNameGenerator defaultNodeNameGenerator) {
        this.defaultNodeNameGenerator = defaultNodeNameGenerator;
    }

    public void setExtraNodeNameGenerators(NodeNameGenerator[] extraNodeNameGenerators) {
        this.extraNodeNameGenerators = extraNodeNameGenerators;
    }

    public void setIgnoredParameterNamePattern(Pattern ignoredParameterNamePattern) {
        this.ignoredParameterNamePattern = ignoredParameterNamePattern;
    }

    private final boolean requireItemPathPrefix(SlingHttpServletRequest request) {
        boolean requirePrefix = false;
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements() && !requirePrefix) {
            String name = (String)names.nextElement();
            requirePrefix = name.startsWith("./");
        }
        return requirePrefix;
    }

    private boolean hasItemPathPrefix(String name) {
        return name.startsWith("/") || name.startsWith("./") || name.startsWith("../");
    }

    protected void processCreate(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, PostResponse response, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        String path = response.getPath();
        Resource resource = resolver.getResource(path);
        if (resource == null || ResourceUtil.isSyntheticResource((Resource)resource)) {
            this.deepGetOrCreateResource(resolver, path, reqProperties, changes, versioningConfiguration);
            response.setCreateRequest(true);
        } else {
            this.updateNodeType(resolver, path, reqProperties, changes, versioningConfiguration);
            this.updateMixins(resolver, path, reqProperties, changes, versioningConfiguration);
        }
    }

    protected void updateNodeType(ResourceResolver resolver, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        Resource rsrc;
        ModifiableValueMap mvm;
        String nodeType = this.getPrimaryType(reqProperties, path);
        if (nodeType != null && (mvm = (ModifiableValueMap)(rsrc = resolver.getResource(path)).adaptTo(ModifiableValueMap.class)) != null) {
            boolean wasVersionable;
            Object node = this.jcrSupport.getNode(rsrc);
            boolean bl = wasVersionable = node == null ? false : this.jcrSupport.isVersionable(rsrc);
            if (node != null) {
                this.jcrSupport.checkoutIfNecessary(rsrc, changes, versioningConfiguration);
                this.jcrSupport.setPrimaryNodeType(node, nodeType);
            } else {
                mvm.put((Object)"jcr:primaryType", (Object)nodeType);
            }
            if (node != null && !wasVersionable && versioningConfiguration.isCheckinOnNewVersionableNode() && this.jcrSupport.isVersionable(rsrc)) {
                changes.add(Modification.onCheckout(path));
            }
        }
    }

    protected void updateMixins(ResourceResolver resolver, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        Resource rsrc;
        ModifiableValueMap mvm;
        String[] mixins = this.getMixinTypes(reqProperties, path);
        if (mixins != null && (mvm = (ModifiableValueMap)(rsrc = resolver.getResource(path)).adaptTo(ModifiableValueMap.class)) != null) {
            this.jcrSupport.checkoutIfNecessary(rsrc, changes, versioningConfiguration);
            mvm.put((Object)"jcr:mixinTypes", (Object)mixins);
            for (String mixin : mixins) {
                if (!mixin.equals("mix:versionable") || !versioningConfiguration.isCheckinOnNewVersionableNode()) continue;
                changes.add(Modification.onCheckout(path));
            }
        }
    }

    protected Map<String, RequestProperty> collectContent(SlingHttpServletRequest request, PostResponse response) {
        boolean requireItemPrefix = this.requireItemPathPrefix(request);
        LinkedHashMap<String, RequestProperty> reqProperties = new LinkedHashMap<String, RequestProperty>();
        for (Map.Entry e : request.getRequestParameterMap().entrySet()) {
            Chunk chunk;
            String sourcePath;
            RequestProperty prop;
            String paramName = (String)e.getKey();
            if (this.ignoreParameter(paramName) || requireItemPrefix && !this.hasItemPathPrefix(paramName)) continue;
            String propPath = this.toPropertyPath(paramName, response);
            if (propPath.endsWith("@TypeHint")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@TypeHint");
                RequestParameter[] rp = (RequestParameter[])e.getValue();
                if (rp.length <= 0) continue;
                prop.setTypeHintValue(rp[0].getString());
                continue;
            }
            if (propPath.endsWith("@DefaultValue")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@DefaultValue");
                prop.setDefaultValues((RequestParameter[])e.getValue());
                continue;
            }
            if (propPath.endsWith("@ValueFrom")) {
                String refName;
                RequestParameter[] refValues;
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@ValueFrom");
                if (((RequestParameter[])e.getValue()).length != 1 || (refValues = request.getRequestParameters(refName = ((RequestParameter[])e.getValue())[0].getString())) == null) continue;
                prop.setValues(refValues);
                continue;
            }
            if (propPath.endsWith("@Delete")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Delete");
                prop.setDelete(true);
                continue;
            }
            if (propPath.endsWith("@MoveFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@MoveFrom");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                sourcePath = ((RequestParameter[])e.getValue())[0].getString();
                prop.setRepositorySource(sourcePath, true);
                continue;
            }
            if (propPath.endsWith("@CopyFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@CopyFrom");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                sourcePath = ((RequestParameter[])e.getValue())[0].getString();
                prop.setRepositorySource(sourcePath, false);
                continue;
            }
            if (propPath.endsWith("@IgnoreBlanks")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@IgnoreBlanks");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                prop.setIgnoreBlanks(true);
                continue;
            }
            if (propPath.endsWith("@UseDefaultWhenMissing")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@UseDefaultWhenMissing");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                prop.setUseDefaultWhenMissing(true);
                continue;
            }
            if (propPath.endsWith("@Patch")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Patch");
                prop.setPatch(true);
                continue;
            }
            if (propPath.endsWith("@Offset")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Offset");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                chunk = prop.getChunk();
                if (chunk == null) {
                    chunk = new Chunk();
                }
                chunk.setOffsetValue(Long.parseLong(((RequestParameter[])e.getValue())[0].toString()));
                prop.setChunk(chunk);
                continue;
            }
            if (propPath.endsWith("@Completed")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Completed");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                chunk = prop.getChunk();
                if (chunk == null) {
                    chunk = new Chunk();
                }
                chunk.setCompleted(Boolean.parseBoolean(((RequestParameter[])e.getValue())[0].toString()));
                prop.setChunk(chunk);
                continue;
            }
            if (propPath.endsWith("@Length")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Length");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                chunk = prop.getChunk();
                if (chunk == null) {
                    chunk = new Chunk();
                }
                chunk.setLength(Long.parseLong(((RequestParameter[])e.getValue())[0].toString()));
                prop.setChunk(chunk);
                continue;
            }
            prop = this.getOrCreateRequestProperty(reqProperties, propPath, null);
            prop.setValues((RequestParameter[])e.getValue());
        }
        return reqProperties;
    }

    private boolean ignoreParameter(String paramName) {
        if (paramName.startsWith(":")) {
            return true;
        }
        if (paramName.equals("_charset_")) {
            return true;
        }
        return this.ignoredParameterNamePattern != null && this.ignoredParameterNamePattern.matcher(paramName).matches();
    }

    private String toPropertyPath(String paramName, PostResponse response) {
        if (!paramName.startsWith("/")) {
            paramName = ResourceUtil.normalize((String)(response.getPath() + "/" + paramName));
        }
        return paramName;
    }

    private RequestProperty getOrCreateRequestProperty(Map<String, RequestProperty> props, String paramName, String suffix) {
        RequestProperty prop;
        if (suffix != null && paramName.endsWith(suffix)) {
            paramName = paramName.substring(0, paramName.length() - suffix.length());
        }
        if ((prop = props.get(paramName)) == null) {
            prop = new RequestProperty(paramName);
            props.put(paramName, prop);
        }
        return prop;
    }

    protected Resource deepGetOrCreateResource(ResourceResolver resolver, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deep-creating resource '{}'", (Object)path);
        }
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("path must be an absolute path.");
        }
        String startingResourcePath = path;
        Resource startingResource = null;
        while (startingResource == null) {
            if (startingResourcePath.equals("/")) {
                startingResource = resolver.getResource("/");
                if (startingResource != null) continue;
                throw new PersistenceException("Access denied for root resource, resource can't be created: " + path);
            }
            Resource r = resolver.getResource(startingResourcePath);
            if (r != null && !ResourceUtil.isSyntheticResource((Resource)r)) {
                startingResource = resolver.getResource(startingResourcePath);
                this.updateNodeType(resolver, startingResourcePath, reqProperties, changes, versioningConfiguration);
                this.updateMixins(resolver, startingResourcePath, reqProperties, changes, versioningConfiguration);
                continue;
            }
            int pos = startingResourcePath.lastIndexOf(47);
            if (pos > 0) {
                startingResourcePath = startingResourcePath.substring(0, pos);
                continue;
            }
            startingResourcePath = "/";
        }
        if (startingResourcePath.length() == path.length()) {
            return startingResource;
        }
        int from = startingResourcePath.length() == 1 ? 1 : startingResourcePath.length() + 1;
        Resource resource = startingResource;
        while (from > 0) {
            int to = path.indexOf(47, from);
            String name = to < 0 ? path.substring(from) : path.substring(from, to);
            Resource child = resource.getChild(name);
            if (child != null && !ResourceUtil.isSyntheticResource((Resource)child)) {
                resource = child;
                this.updateNodeType(resolver, resource.getPath(), reqProperties, changes, versioningConfiguration);
                this.updateMixins(resolver, resource.getPath(), reqProperties, changes, versioningConfiguration);
            } else {
                String tmpPath = to < 0 ? path : path.substring(0, to);
                String nodeType = this.getPrimaryType(reqProperties, tmpPath);
                this.jcrSupport.checkoutIfNecessary(resource, changes, versioningConfiguration);
                try {
                    String[] mixinTypes;
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    if (nodeType != null) {
                        props.put("jcr:primaryType", nodeType);
                    }
                    if ((mixinTypes = this.getMixinTypes(reqProperties, tmpPath)) != null) {
                        props.put("jcr:mixinTypes", mixinTypes);
                    }
                    resource = resolver.create(resource, name, props);
                }
                catch (PersistenceException e) {
                    this.log.error("Unable to create resource named " + name + " in " + resource.getPath());
                    throw e;
                }
                changes.add(Modification.onCreated(resource.getPath()));
            }
            from = to + 1;
        }
        return resource;
    }

    private String getPrimaryType(Map<String, RequestProperty> reqProperties, String path) {
        RequestProperty prop = reqProperties.get(path + "/jcr:primaryType");
        return prop == null ? null : prop.getStringValues()[0];
    }

    private String[] getMixinTypes(Map<String, RequestProperty> reqProperties, String path) {
        RequestProperty prop = reqProperties.get(path + "/jcr:mixinTypes");
        return prop == null || !prop.hasValues() ? null : prop.getStringValues();
    }

    protected String generateName(SlingHttpServletRequest request, String basePath) throws PersistenceException {
        RequestParameterMap parameters = request.getRequestParameterMap();
        RequestParameter specialParam = parameters.getValue(":name");
        if (specialParam != null && specialParam.getString() != null && specialParam.getString().length() > 0) {
            basePath = (String)basePath + "/" + specialParam.getString();
            if (request.getResourceResolver().getResource((String)basePath) != null) {
                throw new PersistenceException("Collision in node names for path=" + (String)basePath);
            }
            return basePath;
        }
        boolean requirePrefix = this.requireItemPathPrefix(request);
        String generatedName = null;
        if (this.extraNodeNameGenerators != null) {
            NodeNameGenerator generator;
            NodeNameGenerator[] nodeNameGeneratorArray = this.extraNodeNameGenerators;
            int n = nodeNameGeneratorArray.length;
            for (int i = 0; i < n && (generatedName = (generator = nodeNameGeneratorArray[i]).getNodeName(request, (String)basePath, requirePrefix, this.defaultNodeNameGenerator)) == null; ++i) {
            }
        }
        if (generatedName == null) {
            generatedName = this.defaultNodeNameGenerator.getNodeName(request, (String)basePath, requirePrefix, this.defaultNodeNameGenerator);
        }
        basePath = (String)basePath + "/" + generatedName;
        basePath = this.ensureUniquePath(request, (String)basePath);
        return basePath;
    }

    private String ensureUniquePath(SlingHttpServletRequest request, String basePath) throws PersistenceException {
        ResourceResolver resolver = request.getResourceResolver();
        int MAX_TRIES = 1000;
        if (resolver.getResource((String)basePath) != null) {
            for (int i = 0; i < 1000; ++i) {
                int uniqueIndex = Math.abs(this.randomCollisionIndex.nextInt());
                String newPath = (String)basePath + "_" + uniqueIndex;
                if (resolver.getResource(newPath) != null) continue;
                basePath = (String)basePath + "_" + uniqueIndex;
                basePath = newPath;
                break;
            }
            if (resolver.getResource((String)basePath) != null) {
                throw new PersistenceException("Collision in generated node names under " + (String)basePath + ", generated path " + (String)basePath + " already exists");
            }
        }
        return basePath;
    }
}

