/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.wrappers.SlingRequestPaths;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.exceptions.PreconditionViolatedPersistenceException;
import org.apache.sling.servlets.post.exceptions.TemporaryPersistenceException;
import org.apache.sling.servlets.post.impl.helper.JCRSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPostOperation
implements PostOperation {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final JCRSupport jcrSsupport = JCRSupport.INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) throws PreconditionViolatedPersistenceException, TemporaryPersistenceException {
        VersioningConfiguration versionableConfiguration = this.getVersioningConfiguration(request);
        try {
            String path = this.getResourcePath(request);
            response.setPath(path);
            response.setLocation(this.externalizePath(request, path));
            path = ResourceUtil.getParent((String)path);
            if (path != null) {
                response.setParentLocation(this.externalizePath(request, path));
            }
            ArrayList<Modification> changes = new ArrayList<Modification>();
            this.doRun(request, response, changes);
            if (processors != null) {
                for (SlingPostProcessor slingPostProcessor : processors) {
                    slingPostProcessor.process(request, changes);
                }
            }
            HashMap<String, String> modificationSourcesContainingPostfix = new HashMap<String, String>();
            HashSet<String> allModificationSources = new HashSet<String>(changes.size());
            for (Modification modification : changes) {
                String source = modification.getSource();
                if (source == null) continue;
                allModificationSources.add(source);
                int atIndex = source.indexOf(64);
                if (atIndex <= 0) continue;
                modificationSourcesContainingPostfix.put(source.substring(0, atIndex), source);
            }
            if (modificationSourcesContainingPostfix.size() > 0) {
                for (Map.Entry entry : modificationSourcesContainingPostfix.entrySet()) {
                    if (!allModificationSources.contains(entry.getKey())) continue;
                    response.setStatus(500, "Postfix-containing path " + (String)entry.getValue() + " contained in the modification list. Check configuration.");
                    return;
                }
            }
            LinkedHashSet<String> nodesToCheckin = new LinkedHashSet<String>();
            for (Modification change : changes) {
                switch (change.getType()) {
                    case MODIFY: {
                        response.onModified(change.getSource());
                        break;
                    }
                    case DELETE: {
                        response.onDeleted(change.getSource());
                        break;
                    }
                    case MOVE: {
                        response.onMoved(change.getSource(), change.getDestination());
                        break;
                    }
                    case COPY: {
                        response.onCopied(change.getSource(), change.getDestination());
                        break;
                    }
                    case CREATE: {
                        response.onCreated(change.getSource());
                        if (!versionableConfiguration.isCheckinOnNewVersionableNode()) break;
                        nodesToCheckin.add(change.getSource());
                        break;
                    }
                    case ORDER: {
                        response.onChange("ordered", change.getSource(), change.getDestination());
                        break;
                    }
                    case CHECKOUT: {
                        response.onChange("checkout", change.getSource());
                        nodesToCheckin.add(change.getSource());
                        break;
                    }
                    case CHECKIN: {
                        response.onChange("checkin", change.getSource());
                        nodesToCheckin.remove(change.getSource());
                        break;
                    }
                    case RESTORE: {
                        response.onChange("restore", change.getSource());
                    }
                }
            }
            if (this.isResourceResolverCommitRequired(request)) {
                request.getResourceResolver().commit();
            }
            if (!this.isSkipCheckin(request)) {
                for (String checkinPath : nodesToCheckin) {
                    if (!this.jcrSsupport.checkin(request.getResourceResolver().getResource(checkinPath))) continue;
                    response.onChange("checkin", checkinPath);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Exception during response processing.", (Throwable)e);
            response.setError(e);
        }
        finally {
            if (this.isResourceResolverCommitRequired(request)) {
                request.getResourceResolver().revert();
            }
        }
    }

    protected abstract void doRun(SlingHttpServletRequest var1, PostResponse var2, List<Modification> var3) throws PersistenceException;

    protected VersioningConfiguration getVersioningConfiguration(SlingHttpServletRequest request) {
        VersioningConfiguration versionableConfiguration = (VersioningConfiguration)request.getAttribute(VersioningConfiguration.class.getName());
        return versionableConfiguration != null ? versionableConfiguration : new VersioningConfiguration();
    }

    protected boolean isSkipCheckin(SlingHttpServletRequest request) {
        return !this.getVersioningConfiguration(request).isAutoCheckin();
    }

    private boolean isSkipSessionHandling(SlingHttpServletRequest request) {
        return Boolean.parseBoolean((String)request.getAttribute("skip-session-handling"));
    }

    private boolean isResourceResolverCommitRequired(SlingHttpServletRequest request) {
        return !this.isSkipSessionHandling(request) && request.getResourceResolver().hasChanges();
    }

    protected Iterator<Resource> getApplyToResources(SlingHttpServletRequest request) {
        String[] applyTo = request.getParameterValues(":applyTo");
        if (applyTo == null) {
            return null;
        }
        return new ApplyToIterator(request, applyTo);
    }

    protected final String externalizePath(SlingHttpServletRequest request, String path) {
        StringBuilder ret = new StringBuilder();
        ret.append(SlingRequestPaths.getContextPath((HttpServletRequest)request));
        ret.append(request.getResourceResolver().map(path));
        String ext = request.getParameter(":displayExtension");
        if (ext != null && ext.length() > 0) {
            if (ext.charAt(0) != '.') {
                ret.append('.');
            }
            ret.append(ext);
        }
        return ret.toString();
    }

    protected String getResourcePath(SlingHttpServletRequest request) {
        return request.getResource().getPath();
    }

    private static class ApplyToIterator
    implements Iterator<Resource> {
        private final ResourceResolver resolver;
        private final Resource baseResource;
        private final String[] paths;
        private int pathIndex;
        private Resource nextResource;
        private Iterator<Resource> resourceIterator = null;

        ApplyToIterator(SlingHttpServletRequest request, String[] paths) {
            this.resolver = request.getResourceResolver();
            this.baseResource = request.getResource();
            this.paths = paths;
            this.pathIndex = 0;
            this.nextResource = this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.nextResource != null;
        }

        @Override
        public Resource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Resource result = this.nextResource;
            this.nextResource = this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Resource seek() {
            if (this.resourceIterator != null) {
                if (this.resourceIterator.hasNext()) {
                    Resource res = this.resourceIterator.next();
                    return res;
                }
                this.resourceIterator = null;
            }
            while (this.pathIndex < this.paths.length) {
                Resource res;
                String path = this.paths[this.pathIndex];
                ++this.pathIndex;
                if (path.endsWith("*")) {
                    if (path.length() == 1) {
                        this.resourceIterator = this.baseResource.listChildren();
                    } else if (path.endsWith("/*")) {
                        if ((path = path.substring(0, path.length() - 2)).length() == 0) {
                            this.resourceIterator = this.baseResource.listChildren();
                        } else {
                            res = this.resolver.getResource(this.baseResource, path);
                            if (res != null) {
                                this.resourceIterator = res.listChildren();
                            }
                        }
                    }
                    if (this.resourceIterator == null) continue;
                    if (this.resourceIterator.hasNext()) {
                        res = this.resourceIterator.next();
                        return res;
                    }
                    this.resourceIterator = null;
                    continue;
                }
                res = this.resolver.getResource(this.baseResource, path);
                if (res == null) continue;
                return res;
            }
            return null;
        }
    }
}

