/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.JCRSupportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSupport {
    public static final JCRSupport INSTANCE = new JCRSupport();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object supportImpl;

    public JCRSupport() {
        JCRSupportImpl impl = null;
        try {
            impl = new JCRSupportImpl();
        }
        catch (Throwable t) {
            this.logger.warn("Support for JCR operations like checkin, checkout, import, ordering etc. is currently disabled in the servlets post module. Check whether the JCR API is available.");
        }
        this.supportImpl = impl;
    }

    public void orderNode(SlingHttpServletRequest request, Resource resource, List<Modification> changes) throws PersistenceException {
        if (this.supportImpl != null) {
            ((JCRSupportImpl)this.supportImpl).orderNode(request, resource, changes);
        }
    }

    public boolean checkin(Resource rsrc) throws PersistenceException {
        if (rsrc != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).checkin(rsrc);
        }
        return false;
    }

    public void checkoutIfNecessary(Resource rsrc, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException {
        if (rsrc != null && this.supportImpl != null) {
            ((JCRSupportImpl)this.supportImpl).checkoutIfNecessary(rsrc, changes, versioningConfiguration);
        }
    }

    public boolean isNode(Resource rsrc) {
        if (rsrc != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isNode(rsrc);
        }
        return false;
    }

    public boolean isVersionable(Resource rsrc) throws PersistenceException {
        if (this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isVersionable(rsrc);
        }
        return false;
    }

    public boolean isNodeType(Resource rsrc, String typeHint) {
        if (rsrc != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isNodeType(rsrc, typeHint);
        }
        return false;
    }

    public Boolean isFileNodeType(ResourceResolver resolver, String nodeType) {
        if (this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isFileNodeType(resolver, nodeType);
        }
        return false;
    }

    public boolean isPropertyProtectedOrNewAutoCreated(Object node, String name) throws PersistenceException {
        if (node != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isPropertyProtectedOrNewAutoCreated(node, name);
        }
        return false;
    }

    public boolean isPropertyMandatory(Object node, String name) throws PersistenceException {
        if (node != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isPropertyMandatory(node, name);
        }
        return false;
    }

    public boolean isPropertyMultiple(Object node, String name) throws PersistenceException {
        if (node != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isPropertyMultiple(node, name);
        }
        return false;
    }

    public boolean isNewNode(Object node) {
        if (node != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).isNewNode(node);
        }
        return true;
    }

    public Integer getPropertyType(Object node, String name) throws PersistenceException {
        if (node != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).getPropertyType(node, name);
        }
        return null;
    }

    public boolean hasSession(ResourceResolver resolver) {
        if (this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).hasSession(resolver);
        }
        return false;
    }

    public Modification storeAsReference(Resource resource, Object node, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        if (node != null && this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).storeAsReference(node, name, values, type, multiValued);
        }
        throw new PersistenceException("Resource " + resource.getPath() + " does not support reference properties.", null, resource.getPath(), name);
    }

    public void setTypedProperty(Object n, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        if (n == null || this.supportImpl == null) {
            throw new PersistenceException("Property should be stored through JCR but JCR support is not available");
        }
        ((JCRSupportImpl)this.supportImpl).setTypedProperty(n, name, values, type, multiValued);
    }

    public Object getNode(Resource rsrc) {
        if (this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).getNode(rsrc);
        }
        return null;
    }

    public Object getItem(Resource rsrc) {
        if (this.supportImpl != null) {
            return ((JCRSupportImpl)this.supportImpl).getItem(rsrc);
        }
        return null;
    }

    public void setPrimaryNodeType(Object node, String type) throws PersistenceException {
        if (node == null || this.supportImpl == null) {
            throw new PersistenceException("Node type should be set but JCR support is not available");
        }
        ((JCRSupportImpl)this.supportImpl).setPrimaryNodeType(node, type);
    }

    public String copy(Object src, Object dstParent, String name) throws PersistenceException {
        return ((JCRSupportImpl)this.supportImpl).copy(src, dstParent, name);
    }

    public void move(Object src, Object dstParent, String name) throws PersistenceException {
        ((JCRSupportImpl)this.supportImpl).move(src, dstParent, name);
    }

    public boolean jcrEnabled() {
        return this.supportImpl != null;
    }
}

