/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.servlets.post.HtmlResponse;
import org.apache.sling.servlets.post.JSONResponse;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.exceptions.PreconditionViolatedPersistenceException;
import org.apache.sling.servlets.post.impl.ErrorHandlingPostResponseWrapper;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.DefaultNodeNameGenerator;
import org.apache.sling.servlets.post.impl.helper.JCRSupport;
import org.apache.sling.servlets.post.impl.helper.MediaRangeList;
import org.apache.sling.servlets.post.impl.operations.CheckinOperation;
import org.apache.sling.servlets.post.impl.operations.CheckoutOperation;
import org.apache.sling.servlets.post.impl.operations.CopyOperation;
import org.apache.sling.servlets.post.impl.operations.DeleteOperation;
import org.apache.sling.servlets.post.impl.operations.ImportOperation;
import org.apache.sling.servlets.post.impl.operations.ModifyOperation;
import org.apache.sling.servlets.post.impl.operations.MoveOperation;
import org.apache.sling.servlets.post.impl.operations.NopOperation;
import org.apache.sling.servlets.post.impl.operations.RestoreOperation;
import org.apache.sling.servlets.post.impl.operations.StreamedUploadOperation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Sling Post Servlet", "service.vendor=The Apache Software Foundation", "sling.servlet.prefix:Integer=-1", "sling.servlet.paths=sling/servlet/default/POST"})
@Designate(ocd=Config.class)
public class SlingPostServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1837674988291697074L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAM_CHECKIN_ON_CREATE = ":checkinNewVersionableNodes";
    private static final String PARAM_AUTO_CHECKOUT = ":autoCheckout";
    private static final String PARAM_AUTO_CHECKIN = ":autoCheckin";
    private final ModifyOperation modifyOperation = new ModifyOperation();
    private final StreamedUploadOperation streamedUploadOperation = new StreamedUploadOperation();
    private ServiceRegistration<PostOperation>[] internalOperations;
    private final Map<String, PostOperation> postOperations = new HashMap<String, PostOperation>();
    private final List<PostProcessorHolder> postProcessors = new ArrayList<PostProcessorHolder>();
    private SlingPostProcessor[] cachedPostProcessors = new SlingPostProcessor[0];
    private final List<NodeNameGeneratorHolder> nodeNameGenerators = new ArrayList<NodeNameGeneratorHolder>();
    private NodeNameGenerator[] cachedNodeNameGenerators = new NodeNameGenerator[0];
    private final List<PostResponseCreatorHolder> postResponseCreators = new ArrayList<PostResponseCreatorHolder>();
    private PostResponseCreator[] cachedPostResponseCreators = new PostResponseCreator[0];
    private VersioningConfiguration baseVersioningConfiguration;
    private ImportOperation importOperation;
    private boolean backwardsCompatibleStatuscode;
    private static final Pattern REDIRECT_WITH_SCHEME_PATTERN = Pattern.compile("^(https?://[^/]+)(.*)$");

    public SlingPostServlet() {
        if (JCRSupport.INSTANCE.jcrEnabled()) {
            try {
                this.importOperation = new ImportOperation();
            }
            catch (Throwable t) {
                this.log.warn("Support for JCR operations like checkin, checkout, import, ordering etc. is currently disabled in the servlets post module. Check whether the JCR API is available.", t);
            }
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        VersioningConfiguration localVersioningConfig = this.createRequestVersioningConfiguration(request);
        request.setAttribute(VersioningConfiguration.class.getName(), (Object)localVersioningConfig);
        PostResponse htmlResponse = this.createPostResponse(request);
        htmlResponse.setReferer(request.getHeader("referer"));
        PostOperation operation = this.getSlingPostOperation(request);
        if (operation == null) {
            htmlResponse.setStatus(500, "Invalid operation specified for POST request");
        } else {
            request.getRequestProgressTracker().log("Calling PostOperation: {0}", new Object[]{operation.getClass().getName()});
            SlingPostProcessor[] processors = this.cachedPostProcessors;
            try {
                operation.run(request, htmlResponse, processors);
            }
            catch (ResourceNotFoundException rnfe) {
                htmlResponse.setStatus(404, rnfe.getMessage());
            }
            catch (PreconditionViolatedPersistenceException e) {
                this.log.warn("Exception while handling POST {} with {}", (Object)new Object[]{request.getResource().getPath(), operation.getClass().getName()}, (Object)e);
                if (this.backwardsCompatibleStatuscode) {
                    htmlResponse.setError((Throwable)((Object)e));
                } else {
                    htmlResponse.setStatus(422, "invalid payload");
                }
            }
            catch (PersistenceException e) {
                this.log.warn("Exception while handling POST {} with {}", (Object)new Object[]{request.getResource().getPath(), operation.getClass().getName()}, (Object)e);
                if (this.backwardsCompatibleStatuscode) {
                    htmlResponse.setError(e);
                } else {
                    htmlResponse.setStatus(409, "repository state conflicting with request");
                }
            }
            catch (Exception exception) {
                this.log.warn("Exception while handling POST {} with {}", (Object)new Object[]{request.getResource().getPath(), operation.getClass().getName()}, (Object)exception);
                htmlResponse.setError(exception);
            }
        }
        if (htmlResponse.isSuccessful() && this.redirectIfNeeded(request, htmlResponse, response)) {
            return;
        }
        htmlResponse.send((HttpServletResponse)response, this.isSetStatus(request));
    }

    boolean redirectIfNeeded(SlingHttpServletRequest request, PostResponse htmlResponse, SlingHttpServletResponse response) throws IOException {
        String redirectURL = this.getRedirectUrl(request, htmlResponse);
        if (redirectURL != null) {
            String encodedURL;
            Matcher m = REDIRECT_WITH_SCHEME_PATTERN.matcher(redirectURL);
            boolean hasScheme = m.matches();
            if (hasScheme && m.group(2).length() > 0) {
                encodedURL = m.group(1) + response.encodeRedirectURL(m.group(2));
            } else if (hasScheme) {
                encodedURL = redirectURL;
            } else {
                this.log.debug("Request path is [{}]", (Object)request.getPathInfo());
                encodedURL = response.encodeRedirectURL(redirectURL);
            }
            this.log.debug("redirecting to URL [{}] - encoded as [{}]", (Object)redirectURL, (Object)encodedURL);
            response.sendRedirect(encodedURL);
            return true;
        }
        return false;
    }

    PostResponse createPostResponse(SlingHttpServletRequest req) {
        PostResponseCreator creator;
        PostResponse response = null;
        PostResponseCreator[] postResponseCreatorArray = this.cachedPostResponseCreators;
        int n = postResponseCreatorArray.length;
        for (int i = 0; i < n && (response = (creator = postResponseCreatorArray[i]).createPostResponse(req)) == null; ++i) {
        }
        if (response == null) {
            MediaRangeList mediaRangeList = new MediaRangeList((HttpServletRequest)req);
            response = "application/json".equals(mediaRangeList.prefer("text/html", "application/json")) ? new JSONResponse() : new HtmlResponse();
        }
        if (this.isSendError(req)) {
            response = new ErrorHandlingPostResponseWrapper(response);
        }
        return response;
    }

    private boolean isSendError(SlingHttpServletRequest request) {
        boolean sendError = false;
        String sendErrorParam = request.getParameter(":sendError");
        if (sendErrorParam != null && "true".equalsIgnoreCase(sendErrorParam)) {
            sendError = true;
        }
        return sendError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PostOperation getSlingPostOperation(SlingHttpServletRequest request) {
        if (this.streamedUploadOperation.isRequestStreamed(request)) {
            return this.streamedUploadOperation;
        }
        String operation = request.getParameter(":operation");
        if (operation == null || operation.length() == 0) {
            return this.modifyOperation;
        }
        Map<String, PostOperation> map = this.postOperations;
        synchronized (map) {
            return this.postOperations.get(operation);
        }
    }

    protected String getRedirectUrl(SlingHttpServletRequest request, PostResponse ctx) {
        String result = request.getParameter(":redirect");
        if (result != null) {
            try {
                URI redirectUri = new URI(result);
                if (redirectUri.getAuthority() != null) {
                    this.log.warn("redirect target ({}) does include host information ({}). This is not allowed for security reasons!", (Object)result, (Object)redirectUri.getAuthority());
                    return null;
                }
            }
            catch (URISyntaxException e) {
                this.log.warn("given redirect target ({}) is not a valid uri: {}", (Object)result, (Object)e);
                return null;
            }
            this.log.debug("redirect requested as [{}] for path [{}]", (Object)result, (Object)ctx.getPath());
            int star = result.indexOf(42);
            if (star >= 0 && ctx.getPath() != null) {
                String requestPath;
                StringBuilder buf = new StringBuilder();
                if (star > 0) {
                    buf.append(result.substring(0, star));
                }
                buf.append(ResourceUtil.getName((String)ctx.getPath()));
                if (star < result.length() - 1) {
                    buf.append(result.substring(star + 1));
                }
                if ((requestPath = request.getPathInfo()).endsWith("/") && buf.charAt(0) != '/' && !REDIRECT_WITH_SCHEME_PATTERN.matcher(buf).matches()) {
                    buf.insert(0, requestPath);
                }
                result = buf.toString();
            } else if (result.endsWith("/")) {
                result = result.concat(ResourceUtil.getName((String)ctx.getPath()));
            }
            this.log.debug("Will redirect to {}", (Object)result);
        }
        return result;
    }

    protected boolean isSetStatus(SlingHttpServletRequest request) {
        String statusParam = request.getParameter(":status");
        if (statusParam == null) {
            this.log.debug("getStatusMode: Parameter {} not set, assuming standard status code", (Object)":status");
            return true;
        }
        if ("browser".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for user-friendly status code", (Object)":status");
            return false;
        }
        if ("standard".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for standard status code", (Object)":status");
            return true;
        }
        this.log.debug("getStatusMode: Parameter {} set to unknown value {}, assuming standard status code", (Object)":status", (Object)statusParam);
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Config configuration) {
        this.configure(configuration);
        ArrayList<ServiceRegistration<PostOperation>> providedServices = new ArrayList<ServiceRegistration<PostOperation>>();
        providedServices.add(this.registerOperation(bundleContext, "modify", this.modifyOperation));
        providedServices.add(this.registerOperation(bundleContext, "copy", new CopyOperation()));
        providedServices.add(this.registerOperation(bundleContext, "move", new MoveOperation()));
        providedServices.add(this.registerOperation(bundleContext, "delete", new DeleteOperation()));
        providedServices.add(this.registerOperation(bundleContext, "nop", new NopOperation()));
        if (JCRSupport.INSTANCE.jcrEnabled() && this.importOperation != null) {
            providedServices.add(this.registerOperation(bundleContext, "import", this.importOperation));
            providedServices.add(this.registerOperation(bundleContext, "checkin", new CheckinOperation()));
            providedServices.add(this.registerOperation(bundleContext, "checkout", new CheckoutOperation()));
            providedServices.add(this.registerOperation(bundleContext, "restore", new RestoreOperation()));
        }
        this.internalOperations = providedServices.toArray(new ServiceRegistration[providedServices.size()]);
    }

    private ServiceRegistration<PostOperation> registerOperation(BundleContext context, String opCode, PostOperation operation) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("sling.post.operation", opCode);
        properties.put("service.description", "Apache Sling POST Servlet Operation " + opCode);
        properties.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        return context.registerService(PostOperation.class, (Object)operation, properties);
    }

    public void init() throws ServletException {
        this.modifyOperation.setServletContext(this.getServletContext());
        this.streamedUploadOperation.setServletContext(this.getServletContext());
    }

    @Modified
    private void configure(Config configuration) {
        String[] dateFormats;
        this.baseVersioningConfiguration = this.createBaseVersioningConfiguration(configuration);
        DateParser dateParser = new DateParser();
        for (String dateFormat : dateFormats = configuration.servlet_post_dateFormats()) {
            try {
                dateParser.register(dateFormat);
            }
            catch (Throwable t) {
                this.log.warn("configure: Ignoring DateParser format {} because it is invalid: {}", (Object)dateFormat, (Object)t);
            }
        }
        String[] nameHints = configuration.servlet_post_nodeNameHints();
        int nameMax = configuration.servlet_post_nodeNameMaxLength();
        DefaultNodeNameGenerator nodeNameGenerator = new DefaultNodeNameGenerator(nameHints, nameMax);
        String paramMatch = configuration.servlet_post_ignorePattern();
        Pattern paramMatchPattern = Pattern.compile(paramMatch);
        this.modifyOperation.setDateParser(dateParser);
        this.modifyOperation.setDefaultNodeNameGenerator(nodeNameGenerator);
        this.modifyOperation.setIgnoredParameterNamePattern(paramMatchPattern);
        if (this.importOperation != null) {
            this.importOperation.setDefaultNodeNameGenerator(nodeNameGenerator);
            this.importOperation.setIgnoredParameterNamePattern(paramMatchPattern);
        }
        this.backwardsCompatibleStatuscode = configuration.legacy_statuscode_on_persistence_exception();
    }

    public void destroy() {
        this.modifyOperation.setServletContext(null);
        this.streamedUploadOperation.setServletContext(null);
    }

    @Deactivate
    protected void deactivate() {
        if (this.internalOperations != null) {
            for (ServiceRegistration<PostOperation> registration : this.internalOperations) {
                registration.unregister();
            }
            this.internalOperations = null;
        }
        this.modifyOperation.setExtraNodeNameGenerators(null);
        if (this.importOperation != null) {
            this.importOperation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=PostOperation.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostOperation(PostOperation operation, Map<String, Object> properties) {
        String operationName = (String)properties.get("sling.post.operation");
        if (operationName != null && operation != null) {
            Map<String, PostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.put(operationName, operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostOperation(PostOperation operation, Map<String, Object> properties) {
        String operationName = (String)properties.get("sling.post.operation");
        if (operationName != null) {
            Map<String, PostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.remove(operationName);
            }
        }
    }

    private int getRanking(Map<String, Object> properties) {
        Object val = properties.get("service.ranking");
        return val instanceof Integer ? (Integer)val : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=SlingPostProcessor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostProcessor(SlingPostProcessor processor, Map<String, Object> properties) {
        PostProcessorHolder pph = new PostProcessorHolder();
        pph.processor = processor;
        pph.ranking = this.getRanking(properties);
        List<PostProcessorHolder> list = this.postProcessors;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postProcessors.size() && pph.ranking < this.postProcessors.get((int)index).ranking; ++index) {
            }
            if (index == this.postProcessors.size()) {
                this.postProcessors.add(pph);
            } else {
                this.postProcessors.add(index, pph);
            }
            this.updatePostProcessorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostProcessor(SlingPostProcessor processor, Map<String, Object> properties) {
        List<PostProcessorHolder> list = this.postProcessors;
        synchronized (list) {
            Iterator<PostProcessorHolder> i = this.postProcessors.iterator();
            while (i.hasNext()) {
                PostProcessorHolder current = i.next();
                if (current.processor != processor) continue;
                i.remove();
            }
            this.updatePostProcessorCache();
        }
    }

    private void updatePostProcessorCache() {
        SlingPostProcessor[] localCache = new SlingPostProcessor[this.postProcessors.size()];
        int index = 0;
        for (PostProcessorHolder current : this.postProcessors) {
            localCache[index] = current.processor;
            ++index;
        }
        this.cachedPostProcessors = localCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=NodeNameGenerator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindNodeNameGenerator(NodeNameGenerator generator, Map<String, Object> properties) {
        NodeNameGeneratorHolder nngh = new NodeNameGeneratorHolder();
        nngh.generator = generator;
        nngh.ranking = this.getRanking(properties);
        List<NodeNameGeneratorHolder> list = this.nodeNameGenerators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.nodeNameGenerators.size() && nngh.ranking < this.nodeNameGenerators.get((int)index).ranking; ++index) {
            }
            if (index == this.nodeNameGenerators.size()) {
                this.nodeNameGenerators.add(nngh);
            } else {
                this.nodeNameGenerators.add(index, nngh);
            }
            this.updateNodeNameGeneratorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindNodeNameGenerator(NodeNameGenerator generator, Map<String, Object> properties) {
        List<NodeNameGeneratorHolder> list = this.nodeNameGenerators;
        synchronized (list) {
            Iterator<NodeNameGeneratorHolder> i = this.nodeNameGenerators.iterator();
            while (i.hasNext()) {
                NodeNameGeneratorHolder current = i.next();
                if (current.generator != generator) continue;
                i.remove();
            }
            this.updateNodeNameGeneratorCache();
        }
    }

    private void updateNodeNameGeneratorCache() {
        NodeNameGenerator[] localCache = new NodeNameGenerator[this.nodeNameGenerators.size()];
        int index = 0;
        for (NodeNameGeneratorHolder current : this.nodeNameGenerators) {
            localCache[index] = current.generator;
            ++index;
        }
        this.cachedNodeNameGenerators = localCache;
        this.modifyOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        if (this.importOperation != null) {
            this.importOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=PostResponseCreator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        PostResponseCreatorHolder nngh = new PostResponseCreatorHolder();
        nngh.creator = creator;
        nngh.ranking = this.getRanking(properties);
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postResponseCreators.size() && nngh.ranking < this.postResponseCreators.get((int)index).ranking; ++index) {
            }
            if (index == this.postResponseCreators.size()) {
                this.postResponseCreators.add(nngh);
            } else {
                this.postResponseCreators.add(index, nngh);
            }
            this.updatePostResponseCreatorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            Iterator<PostResponseCreatorHolder> i = this.postResponseCreators.iterator();
            while (i.hasNext()) {
                PostResponseCreatorHolder current = i.next();
                if (current.creator != creator) continue;
                i.remove();
            }
            this.updatePostResponseCreatorCache();
        }
    }

    private void updatePostResponseCreatorCache() {
        PostResponseCreator[] localCache = new PostResponseCreator[this.postResponseCreators.size()];
        int index = 0;
        for (PostResponseCreatorHolder current : this.postResponseCreators) {
            localCache[index] = current.creator;
            ++index;
        }
        this.cachedPostResponseCreators = localCache;
    }

    @Reference(service=ContentImporter.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void bindContentImporter(Object importer) {
        if (this.importOperation != null) {
            this.importOperation.setContentImporter(importer);
        }
    }

    protected void unbindContentImporter(Object importer) {
        if (this.importOperation != null) {
            this.importOperation.unsetContentImporter(importer);
        }
    }

    private VersioningConfiguration createBaseVersioningConfiguration(Config config) {
        VersioningConfiguration cfg = new VersioningConfiguration();
        cfg.setCheckinOnNewVersionableNode(config.servlet_post_checkinNewVersionableNodes());
        cfg.setAutoCheckout(config.servlet_post_autoCheckout());
        cfg.setAutoCheckin(config.servlet_post_autoCheckin());
        return cfg;
    }

    private VersioningConfiguration createRequestVersioningConfiguration(SlingHttpServletRequest request) {
        VersioningConfiguration cfg = this.baseVersioningConfiguration.clone();
        String paramValue = request.getParameter(PARAM_CHECKIN_ON_CREATE);
        if (paramValue != null) {
            cfg.setCheckinOnNewVersionableNode(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKOUT)) != null) {
            cfg.setAutoCheckout(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKIN)) != null) {
            cfg.setAutoCheckin(Boolean.parseBoolean(paramValue));
        }
        return cfg;
    }

    private static final class PostResponseCreatorHolder {
        public PostResponseCreator creator;
        public int ranking;

        private PostResponseCreatorHolder() {
        }
    }

    private static final class NodeNameGeneratorHolder {
        public NodeNameGenerator generator;
        public int ranking;

        private NodeNameGeneratorHolder() {
        }
    }

    private static final class PostProcessorHolder {
        public SlingPostProcessor processor;
        public int ranking;

        private PostProcessorHolder() {
        }
    }

    @ObjectClassDefinition(name="Apache Sling POST Servlet", description="The Sling POST Servlet is registered as the default servlet to handle POST requests in Sling.")
    public static @interface Config {
        @AttributeDefinition(name="Date Format", description="List SimpleDateFormat strings for date formats supported for parsing from request input to data fields. The special format \"ISO8601\" (without the quotes) can be used to designate strict ISO-8601 parser which is able to parse strings generated by the Property.getString() method for Date properties. The default value is [ \"EEE MMM dd yyyy HH:mm:ss 'GMT'Z\", \"ISO8601\", \"yyyy-MM-dd'T'HH:mm:ss.SSSZ\", \"yyyy-MM-dd'T'HH:mm:ss\", \"yyyy-MM-dd\", \"dd.MM.yyyy HH:mm:ss\", \"dd.MM.yyyy\" ].")
        public String[] servlet_post_dateFormats() default {"EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "ISO8601", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy"};

        @AttributeDefinition(name="Node Name Hint Properties", description="The list of properties whose values may be used to derive a name for newly created nodes. When handling a request to create a new node, the name of the node is automatically generated if the request URL ends with a star (\"*\") or a slash (\"/\"). In this case the request parameters listed in this configuration value may be used to create the name. Default value is [ \"title\", \"jcr:title\", \"name\", \"description\", \"jcr:description\", \"abstract\", \"text\", \"jcr:text\" ].")
        public String[] servlet_post_nodeNameHints() default {"title", "jcr:title", "name", "description", "jcr:description", "abstract", "text", "jcr:text"};

        @AttributeDefinition(name="Maximum Node Name Length", description="Maximum number of characters to use for automatically generated node names. The default value is 20. Note, that actual node names may be generated with at most 4 more characters if the numeric suffixes must be appended to make the name unique.")
        public int servlet_post_nodeNameMaxLength() default 20;

        @AttributeDefinition(name="Checkin New Versionable Nodes", description="If true, newly created versionable nodes or non-versionable nodes which are made versionable by the addition of the mix:versionable mixin are checked in. By default, false.")
        public boolean servlet_post_checkinNewVersionableNodes() default false;

        @AttributeDefinition(name="Auto Checkout Nodes", description="If true, checked in nodes are checked out when necessary. By default, false.")
        public boolean servlet_post_autoCheckout() default false;

        @AttributeDefinition(name="Auto Checkin Nodes", description="If true, nodes which are checked out by the post servlet are checked in. By default, true.")
        public boolean servlet_post_autoCheckin() default true;

        @AttributeDefinition(name="Ignored Parameters", description="Configures a regular expression pattern to select request parameters which should be ignored when writing content to the repository. By default this is \"j_.*\" thus ignoring all request parameters starting with j_ such as j_username.")
        public String servlet_post_ignorePattern() default "j_.*";

        @AttributeDefinition(name="Backwards compatible statuscode", description="In backwards compatibility mode exceptions will always create a statuscode 500 (see SLING-9896)")
        public boolean legacy_statuscode_on_persistence_exception() default false;
    }
}

