/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PropertyType;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.JCRSupport;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;

public class SlingPropertyValueHandler {
    private static final Map<String, AutoType> AUTO_PROPS = new HashMap<String, AutoType>();
    private final List<Modification> changes;
    private final DateParser dateParser;
    private final JCRSupport jcrSupport;
    private final Calendar now = Calendar.getInstance();

    public SlingPropertyValueHandler(DateParser dateParser, JCRSupport jcrSupport, List<Modification> changes) {
        this.dateParser = dateParser;
        this.jcrSupport = jcrSupport;
        this.changes = changes;
    }

    static AutoType getAutoType(String propertyName) {
        return AUTO_PROPS.get(propertyName);
    }

    public void setProperty(Resource parent, RequestProperty prop) throws PersistenceException {
        Modifiable mod = new Modifiable();
        mod.resource = parent;
        mod.node = this.jcrSupport.getNode(parent);
        mod.valueMap = (ModifiableValueMap)parent.adaptTo(ModifiableValueMap.class);
        if (mod.valueMap == null) {
            throw new PersistenceException("Resource at '" + parent.getPath() + "' is not modifiable.");
        }
        String name = prop.getName();
        if (prop.providesValue()) {
            this.setPropertyAsIs(mod, prop);
        } else if (AUTO_PROPS.containsKey(name)) {
            if (this.jcrSupport.isPropertyProtectedOrNewAutoCreated(mod.node, name)) {
                return;
            }
            boolean isNew = this.jcrSupport.isNewNode(mod.node);
            switch (SlingPropertyValueHandler.getAutoType(name)) {
                case CREATED: {
                    if (!isNew) break;
                    this.setCurrentDate(mod, name);
                    break;
                }
                case CREATED_BY: {
                    if (!isNew) break;
                    this.setCurrentUser(mod, name);
                    break;
                }
                case MODIFIED: {
                    this.setCurrentDate(mod, name);
                    break;
                }
                case MODIFIED_BY: {
                    this.setCurrentUser(mod, name);
                }
            }
        } else {
            this.setPropertyAsIs(mod, prop);
        }
    }

    private void setCurrentDate(Modifiable parent, String name) throws PersistenceException {
        this.removePropertyIfExists(parent, name);
        parent.valueMap.put((Object)name, (Object)this.now);
        this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
    }

    private void setCurrentUser(Modifiable parent, String name) throws PersistenceException {
        this.removePropertyIfExists(parent, name);
        String user = parent.resource.getResourceResolver().getUserID();
        parent.valueMap.put((Object)name, (Object)user);
        this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
    }

    private String removePropertyIfExists(Modifiable parent, String name) throws PersistenceException {
        if (parent.valueMap.containsKey((Object)name) && !this.jcrSupport.isPropertyMandatory(parent.node, name)) {
            parent.valueMap.remove((Object)name);
            return parent.resource.getPath() + '/' + name;
        }
        return null;
    }

    private void setPropertyAsIs(Modifiable parent, RequestProperty prop) throws PersistenceException {
        String[] values = prop.getStringValues();
        if (values == null) {
            this.removeProperty(parent, prop);
        } else if (values.length == 0) {
            this.clearProperty(parent, prop);
        } else {
            if (prop.isPatch() && (values = this.patch(parent, prop.getName(), values)) == null) {
                return;
            }
            boolean multiValue = this.isMultiValue(parent, prop, values);
            int type = this.getType(parent, prop);
            if (multiValue) {
                this.removeIfSingleValueProperty(parent, prop);
            }
            if (this.jcrSupport.hasSession(parent.resource.getResourceResolver()) && (type == 5 ? this.storeAsDate(parent, prop.getName(), values, multiValue) : this.isReferencePropertyType(type) && this.storeAsReference(parent, prop.getName(), values, type, multiValue))) {
                return;
            }
            this.store(parent, prop.getName(), values, type, multiValue);
        }
    }

    private String[] patch(Modifiable parent, String name, String[] values) throws PersistenceException {
        ArrayList<String> oldValues = new ArrayList<String>();
        if (parent.valueMap.containsKey((Object)name)) {
            if (parent.node != null && !this.jcrSupport.isPropertyMultiple(parent.node, name)) {
                return null;
            }
            String[] setValues = (String[])parent.valueMap.get(name, String[].class);
            if (setValues != null) {
                for (String v : setValues) {
                    oldValues.add(v);
                }
            }
        }
        boolean modified = false;
        for (String v : values) {
            if (v == null || v.length() <= 0) continue;
            char op = v.charAt(0);
            String val = v.substring(1);
            if (op == '+') {
                if (oldValues.contains(val)) continue;
                oldValues.add(val);
                modified = true;
                continue;
            }
            if (op != '-') continue;
            while (oldValues.remove(val)) {
                modified = true;
            }
        }
        if (modified) {
            return oldValues.toArray(new String[oldValues.size()]);
        }
        return null;
    }

    private boolean isReferencePropertyType(int propertyType) {
        return propertyType == 9 || propertyType == 10;
    }

    private int getType(Modifiable parent, RequestProperty prop) throws PersistenceException {
        Integer jcrType;
        int type = 0;
        if (prop.getTypeHint() != null) {
            try {
                type = PropertyType.valueFromName((String)prop.getTypeHint());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String[] values = prop.getStringValues();
        if (type == 0 && values != null && values.length > 0 && (jcrType = this.jcrSupport.getPropertyType(parent.node, prop.getName())) != null) {
            type = jcrType;
        }
        return type;
    }

    private boolean isMultiValue(Modifiable parent, RequestProperty prop, String[] values) throws PersistenceException {
        if (values != null && values.length > 1) {
            return true;
        }
        if (prop.hasMultiValueTypeHint()) {
            return true;
        }
        if (prop.isPatch()) {
            return true;
        }
        Object value = parent.valueMap.get((Object)prop.getName());
        if (parent.node != null) {
            if (value != null) {
                return this.jcrSupport.isPropertyMultiple(parent.node, prop.getName());
            }
        } else if (value != null && value.getClass().isArray()) {
            return true;
        }
        return false;
    }

    private void clearProperty(Modifiable parent, RequestProperty prop) throws PersistenceException {
        if (parent.valueMap.containsKey((Object)prop.getName())) {
            if (this.jcrSupport.isPropertyMultiple(parent.node, prop.getName())) {
                String removePath = this.removePropertyIfExists(parent, prop.getName());
                if (removePath != null) {
                    this.changes.add(Modification.onDeleted(removePath));
                }
            } else {
                this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + prop.getName()));
            }
        }
    }

    private void removeProperty(Modifiable parent, RequestProperty prop) throws PersistenceException {
        String removePath = this.removePropertyIfExists(parent, prop.getName());
        if (removePath != null) {
            this.changes.add(Modification.onDeleted(removePath));
        }
    }

    private void removeIfSingleValueProperty(Modifiable parent, RequestProperty prop) throws PersistenceException {
        if (parent.valueMap.containsKey((Object)prop.getName())) {
            if (this.jcrSupport.isPropertyMultiple(parent.node, prop.getName())) {
                return;
            }
            String removePath = this.removePropertyIfExists(parent, prop.getName());
            if (removePath != null) {
                this.changes.add(Modification.onDeleted(removePath));
            }
        }
    }

    private Calendar[] parse(String[] sources) {
        Calendar[] ret = new Calendar[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            Calendar c = this.dateParser.parse(sources[i]);
            if (c == null) {
                return null;
            }
            ret[i] = c;
        }
        return ret;
    }

    private boolean storeAsDate(Modifiable parent, String name, String[] values, boolean multiValued) throws PersistenceException {
        Calendar c;
        if (multiValued) {
            Calendar[] array = this.parse(values);
            if (array != null) {
                parent.valueMap.put((Object)name, (Object)array);
                this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
                return true;
            }
        } else if (values.length >= 1 && (c = this.dateParser.parse(values[0])) != null) {
            parent.valueMap.put((Object)name, (Object)c);
            this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
            return true;
        }
        return false;
    }

    private boolean storeAsReference(Modifiable parent, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        Modification mod = this.jcrSupport.storeAsReference(parent.resource, parent.node, name, values, type, multiValued);
        return mod != null;
    }

    private void store(Modifiable parent, String name, String[] values, int type, boolean multiValued) throws PersistenceException {
        if (parent.node != null && type != 0) {
            this.jcrSupport.setTypedProperty(parent.node, name, values, type, multiValued);
        } else if (multiValued) {
            parent.valueMap.put((Object)name, SlingPropertyValueHandler.toJavaObject(values, type));
        } else if (values.length >= 1) {
            parent.valueMap.put((Object)name, SlingPropertyValueHandler.toJavaObject(values[0], type));
        }
        this.changes.add(Modification.onModified(parent.resource.getPath() + '/' + name));
    }

    private static Object toJavaObject(String value, int type) {
        boolean isEmpty = value == null || value.trim().length() == 0;
        switch (type) {
            case 12: {
                return isEmpty ? BigDecimal.ZERO : new BigDecimal(value);
            }
            case 6: {
                return isEmpty ? Boolean.FALSE : Boolean.valueOf(value);
            }
            case 4: {
                return isEmpty ? 0.0 : Double.valueOf(value);
            }
            case 3: {
                return isEmpty ? 0L : Long.valueOf(value);
            }
        }
        return value;
    }

    private static Object toJavaObject(String[] values, int type) {
        Object[] result = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            result[i] = SlingPropertyValueHandler.toJavaObject(values[i], type);
        }
        return result;
    }

    static {
        AUTO_PROPS.put("created", AutoType.CREATED);
        AUTO_PROPS.put("createdBy", AutoType.CREATED_BY);
        AUTO_PROPS.put("jcr:created", AutoType.CREATED);
        AUTO_PROPS.put("jcr:createdBy", AutoType.CREATED_BY);
        AUTO_PROPS.put("lastModified", AutoType.MODIFIED);
        AUTO_PROPS.put("lastModifiedBy", AutoType.MODIFIED_BY);
        AUTO_PROPS.put("jcr:lastModified", AutoType.MODIFIED);
        AUTO_PROPS.put("jcr:lastModifiedBy", AutoType.MODIFIED_BY);
    }

    public static final class Modifiable {
        public Resource resource;
        public ModifiableValueMap valueMap;
        public Object node;
    }

    private static enum AutoType {
        CREATED,
        CREATED_BY,
        MODIFIED,
        MODIFIED_BY;

    }
}

