/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.get.impl.jackrabbit.ISO8601;
import org.apache.sling.servlets.get.impl.util.JsonObjectCreator;
import org.apache.sling.servlets.get.impl.util.JsonToText;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(name="org.apache.sling.servlets.get.impl.version.VersionInfoServlet", configurationPolicy=ConfigurationPolicy.REQUIRE, service={Servlet.class}, property={"service.description=Version info servlet", "service.vendor=The Apache Software Foundation", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET", "sling.servlet.selectors=V", "sling.servlet.extensions=json"})
@Designate(ocd=Config.class)
public class VersionInfoServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1656887064561951302L;
    private boolean ecmaSupport;
    public static final String TIDY = "tidy";
    public static final String HARRAY = "harray";
    public static final int INDENT_SPACES = 2;
    private final JsonToText renderer = new JsonToText();

    @Activate
    private void activate(Config config) {
        this.ecmaSupport = config.ecmaSuport();
    }

    public void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        boolean tidy = this.hasSelector(req, TIDY);
        boolean harray = this.hasSelector(req, HARRAY);
        JsonToText.Options opt = this.renderer.options().withIndent(tidy ? 2 : 0).withArraysForChildren(harray);
        try {
            VersionManager vm = ((Session)req.getResourceResolver().adaptTo(Session.class)).getWorkspace().getVersionManager();
            resp.getWriter().write(this.renderer.prettyPrint(this.getJsonObject(req.getResource(), vm), opt));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private JsonObject getJsonObject(Resource resource, VersionManager vm) throws RepositoryException {
        JsonObjectBuilder result = Json.createObjectBuilder();
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null || !node.isNodeType("mix:versionable")) {
            return result.build();
        }
        String absPath = resource.getPath();
        VersionHistory history = vm.getVersionHistory(absPath);
        Version baseVersion = vm.getBaseVersion(absPath);
        VersionIterator it = history.getAllVersions();
        while (it.hasNext()) {
            Version v = it.nextVersion();
            JsonObjectBuilder obj = Json.createObjectBuilder();
            obj.add("created", this.createdDate((Node)v));
            obj.add("successors", this.getArrayBuilder(VersionInfoServlet.getNames(v.getSuccessors())));
            obj.add("predecessors", this.getArrayBuilder(VersionInfoServlet.getNames(v.getPredecessors())));
            obj.add("labels", this.getArrayBuilder(history.getVersionLabels(v)));
            obj.add("baseVersion", baseVersion.isSame((Item)v));
            result.add(v.getName(), obj);
        }
        return Json.createObjectBuilder().add("versions", result).build();
    }

    private JsonArrayBuilder getArrayBuilder(String[] values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (String value : values) {
            builder.add(value);
        }
        return builder;
    }

    private JsonArrayBuilder getArrayBuilder(Collection<String> values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (String value : values) {
            builder.add(value);
        }
        return builder;
    }

    private static Collection<String> getNames(Version[] versions) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        for (Version s : versions) {
            result.add(s.getName());
        }
        return result;
    }

    private boolean hasSelector(SlingHttpServletRequest req, String selectorToCheck) {
        for (String selector : req.getRequestPathInfo().getSelectors()) {
            if (!selectorToCheck.equals(selector)) continue;
            return true;
        }
        return false;
    }

    private String createdDate(Node node) throws RepositoryException {
        Calendar cal = node.getProperty("jcr:created").getDate();
        if (this.ecmaSupport) {
            return JsonObjectCreator.formatEcma(cal);
        }
        return ISO8601.format(cal);
    }

    @ObjectClassDefinition(name="Apache Sling Version Info Servlet", description="The Sling Version Info Servlet renders list of versions available for the current resource")
    public static @interface Config {
        @AttributeDefinition(name="Selector", description="List of selectors this servlet handles to display the versions")
        public String[] sling_servlet_selectors() default {"V"};

        @AttributeDefinition(name="Legacy ECMA date format", description="Enable legacy Sling ECMA format for dates")
        public boolean ecmaSuport() default true;
    }
}

