/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.get.impl.jackrabbit.ISO8601;

public class JsonObjectCreator {
    private static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private Resource resource;
    private ValueMap valueMap;
    private boolean ecmaSupport;

    public JsonObjectCreator(Resource resource, boolean ecmaSupport) {
        this.resource = resource;
        this.valueMap = resource.getValueMap();
        this.ecmaSupport = ecmaSupport;
    }

    public JsonObjectBuilder create() {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        if (this.valueMap.isEmpty()) {
            String value = (String)this.resource.adaptTo(String.class);
            if (value != null) {
                obj.add(this.resource.getName(), value.toString());
            } else {
                String[] values = (String[])this.resource.adaptTo(String[].class);
                if (values != null) {
                    JsonArrayBuilder builder = Json.createArrayBuilder();
                    for (String v : values) {
                        builder.add(v);
                    }
                    obj.add(this.resource.getName(), builder);
                }
            }
            return obj;
        }
        for (Map.Entry prop : this.valueMap.entrySet()) {
            this.createProperty(obj, (String)prop.getKey(), prop.getValue());
        }
        return obj;
    }

    public static String formatEcma(Calendar date) {
        SimpleDateFormat formatter = new SimpleDateFormat(ECMA_DATE_FORMAT, DATE_FORMAT_LOCALE);
        formatter.setTimeZone(date.getTimeZone());
        return formatter.format(date.getTime());
    }

    private JsonValue getValue(Object value) {
        if (value instanceof Supplier) {
            return this.getValue(((Supplier)value).get());
        }
        if (value == null) {
            return Json.createValue((String)"");
        }
        if (value instanceof InputStream) {
            return Json.createValue((int)0);
        }
        if (value instanceof Calendar) {
            if (this.ecmaSupport) {
                return Json.createValue((String)JsonObjectCreator.formatEcma((Calendar)value));
            }
            return Json.createValue((String)ISO8601.format((Calendar)value));
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (value instanceof Long) {
            return Json.createValue((long)((Long)value));
        }
        if (value instanceof Double) {
            return Json.createValue((double)((Double)value));
        }
        if (value instanceof String) {
            return Json.createValue((String)((String)value));
        }
        if (value instanceof Integer) {
            return Json.createValue((int)((Integer)value));
        }
        if (value instanceof Short) {
            return Json.createValue((int)((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return Json.createValue((int)((Byte)value).byteValue());
        }
        if (value instanceof Float) {
            return Json.createValue((double)((Float)value).floatValue());
        }
        if (value instanceof Map) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                JsonValue v = this.getValue(entry.getValue());
                builder.add(entry.getKey().toString(), v);
            }
            return builder.build();
        }
        if (value instanceof Collection) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (Object obj : (Collection)value) {
                builder.add(this.getValue(obj));
            }
            return builder.build();
        }
        if (value.getClass().isArray()) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (int i = 0; i < Array.getLength(value); ++i) {
                builder.add(this.getValue(Array.get(value, i)));
            }
            return builder.build();
        }
        return Json.createValue((String)value.toString());
    }

    private void createProperty(JsonObjectBuilder obj, String key, Object value) {
        int i;
        if (value == null) {
            return;
        }
        if (value instanceof Supplier) {
            this.createProperty(obj, key, ((Supplier)value).get());
            return;
        }
        Object[] values = null;
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                obj.add(key, Json.createArrayBuilder());
                return;
            }
            values = new Object[Array.getLength(value)];
            for (i = 0; i < length; ++i) {
                values[i] = Array.get(value, i);
                while (values[i] instanceof Supplier) {
                    values[i] = ((Supplier)values[i]).get();
                }
            }
        }
        if (value instanceof InputStream || values != null && values[0] instanceof InputStream) {
            if (values == null) {
                obj.add(":" + key, this.getLength(-1, key, (InputStream)value));
            } else {
                JsonArrayBuilder result = Json.createArrayBuilder();
                for (i = 0; i < values.length; ++i) {
                    result.add(this.getLength(i, key, (InputStream)values[i]));
                }
                obj.add(":" + key, result);
            }
            return;
        }
        if (values != null) {
            obj.add(key, this.getValue(values));
        } else {
            obj.add(key, this.getValue(value));
        }
    }

    private long getLength(int index, String key, InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (index == -1) {
            return (Long)this.valueMap.get(key, Long.class);
        }
        Long[] lengths = (Long[])this.valueMap.get(key, Long[].class);
        if (lengths != null && lengths.length > index) {
            return lengths[index];
        }
        return -1L;
    }
}

