/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.util;

import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonToText {
    public Options options() {
        return new Options();
    }

    private void indent(StringBuilder sb, int howMuch) {
        for (int i = 0; i < howMuch; ++i) {
            sb.append(' ');
        }
    }

    private String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 2);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private String valueToString(JsonValue value, Options opt) {
        if (value instanceof JsonObject || value instanceof JsonArray) {
            return this.prettyPrint((JsonArray)value, opt);
        }
        return value.toString();
    }

    private boolean skipChildObject(JsonArrayBuilder a, Options opt, String key, Object value) {
        if (opt.arraysForChildren && value instanceof JsonObject) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add(opt.childNameKey, key);
            for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
            }
            a.add(builder);
            return true;
        }
        return false;
    }

    public String prettyPrint(JsonObject jo, Options opt) {
        JsonValue v;
        int n = jo.size();
        if (n == 0) {
            return "{}";
        }
        JsonArrayBuilder children = Json.createArrayBuilder();
        Iterator keys = jo.keySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        int newindent = opt.initialIndent + opt.indent;
        if (n == 1) {
            String o = (String)keys.next();
            if (!this.skipChildObject(children, opt, o, v = (JsonValue)jo.get((Object)o))) {
                sb.append(this.quote(o));
                sb.append(": ");
                sb.append(this.valueToString(v, opt));
            }
        } else {
            while (keys.hasNext()) {
                String o = (String)keys.next();
                if (this.skipChildObject(children, opt, o, v = (JsonValue)jo.get((Object)o))) continue;
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                this.indent(sb, newindent);
                sb.append(this.quote(o.toString()));
                sb.append(": ");
                sb.append(this.valueToString(v, this.options().withIndent(opt.indent).withInitialIndent(newindent)));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                this.indent(sb, newindent);
            }
        }
        JsonArray childrenArray = children.build();
        if (childrenArray.size() > 0) {
            if (sb.length() > 1) {
                sb.append(",\n");
            } else {
                sb.append('\n');
            }
            Options childOpt = new Options(opt);
            childOpt.withInitialIndent(childOpt.initialIndent + newindent);
            this.indent(sb, childOpt.initialIndent);
            sb.append(this.quote(opt.childrenKey)).append(":");
            sb.append(this.prettyPrint(childrenArray, childOpt));
        }
        sb.append('}');
        return sb.toString();
    }

    public String prettyPrint(JsonArray ja, Options opt) {
        int len = ja.size();
        if (len == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        if (len == 1) {
            sb.append(this.valueToString((JsonValue)ja.get(0), opt));
        } else {
            int newindent = opt.initialIndent + opt.indent;
            if (opt.hasIndent()) {
                sb.append('\n');
            }
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                    if (opt.hasIndent()) {
                        sb.append('\n');
                    }
                }
                this.indent(sb, newindent);
                sb.append(this.valueToString((JsonValue)ja.get(i), opt));
            }
            if (opt.hasIndent()) {
                sb.append('\n');
            }
            this.indent(sb, opt.initialIndent);
        }
        sb.append(']');
        return sb.toString();
    }

    public static class Options {
        int indent;
        private boolean indentIsPositive;
        int initialIndent;
        boolean arraysForChildren;
        public static final String DEFAULT_CHILDREN_KEY = "__children__";
        public static final String DEFAULT_CHILD_NAME_KEY = "__name__";
        String childrenKey = "__children__";
        String childNameKey = "__name__";

        private Options() {
        }

        Options(Options opt) {
            this.indent = opt.indent;
            this.indentIsPositive = opt.indentIsPositive;
            this.initialIndent = opt.initialIndent;
            this.arraysForChildren = opt.arraysForChildren;
        }

        public Options withIndent(int n) {
            this.indent = n;
            this.indentIsPositive = this.indent > 0;
            return this;
        }

        public Options withInitialIndent(int n) {
            this.initialIndent = n;
            return this;
        }

        public Options withArraysForChildren(boolean b) {
            this.arraysForChildren = b;
            return this;
        }

        public Options withChildNameKey(String key) {
            this.childNameKey = key;
            return this;
        }

        public Options withChildrenKey(String key) {
            this.childrenKey = key;
            return this;
        }

        boolean hasIndent() {
            return this.indentIsPositive;
        }
    }
}

