/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class JsonObjectCreator {
    private static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private Resource resource;
    private ValueMap valueMap;
    private boolean ecmaSupport;

    public JsonObjectCreator(Resource resource, boolean ecmaSupport) {
        this.resource = resource;
        this.valueMap = resource.getValueMap();
        this.ecmaSupport = ecmaSupport;
    }

    public JsonObjectBuilder create() {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        ValueMap valueMap = this.resource.getValueMap();
        if (valueMap.isEmpty()) {
            String value = (String)this.resource.adaptTo(String.class);
            if (value != null) {
                obj.add(this.resource.getName(), value.toString());
            } else {
                String[] values = (String[])this.resource.adaptTo(String[].class);
                if (values != null) {
                    JsonArrayBuilder builder = Json.createArrayBuilder();
                    for (String v : values) {
                        builder.add(v);
                    }
                    obj.add(this.resource.getName(), builder);
                }
            }
            return obj;
        }
        for (Map.Entry prop : valueMap.entrySet()) {
            if (prop.getValue() == null) continue;
            this.createProperty(obj, (String)prop.getKey(), prop.getValue());
        }
        return obj;
    }

    public static String formatEcma(Calendar date) {
        SimpleDateFormat formatter = new SimpleDateFormat(ECMA_DATE_FORMAT, DATE_FORMAT_LOCALE);
        formatter.setTimeZone(date.getTimeZone());
        return formatter.format(date.getTime());
    }

    private JsonValue getValue(Object value) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (value instanceof InputStream) {
            builder.add("entry", 0);
        } else if (value instanceof Calendar) {
            if (this.ecmaSupport) {
                builder.add("entry", JsonObjectCreator.formatEcma((Calendar)value));
            } else {
                builder.add("entry", ISO8601.format((Calendar)value));
            }
        } else if (value instanceof Boolean) {
            builder.add("entry", ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            builder.add("entry", ((Long)value).longValue());
        } else if (value instanceof Double) {
            builder.add("entry", ((Double)value).doubleValue());
        } else if (value != null) {
            builder.add("entry", value.toString());
        } else {
            builder.add("entry", "");
        }
        return (JsonValue)builder.build().get((Object)"entry");
    }

    private void createProperty(JsonObjectBuilder obj, String key, Object value) {
        int i;
        Object[] values = null;
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                obj.add(key, Json.createArrayBuilder());
                return;
            }
            values = new Object[Array.getLength(value)];
            for (i = 0; i < length; ++i) {
                values[i] = Array.get(value, i);
            }
        }
        if (value instanceof InputStream || values != null && values[0] instanceof InputStream) {
            if (values == null) {
                obj.add(":" + key, this.getLength(0, key, (InputStream)value));
            } else {
                JsonArrayBuilder result = Json.createArrayBuilder();
                for (i = 0; i < values.length; ++i) {
                    result.add(this.getLength(i, key, (InputStream)values[i]));
                }
                obj.add(":" + key, result);
            }
            return;
        }
        if (!value.getClass().isArray()) {
            obj.add(key, this.getValue(value));
        } else {
            JsonArrayBuilder result = Json.createArrayBuilder();
            for (Object v : values) {
                result.add(this.getValue(v));
            }
            obj.add(key, result);
        }
    }

    private long getLength(int index, String key, InputStream stream) {
        Long[] lengths;
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long length = -1L;
        if (this.valueMap != null && (lengths = (Long[])this.valueMap.get(key, Long[].class)) != null && lengths.length > index) {
            length = lengths[index];
        }
        return length;
    }
}

