/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.get.impl.helpers.Renderer;
import org.apache.sling.servlets.get.impl.util.JsonToText;
import org.apache.sling.servlets.get.impl.util.ResourceTraversor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRenderer
implements Renderer {
    private final Logger log = LoggerFactory.getLogger(JsonRenderer.class);
    public static final String INFINITY = "infinity";
    public static final String TIDY = "tidy";
    public static final String HARRAY = "harray";
    public static final int INDENT_SPACES = 2;
    private long maximumResults;
    private final JsonToText renderer = new JsonToText();
    private boolean ecmaSupport;

    public JsonRenderer(long maximumResults, boolean ecmaSupport) {
        this.maximumResults = maximumResults;
        this.ecmaSupport = ecmaSupport;
    }

    @Override
    public void render(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws IOException {
        block35: {
            Resource r = req.getResource();
            if (ResourceUtil.isNonExistingResource((Resource)r)) {
                throw new ResourceNotFoundException("No data to render.");
            }
            int maxRecursionLevels = 0;
            try {
                maxRecursionLevels = this.getMaxRecursionLevel(req);
            }
            catch (IllegalArgumentException iae) {
                resp.sendError(400, iae.getMessage());
                return;
            }
            resp.setContentType(req.getResponseContentType());
            resp.setCharacterEncoding("UTF-8");
            boolean allowDump = true;
            int allowedLevel = 0;
            boolean tidy = this.isTidy(req);
            boolean harray = this.hasSelector(req, HARRAY);
            ResourceTraversor traversor = null;
            try {
                traversor = new ResourceTraversor(maxRecursionLevels, this.maximumResults, r, this.ecmaSupport);
                allowedLevel = traversor.collectResources();
                if (allowedLevel != -1) {
                    allowDump = false;
                }
            }
            catch (Exception e) {
                this.reportException(e);
            }
            try {
                if (allowDump) {
                    if (tidy || harray) {
                        JsonToText.Options opt = this.renderer.options().withIndent(tidy ? 2 : 0).withArraysForChildren(harray);
                        resp.getWriter().write(this.renderer.prettyPrint(traversor.getJSONObject(), opt));
                        break block35;
                    }
                    StringWriter writer = new StringWriter();
                    try (JsonGenerator json = Json.createGenerator((Writer)writer);){
                        json.write((JsonValue)traversor.getJSONObject());
                    }
                    resp.getWriter().write(writer.toString());
                    break block35;
                }
                String tidyUrl = tidy ? "tidy." : "";
                resp.setStatus(300);
                StringWriter writer = new StringWriter();
                try (JsonGenerator json = Json.createGenerator((Writer)writer);){
                    json.writeStartArray();
                    while (allowedLevel >= 0) {
                        json.write(r.getResourceMetadata().getResolutionPath() + "." + tidyUrl + allowedLevel + ".json");
                        --allowedLevel;
                    }
                    json.writeEnd();
                }
                resp.getWriter().write(writer.toString());
            }
            catch (Exception je) {
                this.reportException(je);
            }
        }
    }

    protected int getMaxRecursionLevel(SlingHttpServletRequest req) throws IllegalArgumentException {
        String level;
        int maxRecursionLevels = 0;
        String[] selectors = req.getRequestPathInfo().getSelectors();
        if (selectors != null && selectors.length > 0 && !TIDY.equals(level = selectors[selectors.length - 1]) && !HARRAY.equals(level)) {
            if (INFINITY.equals(level)) {
                maxRecursionLevels = -1;
            } else {
                try {
                    maxRecursionLevels = Integer.parseInt(level);
                }
                catch (NumberFormatException nfe) {
                    if (StringUtils.isNumeric((CharSequence)level)) {
                        maxRecursionLevels = -1;
                    }
                    throw new IllegalArgumentException("Invalid recursion selector value '" + level + "'");
                }
            }
        }
        return maxRecursionLevels;
    }

    protected boolean hasSelector(SlingHttpServletRequest req, String selectorToCheck) {
        for (String selector : req.getRequestPathInfo().getSelectors()) {
            if (!selectorToCheck.equals(selector)) continue;
            return true;
        }
        return false;
    }

    protected boolean isTidy(SlingHttpServletRequest req) {
        return this.hasSelector(req, TIDY);
    }

    private void reportException(Exception e) {
        this.log.warn("Error in JsonRendererServlet: {}", (Throwable)e);
        throw new SlingException(e.toString(), (Throwable)e);
    }
}

