/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.servlethelpers.CookieSupport;
import org.apache.sling.servlethelpers.HeaderSupport;
import org.apache.sling.servlethelpers.ResponseBodySupport;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class MockSlingHttpServletResponse
extends SlingAdaptable
implements SlingHttpServletResponse {
    static final String CHARSET_SEPARATOR = ";charset=";
    private String contentType;
    private String characterEncoding;
    private int contentLength;
    private int status = 200;
    private String statusMessage;
    private int bufferSize = 8192;
    private boolean isCommitted;
    private Locale locale = Locale.US;
    private final HeaderSupport headerSupport = new HeaderSupport();
    private final ResponseBodySupport bodySupport = new ResponseBodySupport();
    private final CookieSupport cookieSupport = new CookieSupport();

    public String getContentType() {
        if (this.contentType == null) {
            return null;
        }
        return this.contentType + (StringUtils.isNotBlank((CharSequence)this.characterEncoding) ? CHARSET_SEPARATOR + this.characterEncoding : "");
    }

    public void setContentType(String type) {
        this.contentType = type;
        if (StringUtils.contains((CharSequence)this.contentType, (CharSequence)CHARSET_SEPARATOR)) {
            this.characterEncoding = StringUtils.substringAfter((String)this.contentType, (String)CHARSET_SEPARATOR);
            this.contentType = StringUtils.substringBefore((String)this.contentType, (String)CHARSET_SEPARATOR);
        }
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setStatus(int sc, String sm) {
        this.setStatus(sc);
        this.statusMessage = sm;
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public void sendError(int sc, String msg) {
        this.setStatus(sc);
        this.statusMessage = msg;
    }

    public void sendError(int sc) {
        this.setStatus(sc);
    }

    public void sendRedirect(String location) {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void addHeader(String name, String value) {
        this.headerSupport.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headerSupport.addIntHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        this.headerSupport.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.headerSupport.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headerSupport.setIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.headerSupport.setDateHeader(name, date);
    }

    public boolean containsHeader(String name) {
        return this.headerSupport.containsHeader(name);
    }

    public String getHeader(String name) {
        return this.headerSupport.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.headerSupport.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this.headerSupport.getHeaderNames();
    }

    public PrintWriter getWriter() {
        return this.bodySupport.getWriter(this.getCharacterEncoding());
    }

    public ServletOutputStream getOutputStream() {
        return this.bodySupport.getOutputStream();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed.");
        }
        this.bodySupport.reset();
        this.headerSupport.reset();
        this.cookieSupport.reset();
        this.status = 200;
        this.contentLength = 0;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed.");
        }
        this.bodySupport.reset();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void flushBuffer() {
        this.isCommitted = true;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public byte[] getOutput() {
        return this.bodySupport.getOutput();
    }

    public String getOutputAsString() {
        return this.bodySupport.getOutputAsString(this.getCharacterEncoding());
    }

    public void addCookie(Cookie cookie) {
        this.cookieSupport.addCookie(cookie);
    }

    public Cookie getCookie(String name) {
        return this.cookieSupport.getCookie(name);
    }

    public Cookie[] getCookies() {
        return this.cookieSupport.getCookies();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public String geStatusMessage() {
        return this.statusMessage;
    }

    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeUrl(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    public void setContentLengthLong(long len) {
        throw new UnsupportedOperationException();
    }
}

