/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sling.serviceusermapping.Mapping;
import org.apache.sling.serviceusermapping.ServicePrincipalsValidator;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.ServiceUserValidator;
import org.apache.sling.serviceusermapping.impl.MappingConfigAmendment;
import org.apache.sling.serviceusermapping.impl.ServiceUserMappedImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={ServiceUserMapper.class, ServiceUserMapperImpl.class})
public class ServiceUserMapperImpl
implements ServiceUserMapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final ExecutorService executorService;
    private final List<ServiceUserValidator> userValidators = new CopyOnWriteArrayList<ServiceUserValidator>();
    private final List<ServicePrincipalsValidator> principalsValidators = new CopyOnWriteArrayList<ServicePrincipalsValidator>();
    private final AtomicReference<ServiceRegistration> defaultRegistration = new AtomicReference();
    private final Map<Long, MappingConfigAmendment> amendments = new HashMap<Long, MappingConfigAmendment>();
    private volatile Mapping[] globalServiceUserMappings;
    private volatile String defaultUser;
    private volatile boolean useDefaultMapping;
    private volatile Mapping[] activeMappings = new Mapping[0];
    private volatile SortedMap<Mapping, Registration> activeRegistrations = new TreeMap<Mapping, Registration>();
    private volatile boolean requireValidation = false;
    private final Set<String> requiredUserValidators = new HashSet<String>();
    private final Set<String> requiredPrincipalValidators = new HashSet<String>();
    private final List<String> presentUserValidators = new CopyOnWriteArrayList<String>();
    private final List<String> presentPrincipalValidators = new CopyOnWriteArrayList<String>();

    @Activate
    public ServiceUserMapperImpl(BundleContext bundleContext, Config config) {
        this(bundleContext, config, Executors.newSingleThreadExecutor());
    }

    public ServiceUserMapperImpl(BundleContext bundleContext, Config config, ExecutorService executor) {
        this.bundleContext = bundleContext;
        this.executorService = executor;
        this.configure(config);
    }

    @Modified
    synchronized void configure(Config config) {
        String[] props = config.user_mapping();
        if (props != null) {
            ArrayList<Mapping> mappings = new ArrayList<Mapping>(props.length);
            for (String prop : props) {
                if (prop == null || prop.trim().length() <= 0) continue;
                try {
                    Mapping mapping = new Mapping(prop.trim());
                    mappings.add(mapping);
                }
                catch (IllegalArgumentException iae) {
                    this.log.error("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
                }
            }
            this.globalServiceUserMappings = mappings.toArray(new Mapping[mappings.size()]);
        } else {
            this.globalServiceUserMappings = new Mapping[0];
        }
        this.defaultUser = config.user_default();
        if (this.defaultUser != null && this.defaultUser.isEmpty()) {
            this.defaultUser = null;
        }
        this.useDefaultMapping = config.user_enable_default_mapping();
        this.requireValidation = config.require_validation();
        if (config.required_user_validators() != null) {
            this.requiredUserValidators.addAll(Arrays.asList(config.required_user_validators()));
        }
        if (config.required_principal_validators() != null) {
            this.requiredPrincipalValidators.addAll(Arrays.asList(config.required_principal_validators()));
        }
        RegistrationSet registrationSet = this.updateMappings();
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    @Deactivate
    synchronized void deactivate() {
        this.updateServiceRegistrations(new Mapping[0]);
        this.executorService.shutdown();
    }

    void restartAllActiveServiceUserMappedServices() {
        RegistrationSet registrationSet = new RegistrationSet();
        registrationSet.removed = this.activeRegistrations.values();
        registrationSet.added = this.activeRegistrations.values();
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void bindServiceUserValidator(ServiceUserValidator serviceUserValidator, Map<String, ?> props) {
        this.userValidators.add(serviceUserValidator);
        Object id = props.get("validator.id");
        if (id instanceof String) {
            this.presentUserValidators.add((String)id);
        }
        if (!this.requireValidation || !this.getPrincipalsValidators().isEmpty()) {
            this.restartAllActiveServiceUserMappedServices();
        }
    }

    protected synchronized void unbindServiceUserValidator(ServiceUserValidator serviceUserValidator, Map<String, ?> props) {
        this.userValidators.remove(serviceUserValidator);
        Object id = props.get("validator.id");
        if (id instanceof String) {
            this.presentUserValidators.remove(id);
        }
        this.restartAllActiveServiceUserMappedServices();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void bindServicePrincipalsValidator(ServicePrincipalsValidator servicePrincipalsValidator, Map<String, ?> props) {
        this.principalsValidators.add(servicePrincipalsValidator);
        Object id = props.get("validator.id");
        if (id instanceof String) {
            this.presentPrincipalValidators.add((String)id);
        }
        if (!this.requireValidation || !this.getUserValidators().isEmpty()) {
            this.restartAllActiveServiceUserMappedServices();
        }
    }

    protected synchronized void unbindServicePrincipalsValidator(ServicePrincipalsValidator servicePrincipalsValidator, Map<String, ?> props) {
        this.principalsValidators.remove(servicePrincipalsValidator);
        Object id = props.get("validator.id");
        if (id instanceof String) {
            this.presentPrincipalValidators.remove(id);
        }
        this.restartAllActiveServiceUserMappedServices();
    }

    @Override
    public String getServiceUserID(Bundle bundle, String subServiceName) {
        String serviceName = this.getServiceName(bundle);
        String userId = this.internalGetUserId(serviceName, subServiceName);
        boolean valid = this.isValidUser(userId, serviceName, subServiceName, false);
        String result = valid ? userId : null;
        this.log.debug("getServiceUserID(bundle {}, subServiceName {}) returns [{}] (raw userId={}, valid={})", new Object[]{bundle, subServiceName, result, userId, valid});
        return result;
    }

    String getServiceUserIDInternal(Bundle bundle, String subServiceName) {
        String serviceName = this.getServiceName(bundle);
        String userId = this.internalGetUserId(serviceName, subServiceName);
        boolean valid = this.isValidUser(userId, serviceName, subServiceName, this.requireValidation);
        String result = valid ? userId : null;
        this.log.debug("getServiceUserID(bundle {}, subServiceName {}) returns [{}] (raw userId={}, valid={})", new Object[]{bundle, subServiceName, result, userId, valid});
        return result;
    }

    @Override
    public Iterable<String> getServicePrincipalNames(Bundle bundle, String subServiceName) {
        String serviceName = this.getServiceName(bundle);
        Iterable<String> names = this.internalGetPrincipalNames(serviceName, subServiceName);
        boolean valid = this.areValidPrincipals(names, serviceName, subServiceName, false);
        Iterable<String> result = valid ? names : null;
        this.log.debug("getServicePrincipalNames(bundle {}, subServiceName {}) returns [{}] (raw principalNames={}, valid={})", new Object[]{bundle, subServiceName, result, names, valid});
        return result;
    }

    Iterable<String> getServicePrincipalNamesInternal(Bundle bundle, String subServiceName) {
        String serviceName = this.getServiceName(bundle);
        Iterable<String> names = this.internalGetPrincipalNames(serviceName, subServiceName);
        boolean valid = this.areValidPrincipals(names, serviceName, subServiceName, this.requireValidation);
        Iterable<String> result = valid ? names : null;
        this.log.debug("getServicePrincipalNames(bundle {}, subServiceName {}) returns [{}] (raw principalNames={}, valid={})", new Object[]{bundle, subServiceName, result, names, valid});
        return result;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="updateAmendment")
    protected synchronized void bindAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        Long key = (Long)props.get("service.id");
        RegistrationSet registrationSet = null;
        this.amendments.put(key, amendment);
        registrationSet = this.updateMappings();
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    protected synchronized void unbindAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        Long key = (Long)props.get("service.id");
        RegistrationSet registrationSet = null;
        if (this.amendments.remove(key) != null) {
            registrationSet = this.updateMappings();
        }
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    protected void updateAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        this.bindAmendment(amendment, props);
    }

    protected RegistrationSet updateMappings() {
        ArrayList<MappingConfigAmendment> sortedMappings = new ArrayList<MappingConfigAmendment>();
        for (MappingConfigAmendment amendment : this.amendments.values()) {
            sortedMappings.add(amendment);
        }
        Collections.sort(sortedMappings);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (Mapping m : this.globalServiceUserMappings) {
            mappings.add(m);
        }
        for (MappingConfigAmendment mca : sortedMappings) {
            for (Mapping m : mca.getServiceUserMappings()) {
                mappings.add(m);
            }
        }
        this.activeMappings = mappings.toArray(new Mapping[mappings.size()]);
        this.log.debug("Active mappings updated: {} mappings active", (Object)mappings.size());
        return this.updateServiceRegistrations(this.activeMappings);
    }

    RegistrationSet updateServiceRegistrations(Mapping[] newMappings) {
        RegistrationSet result = new RegistrationSet();
        TreeSet<Mapping> orderedNewMappings = new TreeSet<Mapping>(Arrays.asList(newMappings));
        TreeMap<Mapping, Registration> newRegistrations = new TreeMap<Mapping, Registration>();
        for (Map.Entry<Mapping, Registration> registrationEntry : this.activeRegistrations.entrySet()) {
            boolean keepEntry = true;
            if (!orderedNewMappings.contains(registrationEntry.getKey())) {
                Registration registration = registrationEntry.getValue();
                result.removed.add(registration);
                keepEntry = false;
            }
            if (!keepEntry) continue;
            newRegistrations.put(registrationEntry.getKey(), registrationEntry.getValue());
        }
        for (Mapping mapping : orderedNewMappings) {
            if (newRegistrations.containsKey(mapping)) continue;
            Registration registration = new Registration(mapping);
            newRegistrations.put(mapping, registration);
            result.added.add(registration);
        }
        this.activeRegistrations = newRegistrations;
        return result;
    }

    private void executeServiceRegistrationsAsync(RegistrationSet registrationSet) {
        this.executorService.submit(() -> this.executeServiceRegistrations(registrationSet));
    }

    private void executeServiceRegistrations(RegistrationSet registrationSet) {
        ServiceRegistration reg = this.defaultRegistration.getAndSet(null);
        if (reg != null) {
            reg.unregister();
        }
        for (Registration registration : registrationSet.removed) {
            ServiceRegistration serviceRegistration = registration.setService(null);
            if (serviceRegistration == null) continue;
            try {
                serviceRegistration.unregister();
                this.log.debug("Unregistered ServiceUserMapped {}", (Object)registration.mapping);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        for (Registration registration : registrationSet.added) {
            Mapping mapping = registration.mapping;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (mapping.getSubServiceName() != null) {
                ((Dictionary)properties).put("subServiceName", mapping.getSubServiceName());
            }
            ((Dictionary)properties).put(Mapping.SERVICENAME, mapping.getServiceName());
            ServiceRegistration serviceRegistration = this.bundleContext.registerService(ServiceUserMappedImpl.SERVICEUSERMAPPED, (Object)new ServiceUserMappedImpl(), properties);
            ServiceRegistration oldServiceRegistration = registration.setService(serviceRegistration);
            this.log.debug("Activated ServiceUserMapped {}", (Object)registration.mapping);
            if (oldServiceRegistration == null) continue;
            try {
                oldServiceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (this.useDefaultMapping || this.defaultUser != null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put(Mapping.SERVICENAME, this.getServiceName(this.bundleContext.getBundle()));
            ServiceRegistration serviceRegistration = this.bundleContext.registerService(ServiceUserMappedImpl.SERVICEUSERMAPPED, (Object)new ServiceUserMappedImpl(), properties);
            this.defaultRegistration.set(serviceRegistration);
        }
    }

    private String internalGetUserId(String serviceName, String subServiceName) {
        String userId;
        this.log.debug("internalGetUserId: {} active mappings, looking for mapping for {}/{}", new Object[]{this.activeMappings.length, serviceName, subServiceName});
        for (Mapping mapping : this.activeMappings) {
            userId = mapping.map(serviceName, subServiceName);
            if (userId == null) continue;
            this.log.debug("Got userId [{}] from {}/{}", new Object[]{userId, serviceName, subServiceName});
            return userId;
        }
        this.log.debug("internalGetUserId: {} active mappings, looking for mapping for {}/<no subServiceName>", (Object)this.activeMappings.length, (Object)serviceName);
        for (Mapping mapping : this.activeMappings) {
            userId = mapping.map(serviceName, null);
            if (userId == null) continue;
            this.log.debug("Got userId [{}] from {}/<no subServiceName>", (Object)userId, (Object)serviceName);
            return userId;
        }
        if (this.useDefaultMapping && this.defaultUser == null) {
            String userName = "serviceuser--" + serviceName + (subServiceName == null ? "" : "--" + subServiceName);
            this.log.debug("internalGetUserId: no mapping found, using default mapping [{}]", (Object)userName);
            return userName;
        }
        this.log.debug("internalGetUserId: no mapping found, fallback to default user [{}]", (Object)this.defaultUser);
        return this.defaultUser;
    }

    boolean isValidUser(String userId, String serviceName, String subServiceName, boolean require) {
        if (userId == null) {
            this.log.debug("isValidUser: userId is null -> invalid");
            return false;
        }
        List<ServiceUserValidator> validators = this.getUserValidators();
        if (validators.isEmpty()) {
            if (require) {
                this.log.debug("isValidUser: No active validators for userId '{}' and require -> invalid", (Object)userId);
                return false;
            }
            this.log.debug("isValidUser: No active validators for userId '{}' -> valid", (Object)userId);
            return true;
        }
        for (ServiceUserValidator validator : validators) {
            if (validator.isValid(userId, serviceName, subServiceName)) continue;
            this.log.debug("isValidUser: Validator {} doesn't accept userId '{}' -> invalid", (Object)validator, (Object)userId);
            return false;
        }
        this.log.debug("isValidUser: All validators accepted userId '{}' -> valid", (Object)userId);
        return true;
    }

    boolean areValidPrincipals(Iterable<String> principalNames, String serviceName, String subServiceName, boolean require) {
        if (principalNames == null) {
            this.log.debug("areValidPrincipals: principalNames are null -> invalid");
            return false;
        }
        List<ServicePrincipalsValidator> validators = this.getPrincipalsValidators();
        if (validators.isEmpty()) {
            if (require) {
                this.log.debug("areValidPrincipals: No active validators for principal names [{}] and require -> invalid", principalNames);
                return false;
            }
            this.log.debug("areValidPrincipals: No active validators for principal names [{}] -> valid", principalNames);
            return true;
        }
        for (ServicePrincipalsValidator validator : validators) {
            if (validator.isValid(principalNames, serviceName, subServiceName)) continue;
            this.log.debug("areValidPrincipals: Validator {} doesn't accept principal names [{}] -> invalid", (Object)validator, principalNames);
            return false;
        }
        this.log.debug("areValidPrincipals: All validators accepted principal names [{}] -> valid", principalNames);
        return true;
    }

    private List<ServiceUserValidator> getUserValidators() {
        return this.getValidatorsIfPresent(this.userValidators);
    }

    private List<ServicePrincipalsValidator> getPrincipalsValidators() {
        return this.getValidatorsIfPresent(this.principalsValidators);
    }

    private <T> List<T> getValidatorsIfPresent(List<T> validators) {
        if (this.presentUserValidators.containsAll(this.requiredUserValidators) && this.presentPrincipalValidators.containsAll(this.requiredPrincipalValidators)) {
            return validators;
        }
        return Collections.emptyList();
    }

    private Iterable<String> internalGetPrincipalNames(String serviceName, String subServiceName) {
        Iterable<String> principalNames;
        this.log.debug("internalGetPrincipalNames: {} active mappings, looking for mapping for {}/{}", new Object[]{this.activeMappings.length, serviceName, subServiceName});
        for (Mapping mapping : this.activeMappings) {
            principalNames = mapping.mapPrincipals(serviceName, subServiceName);
            if (principalNames == null) continue;
            this.log.debug("Got principalNames [{}] from {}/{}", new Object[]{principalNames, serviceName, subServiceName});
            return principalNames;
        }
        this.log.debug("internalGetPrincipalNames: {} active mappings, looking for mapping for {}/<no subServiceName>", (Object)this.activeMappings.length, (Object)serviceName);
        for (Mapping mapping : this.activeMappings) {
            principalNames = mapping.mapPrincipals(serviceName, null);
            if (principalNames == null) continue;
            this.log.debug("Got principalNames [{}] from {}/<no subServiceName>", principalNames, (Object)serviceName);
            return principalNames;
        }
        this.log.debug("internalGetPrincipalNames: no mapping found.");
        return null;
    }

    String getServiceName(Bundle bundle) {
        return bundle.getSymbolicName();
    }

    @Override
    public List<Mapping> getActiveMappings() {
        return Collections.unmodifiableList(Arrays.asList(this.activeMappings));
    }

    class RegistrationSet {
        Collection<Registration> added = new ArrayList<Registration>();
        Collection<Registration> removed = new ArrayList<Registration>();

        RegistrationSet() {
        }
    }

    class Registration {
        private Mapping mapping;
        private ServiceRegistration serviceRegistration;

        Registration(Mapping mapping) {
            this.mapping = mapping;
            this.serviceRegistration = null;
        }

        synchronized ServiceRegistration setService(ServiceRegistration serviceRegistration) {
            ServiceRegistration oldServiceRegistration = this.serviceRegistration;
            this.serviceRegistration = serviceRegistration;
            return oldServiceRegistration;
        }
    }

    @ObjectClassDefinition(name="Apache Sling Service User Mapper Service", description="Configuration for the service mapping service names to names of users.")
    public static @interface Config {
        @AttributeDefinition(name="Service Mappings", description="Provides mappings from service name to user names. Each entry is of the form 'bundleId [ \":\" subServiceName ] \"=\" userName' | \"[\" principalNames \"]\" where bundleId and subServiceName identify the service and userName defines the name of the user to provide to the service; alternative the the mappingcan define a comma separated set of principalNames instead of the userName. Invalid entries are logged and ignored.")
        public String[] user_mapping() default {};

        @AttributeDefinition(name="Default User", description="The name of the user to use as the default if no service mapping applies. If this property is missing or empty no default user is defined.")
        public String user_default();

        @AttributeDefinition(name="Default Mapping", description="If enabled and no mapping for a requested service user exists and no  default user is defined, a default mapping is applied which uses the service user \"serviceuser--\" + bundleId + [\"--\" + subServiceName]")
        public boolean user_enable_default_mapping() default true;

        @AttributeDefinition(name="Require Validation", description="If true, a service user is only valid if there are present validators that accept it.")
        public boolean require_validation() default false;

        @AttributeDefinition(name="Required User Validators", description="A list of required user validators ids. If any configured validator in this list is not present and \"require validation\" is enabled no userid and no principal name will be valid.")
        public String[] required_user_validators() default {};

        @AttributeDefinition(name="Required Principal Validators", description="A list of required principal validators ids. If any configured validator in this list is not present and \"require validation\" is enabled no userid and no principal name will be valid.")
        public String[] required_principal_validators() default {};
    }
}

