/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.ArrayList;
import org.apache.sling.serviceusermapping.impl.Mapping;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(factory=true, ocd=Config.class)
@Component(name="org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended", configurationPolicy=ConfigurationPolicy.REQUIRE, service={MappingConfigAmendment.class})
public class MappingConfigAmendment
implements Comparable<MappingConfigAmendment> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Mapping[] serviceUserMappings;
    private int serviceRanking;

    @Activate
    @Modified
    void configure(Config config) {
        String[] props = config.user_mapping();
        if (props != null) {
            ArrayList<Mapping> mappings = new ArrayList<Mapping>(props.length);
            for (String prop : props) {
                if (prop == null || prop.trim().length() <= 0) continue;
                try {
                    Mapping mapping = new Mapping(prop.trim());
                    mappings.add(mapping);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.info("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
                }
            }
            this.serviceUserMappings = mappings.toArray(new Mapping[mappings.size()]);
        } else {
            this.serviceUserMappings = new Mapping[0];
        }
        this.serviceRanking = config.service_ranking();
    }

    public Mapping[] getServiceUserMappings() {
        return this.serviceUserMappings;
    }

    @Override
    public int compareTo(MappingConfigAmendment o) {
        if (this.serviceRanking > o.serviceRanking) {
            return -1;
        }
        if (this.serviceRanking < o.serviceRanking) {
            return 1;
        }
        return this.hashCode() < o.hashCode() ? -1 : 1;
    }

    @ObjectClassDefinition(name="Apache Sling Service User Mapper Service Amendment", description="An amendment mapping for the user mapping service.")
    public static @interface Config {
        @AttributeDefinition(name="Ranking", description="Amendments are processed in order of their ranking, an amendment with a higher ranking has precedence over a mapping with a lower ranking.")
        public int service_ranking() default 0;

        @AttributeDefinition(name="Service Mappings", description="Provides mappings from service name to user (and optionally principal) names. Each entry is of the form 'bundleId [ \":\" subServiceName ] \"=\" userName' | \"[\" principalNames \"]\" where bundleId and subServiceName identify the service and userName/principalNames defines the name(s) of the user/principals to provide to the service. 'principalNames is defined to be a comma separated list of principal names. Invalid entries are logged and ignored.")
        public String[] user_mapping() default {};

        public String webconsole_configurationFactory_nameHint() default "Mapping: {user.mapping}";
    }
}

