/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.security.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.security.impl.ContentDispositionFilterConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"sling.filter.scope=request", "sling.filter.scope=forward", "service.ranking:Integer=25000"})
@Designate(ocd=ContentDispositionFilterConfiguration.class)
public class ContentDispositionFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    Set<String> contentDispositionPaths;
    private String[] contentDispositionPathsPfx;
    Set<String> contentDispositionExcludedPaths;
    private Map<String, Set<String>> contentTypesMapping;
    private boolean enableContentDispositionAllPaths;

    @Activate
    private void activate(ContentDispositionFilterConfiguration configuration) {
        HashSet paths = new HashSet();
        ArrayList<String> pfxs = new ArrayList<String>();
        HashMap<String, Set<String>> contentTypesMap = new HashMap<String, Set<String>>();
        if (configuration.sling_content_disposition_paths() != null) {
            for (String path : configuration.sling_content_disposition_paths()) {
                if ((path = path.trim()).length() <= 0) continue;
                int idx = path.indexOf(42);
                int colonIdx = path.indexOf(":");
                if (colonIdx > -1 && colonIdx < idx) {
                    this.logger.info("wildcard ('*') in content type is not allowed, but found content type with value '{}'", (Object)path.substring(colonIdx));
                    continue;
                }
                String p = null;
                if (idx >= 0) {
                    if (idx > 0) {
                        p = path.substring(0, idx);
                        pfxs.add(p);
                    } else {
                        this.logger.info("catch-all wildcard for paths not allowed.");
                    }
                } else {
                    p = colonIdx > -1 ? path.substring(0, colonIdx) : path;
                    paths.add(p);
                }
                if (colonIdx == -1 || p == null) continue;
                Set<String> contentTypes = ContentDispositionFilter.getContentTypes(path.substring(colonIdx + 1));
                contentTypesMap.put(p, contentTypes);
            }
        }
        this.contentDispositionPaths = paths.isEmpty() ? Collections.emptySet() : paths;
        this.contentDispositionPathsPfx = pfxs.toArray(new String[pfxs.size()]);
        this.contentTypesMapping = contentTypesMap.isEmpty() ? Collections.emptyMap() : contentTypesMap;
        this.enableContentDispositionAllPaths = configuration.sling_content_disposition_all_paths();
        String[] contentDispositionExcludedPathsArray = configuration.sling_content_disposition_excluded_paths() != null ? configuration.sling_content_disposition_excluded_paths() : new String[]{};
        this.contentDispositionExcludedPaths = new HashSet<String>(Arrays.asList(contentDispositionExcludedPathsArray));
        this.logger.info("Initialized. content disposition paths: {}, content disposition paths-pfx {}, content disposition excluded paths: {}. Enable Content Disposition for all paths is set to {}", new Object[]{this.contentDispositionPaths, this.contentDispositionPathsPfx, this.contentDispositionExcludedPaths, this.enableContentDispositionAllPaths});
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        RewriterResponse rewriterResponse = new RewriterResponse(slingRequest, slingResponse);
        chain.doFilter(request, (ServletResponse)rewriterResponse);
    }

    private static Set<String> getContentTypes(String contentTypes) {
        HashSet<String> contentTypesSet = new HashSet<String>();
        if (contentTypes != null && contentTypes.length() > 0) {
            String[] contentTypesArray;
            for (String contentType : contentTypesArray = contentTypes.split(",")) {
                contentTypesSet.add(contentType);
            }
        }
        return contentTypesSet;
    }

    protected class RewriterResponse
    extends SlingHttpServletResponseWrapper {
        private static final String CONTENT_DISPOSTION = "Content-Disposition";
        private static final String CONTENT_DISPOSTION_ATTACHMENT = "attachment";
        private static final String PROP_JCR_DATA = "jcr:data";
        private static final String JCR_CONTENT_LEAF = "jcr:content";
        static final String ATTRIBUTE_NAME = "org.apache.sling.security.impl.ContentDispositionFilter.RewriterResponse.contentType";
        private final SlingHttpServletRequest request;
        private final Resource resource;

        public RewriterResponse(SlingHttpServletRequest request, SlingHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
            this.request = request;
            this.resource = request.getResource();
        }

        public void reset() {
            this.request.removeAttribute(ATTRIBUTE_NAME);
            super.reset();
        }

        public void setContentType(String type) {
            if ("GET".equals(this.request.getMethod())) {
                String previousContentType = (String)this.request.getAttribute(ATTRIBUTE_NAME);
                if (previousContentType != null && previousContentType.equals(type)) {
                    super.setContentType(type);
                    return;
                }
                this.request.setAttribute(ATTRIBUTE_NAME, (Object)type);
                String resourcePath = this.resource.getPath();
                if (!ContentDispositionFilter.this.contentDispositionExcludedPaths.contains(resourcePath)) {
                    if (ContentDispositionFilter.this.enableContentDispositionAllPaths) {
                        this.setContentDisposition(this.resource);
                    } else {
                        boolean contentDispositionAdded = false;
                        if (ContentDispositionFilter.this.contentDispositionPaths.contains(resourcePath)) {
                            if (ContentDispositionFilter.this.contentTypesMapping.containsKey(resourcePath)) {
                                Set exceptions = (Set)ContentDispositionFilter.this.contentTypesMapping.get(resourcePath);
                                if (!exceptions.contains(type)) {
                                    contentDispositionAdded = this.setContentDisposition(this.resource);
                                }
                            } else {
                                contentDispositionAdded = this.setContentDisposition(this.resource);
                            }
                        }
                        if (!contentDispositionAdded) {
                            for (String path : ContentDispositionFilter.this.contentDispositionPathsPfx) {
                                if (!resourcePath.startsWith(path)) continue;
                                if (ContentDispositionFilter.this.contentTypesMapping.containsKey(path)) {
                                    Set exceptions = (Set)ContentDispositionFilter.this.contentTypesMapping.get(path);
                                    if (exceptions.contains(type)) continue;
                                    this.setContentDisposition(this.resource);
                                    break;
                                }
                                this.setContentDisposition(this.resource);
                                break;
                            }
                        }
                    }
                }
            }
            super.setContentType(type);
        }

        private boolean setContentDisposition(Resource resource) {
            boolean contentDispositionAdded = false;
            if (!this.containsHeader(CONTENT_DISPOSTION) && this.isJcrData(resource)) {
                this.addHeader(CONTENT_DISPOSTION, CONTENT_DISPOSTION_ATTACHMENT);
                contentDispositionAdded = true;
            }
            return contentDispositionAdded;
        }

        private boolean isJcrData(Resource resource) {
            boolean jcrData = false;
            if (resource != null) {
                ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
                if (props != null && props.containsKey((Object)PROP_JCR_DATA)) {
                    jcrData = true;
                } else {
                    Resource jcrContent = resource.getChild(JCR_CONTENT_LEAF);
                    if (jcrContent != null && (props = (ValueMap)jcrContent.adaptTo(ValueMap.class)) != null && props.containsKey((Object)PROP_JCR_DATA)) {
                        jcrData = true;
                    }
                }
            }
            return jcrData;
        }
    }
}

