/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.servlet.ServletContext;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.thymeleaf.internal.ThymeleafScriptEngine;
import org.apache.sling.scripting.thymeleaf.internal.ThymeleafScriptEngineFactoryConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.linkbuilder.StandardLinkBuilder;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.templateparser.markup.decoupled.IDecoupledTemplateLogicResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Component(service={ScriptEngineFactory.class}, immediate=true, property={"service.description=ScriptEngineFactory for Sling Scripting Thymeleaf", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=ThymeleafScriptEngineFactoryConfiguration.class)
public final class ThymeleafScriptEngineFactory
extends AbstractScriptEngineFactory {
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, bind="addTemplateResolver", unbind="removeTemplateResolver")
    private List<ITemplateResolver> templateResolvers;
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, bind="addMessageResolver", unbind="removeMessageResolver")
    private List<IMessageResolver> messageResolvers;
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, bind="addDialect", unbind="removeDialect")
    private List<IDialect> dialects;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="addLinkBuilder", unbind="removeLinkBuilder")
    private List<ILinkBuilder> linkBuilders;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="setDecoupledTemplateLogicResolver", unbind="unsetDecoupledTemplateLogicResolver")
    private volatile IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="setCacheManager", unbind="unsetCacheManager")
    private volatile ICacheManager cacheManager;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="setEngineContextFactory", unbind="unsetEngineContextFactory")
    private volatile IEngineContextFactory engineContextFactory;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ScriptingResourceResolverProvider scriptingResourceResolverProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(name=org.apache.sling)")
    private volatile ServletContext servletContext;
    private ThymeleafScriptEngineFactoryConfiguration configuration;
    private BundleContext bundleContext;
    private TemplateEngine templateEngine;
    private ServiceRegistration<ITemplateEngine> serviceRegistration;
    private final Object lock = new Object();
    private final String THYMELEAF_PROPERTIES = "/org/thymeleaf/thymeleaf.properties";
    private final Logger logger = LoggerFactory.getLogger(ThymeleafScriptEngineFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTemplateResolver(ITemplateResolver templateResolver) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("adding template resolver '{}'", (Object)templateResolver.getName());
            if (this.templateEngine == null || this.templateEngine.isInitialized()) {
                this.serviceTemplateEngine();
            } else {
                this.templateEngine.addTemplateResolver(templateResolver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTemplateResolver(ITemplateResolver templateResolver) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("removing template resolver '{}'", (Object)templateResolver.getName());
            this.serviceTemplateEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageResolver(IMessageResolver messageResolver) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("adding message resolver '{}'", (Object)messageResolver.getName());
            if (this.templateEngine == null || this.templateEngine.isInitialized()) {
                this.serviceTemplateEngine();
            } else {
                this.templateEngine.addMessageResolver(messageResolver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageResolver(IMessageResolver messageResolver) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("removing message resolver '{}'", (Object)messageResolver.getName());
            this.serviceTemplateEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDialect(IDialect dialect) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("adding dialect '{}'", (Object)dialect.getName());
            if (this.templateEngine == null || this.templateEngine.isInitialized()) {
                this.serviceTemplateEngine();
            } else {
                this.templateEngine.addDialect(dialect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDialect(IDialect dialect) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("removing dialect '{}'", (Object)dialect.getName());
            this.serviceTemplateEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLinkBuilder(ILinkBuilder linkBuilder) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("adding link builder '{}'", (Object)linkBuilder.getName());
            if (this.templateEngine == null || this.templateEngine.isInitialized()) {
                this.serviceTemplateEngine();
            } else {
                this.templateEngine.addLinkBuilder(linkBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLinkBuilder(ILinkBuilder linkBuilder) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("removing link builder '{}'", (Object)linkBuilder.getName());
            this.serviceTemplateEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDecoupledTemplateLogicResolver(IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("setting decoupled template logic resolver '{}'", (Object)decoupledTemplateLogicResolver.getClass().getName());
            if (this.templateEngine == null || this.templateEngine.isInitialized()) {
                this.serviceTemplateEngine();
            } else {
                this.templateEngine.setDecoupledTemplateLogicResolver(decoupledTemplateLogicResolver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetDecoupledTemplateLogicResolver(IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("unsetting decoupled template logic resolver '{}'", (Object)decoupledTemplateLogicResolver.getClass().getName());
            this.serviceTemplateEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCacheManager(ICacheManager cacheManager) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("setting cache manager '{}'", (Object)cacheManager.getClass().getName());
            if (this.templateEngine == null || this.templateEngine.isInitialized()) {
                this.serviceTemplateEngine();
            } else {
                this.templateEngine.setCacheManager(cacheManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetCacheManager(ICacheManager cacheManager) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("unsetting cache manager '{}'", (Object)cacheManager.getClass().getName());
            this.serviceTemplateEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEngineContextFactory(IEngineContextFactory engineContextFactory) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("setting engine context factory '{}'", (Object)engineContextFactory.getClass().getName());
            if (this.templateEngine == null || this.templateEngine.isInitialized()) {
                this.serviceTemplateEngine();
            } else {
                this.templateEngine.setEngineContextFactory(engineContextFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetEngineContextFactory(IEngineContextFactory engineContextFactory) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.debug("unsetting engine context factory '{}'", (Object)engineContextFactory.getClass().getName());
            this.serviceTemplateEngine();
        }
    }

    @Activate
    private void activate(ThymeleafScriptEngineFactoryConfiguration configuration, BundleContext bundleContext) {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.bundleContext = bundleContext;
        this.configure(configuration);
        this.setupTemplateEngine();
        this.registerTemplateEngine();
    }

    @Modified
    private void modified(ThymeleafScriptEngineFactoryConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.unregisterTemplateEngine();
        this.templateEngine = null;
        this.bundleContext = null;
    }

    private void configure(ThymeleafScriptEngineFactoryConfiguration configuration) {
        this.setExtensions(configuration.extensions());
        this.setMimeTypes(configuration.mimeTypes());
        this.setNames(configuration.names());
    }

    public String getLanguageName() {
        return "Thymeleaf";
    }

    public String getLanguageVersion() {
        try {
            Properties properties = new Properties();
            properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/org/thymeleaf/thymeleaf.properties"));
            return properties.getProperty("version");
        }
        catch (Exception e) {
            this.logger.error("error reading version from /org/thymeleaf/thymeleaf.properties", (Throwable)e);
            return "";
        }
    }

    public ScriptEngine getScriptEngine() {
        this.logger.debug("getting script engine for Thymeleaf");
        return new ThymeleafScriptEngine(this);
    }

    private void serviceTemplateEngine() {
        this.unregisterTemplateEngine();
        this.setupTemplateEngine();
        this.registerTemplateEngine();
    }

    private void setupTemplateEngine() {
        this.logger.info("setting up new template engine");
        this.templateEngine = null;
        if (this.configuration == null) {
            this.logger.info("configuration is null, not setting up new template engine");
            return;
        }
        if (!this.configuration.useStandardEngineContextFactory() && this.engineContextFactory == null) {
            this.logger.info("no engine context factory available, not setting up new template engine");
            return;
        }
        TemplateEngine templateEngine = new TemplateEngine();
        if (this.templateResolvers != null) {
            HashSet<ITemplateResolver> templateResolvers = new HashSet<ITemplateResolver>(this.templateResolvers);
            templateEngine.setTemplateResolvers(templateResolvers);
        }
        if (this.messageResolvers != null) {
            HashSet<IMessageResolver> messageResolvers = new HashSet<IMessageResolver>(this.messageResolvers);
            templateEngine.setMessageResolvers(messageResolvers);
        }
        if (this.configuration.useStandardMessageResolver()) {
            StandardMessageResolver standardMessageResolver = new StandardMessageResolver();
            templateEngine.addMessageResolver((IMessageResolver)standardMessageResolver);
        }
        if (this.linkBuilders != null) {
            HashSet<ILinkBuilder> linkBuilders = new HashSet<ILinkBuilder>(this.linkBuilders);
            templateEngine.setLinkBuilders(linkBuilders);
        }
        if (this.configuration.useStandardLinkBuilder()) {
            StandardLinkBuilder standardLinkBuilder = new StandardLinkBuilder();
            templateEngine.addLinkBuilder((ILinkBuilder)standardLinkBuilder);
        }
        if (this.dialects != null) {
            HashSet<IDialect> dialects = new HashSet<IDialect>(this.dialects);
            templateEngine.setDialects(dialects);
        }
        if (this.configuration.useStandardDialect()) {
            StandardDialect standardDialect = new StandardDialect();
            templateEngine.addDialect((IDialect)standardDialect);
        }
        if (!this.configuration.useStandardDecoupledTemplateLogicResolver()) {
            templateEngine.setDecoupledTemplateLogicResolver(this.decoupledTemplateLogicResolver);
        }
        if (!this.configuration.useStandardCacheManager()) {
            templateEngine.setCacheManager(this.cacheManager);
        }
        if (!this.configuration.useStandardEngineContextFactory()) {
            templateEngine.setEngineContextFactory(this.engineContextFactory);
        }
        this.templateEngine = templateEngine;
    }

    private void registerTemplateEngine() {
        if (this.templateEngine == null || this.templateEngine.getTemplateResolvers().size() == 0 || this.templateEngine.getMessageResolvers().size() == 0 || this.templateEngine.getDialects().size() == 0) {
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Thymeleaf TemplateEngine");
        ((Dictionary)properties).put("service.vendor", "The Thymeleaf Team");
        this.logger.info("registering {} as service {} with properties {}", new Object[]{this.templateEngine, ITemplateEngine.class.getName(), properties});
        this.serviceRegistration = this.bundleContext.registerService(ITemplateEngine.class, (Object)this.templateEngine, properties);
    }

    private void unregisterTemplateEngine() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TemplateEngine getTemplateEngine() {
        Object object = this.lock;
        synchronized (object) {
            if (this.templateEngine == null) {
                this.serviceTemplateEngine();
            }
            return this.templateEngine;
        }
    }

    ResourceResolver getRequestScopedResourceResolver() {
        return this.scriptingResourceResolverProvider.getRequestScopedResourceResolver();
    }

    ServletContext getSlingServletContext() {
        return this.servletContext;
    }
}

