/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.scripting.thymeleaf.SlingContext;
import org.apache.sling.scripting.thymeleaf.TemplateModeProvider;
import org.apache.sling.scripting.thymeleaf.internal.SlingResourceTemplateResolverConfiguration;
import org.apache.sling.scripting.thymeleaf.internal.SlingTemplateResource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.NonCacheableCacheEntryValidity;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;

@Component(immediate=true, property={"service.description=Sling Resource TemplateResolver for Sling Scripting Thymeleaf", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=SlingResourceTemplateResolverConfiguration.class)
public class SlingResourceTemplateResolver
implements ITemplateResolver {
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="setTemplateModeProvider", unbind="unsetTemplateModeProvider")
    private volatile TemplateModeProvider templateModeProvider;
    private SlingResourceTemplateResolverConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(SlingResourceTemplateResolver.class);

    public void setTemplateModeProvider(TemplateModeProvider templateModeProvider) {
        this.logger.debug("setting template mode provider: {}", (Object)templateModeProvider);
    }

    public void unsetTemplateModeProvider(TemplateModeProvider templateModeProvider) {
        this.logger.debug("unsetting template mode provider: {}", (Object)templateModeProvider);
    }

    @Activate
    private void activate(SlingResourceTemplateResolverConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
    }

    @Modified
    private void modified(SlingResourceTemplateResolverConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Integer getOrder() {
        return this.configuration.order();
    }

    @Override
    public TemplateResolution resolveTemplate(IEngineConfiguration engineConfiguration, IContext context, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        this.logger.debug("resolving template '{}'", (Object)template);
        if (context instanceof SlingContext) {
            SlingContext slingContext = (SlingContext)context;
            ResourceResolver resourceResolver = slingContext.getResourceResolver();
            Resource resource = resourceResolver.getResource(template);
            if (resource == null) {
                this.logger.warn("resource for template '{}' is null, not resolving template", (Object)template);
                return null;
            }
            SlingTemplateResource templateResource = new SlingTemplateResource(resource);
            boolean templateResourceExistenceVerified = false;
            TemplateMode templateMode = this.templateModeProvider.provideTemplateMode(resource);
            if (templateMode == null) {
                this.logger.warn("template mode for template '{}' is null, not resolving template", (Object)template);
                return null;
            }
            this.logger.debug("using template mode {} for template '{}'", (Object)templateMode, (Object)template);
            boolean useDecoupledLogic = templateMode.isMarkup() && this.configuration.useDecoupledLogic();
            NonCacheableCacheEntryValidity validity = NonCacheableCacheEntryValidity.INSTANCE;
            return new TemplateResolution(templateResource, false, templateMode, useDecoupledLogic, validity);
        }
        this.logger.error("context is not an instance of SlingContext");
        return null;
    }
}

