/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.scripting.thymeleaf.SlingContext;
import org.apache.sling.scripting.thymeleaf.internal.SlingEngineContext;
import org.osgi.service.component.annotations.Component;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.engine.TemplateData;

@Component(immediate=true, property={"service.description=Sling EngineContextFactory for Sling Scripting Thymeleaf", "service.vendor=The Apache Software Foundation"})
public class SlingEngineContextFactory
implements IEngineContextFactory {
    @Override
    public IEngineContext createEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        if (context instanceof SlingContext) {
            SlingContext slingContext = (SlingContext)context;
            ResourceResolver resourceResolver = slingContext.getResourceResolver();
            Locale locale = context.getLocale();
            Set<String> variableNames = context.getVariableNames();
            LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>(variableNames.size() + 1, 1.0f);
            for (String variableName : variableNames) {
                variables.put(variableName, context.getVariable(variableName));
            }
            return new SlingEngineContext(resourceResolver, configuration, templateData, templateResolutionAttributes, locale, variables);
        }
        throw new IllegalStateException("context is not an instance of SlingContext");
    }
}

