/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.repl.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"repl/components/repl"}, selectors={"java"}, methods={"GET"}, extensions={"html"})
public class REPLJavaSourceCodeServlet
extends SlingSafeMethodsServlet {
    private static final String FS_CLASSLOADER_SN = "org.apache.sling.commons.fsclassloader";
    private static final Logger LOGGER = LoggerFactory.getLogger(REPLJavaSourceCodeServlet.class);
    private File classesFolder;

    @Activate
    protected void activate(ComponentContext componentContext) {
        for (Bundle bundle : componentContext.getBundleContext().getBundles()) {
            if (!FS_CLASSLOADER_SN.equals(bundle.getSymbolicName())) continue;
            BundleContext context = bundle.getBundleContext();
            this.classesFolder = new File(context.getDataFile(""), "classes");
        }
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        String sourceCode = this.getClassSourceCode();
        if (sourceCode.length() == 0) {
            StringBuilder configurationLink = new StringBuilder();
            configurationLink.append(request.getScheme()).append("://").append(request.getServerName());
            if (request.getServerPort() != 80) {
                configurationLink.append(":").append(request.getServerPort());
            }
            configurationLink.append(request.getContextPath()).append("/system/console/configMgr/org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration");
            response.getWriter().write("/**\n * Please enable the \"Keep Generated Java Source Code\" option at\n * " + configurationLink.toString() + "\n */");
        } else {
            response.getWriter().write(this.getClassSourceCode());
        }
    }

    private String getClassSourceCode() {
        if (this.classesFolder != null && this.classesFolder.isDirectory()) {
            File classFile = new File(this.classesFolder, "org/apache/sling/scripting/sightly/apps/repl/components/repl/template_html.java");
            if (classFile.isFile()) {
                try {
                    return IOUtils.toString((InputStream)new FileInputStream(classFile), (String)"UTF-8");
                }
                catch (IOException e) {
                    LOGGER.error("Unable to read file " + classFile.getAbsolutePath(), (Throwable)e);
                }
            }
            LOGGER.warn("Source code for " + (this.classesFolder.isDirectory() ? this.classesFolder.getAbsolutePath() : "") + "/org/apache/sling/scripting/sightly/apps/repl/components/repl/template_html.java was not found. Maybe you need to configure the HTL Scripting Engine to keep the generated source files?");
        }
        return "";
    }
}

