/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.use;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver {
    private final ResourceResolver scriptingResourceResolver;

    public DependencyResolver(@NotNull ResourceResolver scriptingResourceResolver) {
        this.scriptingResourceResolver = scriptingResourceResolver;
    }

    @Nullable
    public ScriptNameAwareReader resolve(Bindings bindings, String dependency) {
        if (!Utils.isJsScript(dependency)) {
            throw new SightlyException("Only JS scripts are allowed as dependencies. Invalid dependency: " + dependency);
        }
        ScriptNameAwareReader reader = null;
        IOException ioException = null;
        try {
            Resource scriptResource = this.scriptingResourceResolver.getResource(dependency);
            Resource caller = this.getCaller(bindings);
            if (scriptResource == null && caller != null) {
                Resource requestResource = (Resource)bindings.get("resource");
                String type = requestResource.getResourceType();
                while (scriptResource == null && type != null) {
                    Resource servletResource = null;
                    if (!type.startsWith("/")) {
                        String searchPath;
                        String normalizedPath;
                        String[] stringArray = this.scriptingResourceResolver.getSearchPath();
                        int n = stringArray.length;
                        for (int i = 0; i < n && (servletResource = this.resolveResource(normalizedPath = ResourceUtil.normalize((String)((searchPath = stringArray[i]) + "/" + type)))) == null; ++i) {
                        }
                    } else {
                        servletResource = this.resolveResource(type);
                    }
                    if (servletResource != null) {
                        scriptResource = servletResource.getChild(dependency);
                        type = servletResource.getResourceSuperType();
                        continue;
                    }
                    type = null;
                }
                if (scriptResource == null) {
                    if (dependency.startsWith("..")) {
                        String absolutePath = ResourceUtil.normalize((String)(caller.getPath() + "/" + dependency));
                        if (StringUtils.isNotEmpty((CharSequence)absolutePath)) {
                            scriptResource = this.resolveResource(absolutePath);
                        }
                        if (scriptResource == null) {
                            scriptResource = caller.getChild(dependency);
                        }
                    } else {
                        Resource callerParent = caller.getParent();
                        if (callerParent != null) {
                            scriptResource = callerParent.getChild(dependency);
                        }
                    }
                }
            }
            if (scriptResource == null) {
                throw new SightlyException(String.format("Unable to load script dependency %s.", dependency));
            }
            InputStream scriptStream = (InputStream)scriptResource.adaptTo(InputStream.class);
            if (scriptStream == null) {
                throw new SightlyException(String.format("Unable to read script %s.", dependency));
            }
            reader = new ScriptNameAwareReader((Reader)new StringReader(IOUtils.toString((InputStream)scriptStream, (Charset)StandardCharsets.UTF_8)), scriptResource.getPath());
            IOUtils.closeQuietly((InputStream)scriptStream);
        }
        catch (IOException e) {
            ioException = e;
        }
        if (ioException != null) {
            throw new SightlyException(String.format("Unable to load script dependency %s.", dependency), (Throwable)ioException);
        }
        return reader;
    }

    private Resource resolveResource(String type) {
        Resource servletResource = this.scriptingResourceResolver.resolve(type);
        if (ResourceUtil.isNonExistingResource((Resource)servletResource)) {
            servletResource = this.scriptingResourceResolver.getResource(type);
        }
        return servletResource;
    }

    private Resource getCaller(Bindings bindings) {
        SlingScriptHelper scriptHelper;
        Resource caller = null;
        String callerName = (String)bindings.get("javax.script.filename");
        if (StringUtils.isNotEmpty((CharSequence)callerName)) {
            caller = this.scriptingResourceResolver.getResource(callerName);
        }
        if (caller == null && (scriptHelper = Utils.getHelper(bindings)) != null) {
            caller = scriptHelper.getScript().getScriptResource();
        }
        return caller;
    }
}

