/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.use;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver {
    private final ResourceResolver scriptingResourceResolver;

    public DependencyResolver(@NotNull ResourceResolver scriptingResourceResolver) {
        this.scriptingResourceResolver = scriptingResourceResolver;
    }

    @Nullable
    public ScriptNameAwareReader resolve(Bindings bindings, String dependency) {
        if (!Utils.isJsScript(dependency)) {
            throw new SightlyException("Only JS scripts are allowed as dependencies. Invalid dependency: " + dependency);
        }
        ScriptNameAwareReader reader = null;
        IOException ioException = null;
        try {
            Resource scriptResource = null;
            if (dependency.startsWith("/")) {
                scriptResource = this.scriptingResourceResolver.getResource(dependency);
            }
            if (scriptResource == null) {
                SlingScriptHelper scriptHelper;
                String callerName = (String)bindings.get("javax.script.filename");
                Resource caller = null;
                if (StringUtils.isNotEmpty((CharSequence)callerName)) {
                    caller = this.scriptingResourceResolver.getResource(callerName);
                }
                if (caller == null && (scriptHelper = Utils.getHelper(bindings)) != null) {
                    caller = scriptHelper.getScript().getScriptResource();
                }
                if (caller != null && Utils.isJsScript(caller.getName()) && ("sling/bundle/resource".equals(caller.getResourceType()) || "nt:file".equals(caller.getResourceType())) && (caller = caller.getParent()) != null) {
                    scriptResource = caller.getChild(dependency);
                }
            }
            if (scriptResource == null) {
                Resource requestResource = (Resource)bindings.get("resource");
                String type = requestResource.getResourceType();
                while (scriptResource == null && type != null) {
                    Resource servletResource = null;
                    if (!type.startsWith("/")) {
                        String searchPath;
                        String normalizedPath;
                        String[] stringArray = this.scriptingResourceResolver.getSearchPath();
                        int n = stringArray.length;
                        for (int i = 0; i < n && ((normalizedPath = ResourceUtil.normalize((String)((searchPath = stringArray[i]) + "/" + type))) == null || (servletResource = this.scriptingResourceResolver.resolve(normalizedPath)) instanceof NonExistingResource); ++i) {
                        }
                    } else {
                        servletResource = this.scriptingResourceResolver.resolve(type);
                    }
                    if (servletResource != null) {
                        scriptResource = servletResource.getChild(dependency);
                        type = servletResource.getResourceSuperType();
                        continue;
                    }
                    type = null;
                }
            }
            if (scriptResource == null) {
                throw new SightlyException(String.format("Unable to load script dependency %s.", dependency));
            }
            reader = new ScriptNameAwareReader((Reader)new StringReader(IOUtils.toString((InputStream)((InputStream)scriptResource.adaptTo(InputStream.class)), (Charset)StandardCharsets.UTF_8)), scriptResource.getPath());
        }
        catch (IOException e) {
            ioException = e;
        }
        if (ioException != null) {
            throw new SightlyException(String.format("Unable to load script dependency %s.", dependency), (Throwable)ioException);
        }
        return reader;
    }
}

