/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.use;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyResolver {
    private final ResourceResolver scriptingResourceResolver;

    public DependencyResolver(@NotNull ResourceResolver scriptingResourceResolver) {
        this.scriptingResourceResolver = scriptingResourceResolver;
    }

    @Nullable
    public ScriptNameAwareReader resolve(Bindings bindings, String dependency) {
        if (!Utils.isJsScript(dependency)) {
            throw new SightlyException("Only JS scripts are allowed as dependencies. Invalid dependency: " + dependency);
        }
        ScriptNameAwareReader reader = null;
        IOException ioException = null;
        try {
            if (reader == null) {
                SlingScriptHelper scriptHelper;
                Resource scriptResource = null;
                if (dependency.startsWith("/")) {
                    scriptResource = this.scriptingResourceResolver.getResource(dependency);
                }
                if (scriptResource == null && (scriptHelper = Utils.getHelper(bindings)) != null) {
                    String type;
                    Resource resource;
                    String callerName = (String)bindings.get("javax.script.filename");
                    Resource caller = null;
                    if (StringUtils.isNotEmpty((CharSequence)callerName)) {
                        caller = this.scriptingResourceResolver.getResource(callerName);
                    }
                    SlingScript slingScript = scriptHelper.getScript();
                    if (caller == null && slingScript != null) {
                        caller = this.scriptingResourceResolver.getResource(slingScript.getScriptResource().getPath());
                    }
                    if (caller == null && (resource = (Resource)bindings.get("resource")) != null && (caller = this.scriptingResourceResolver.getResource(type = resource.getResourceType())) != null) {
                        scriptResource = Utils.getScriptResource(caller, dependency, bindings);
                    }
                    if (caller != null) {
                        scriptResource = Utils.getScriptResource(caller, dependency, bindings);
                    }
                }
                if (scriptResource != null) {
                    reader = new ScriptNameAwareReader((Reader)new StringReader(IOUtils.toString((InputStream)((InputStream)scriptResource.adaptTo(InputStream.class)), (Charset)StandardCharsets.UTF_8)), scriptResource.getPath());
                }
            }
        }
        catch (IOException e) {
            ioException = e;
        }
        if (ioException != null) {
            throw new SightlyException(String.format("Unable to load script dependency %s.", dependency), (Throwable)ioException);
        }
        return reader;
    }
}

