/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.Console;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.TimingBindingsValuesProvider;
import org.apache.sling.scripting.sightly.js.impl.async.UnaryCallback;
import org.apache.sling.scripting.sightly.js.impl.cjs.CommonJsModule;
import org.apache.sling.scripting.sightly.js.impl.loop.EventLoop;
import org.apache.sling.scripting.sightly.js.impl.loop.EventLoopInterop;
import org.apache.sling.scripting.sightly.js.impl.loop.Task;
import org.apache.sling.scripting.sightly.js.impl.use.DependencyResolver;
import org.apache.sling.scripting.sightly.js.impl.use.UseFunction;
import org.mozilla.javascript.Context;
import org.slf4j.LoggerFactory;

public class JsEnvironment {
    private final ScriptEngine jsEngine;
    private final Bindings engineBindings;
    private EventLoop eventLoop;

    public JsEnvironment(ScriptEngine jsEngine) {
        this.jsEngine = jsEngine;
        this.engineBindings = new LazyBindings();
        TimingBindingsValuesProvider.INSTANCE.addBindings(this.engineBindings);
    }

    public void initialize() {
        Context context = Context.enter();
        this.eventLoop = EventLoopInterop.obtainEventLoop(context);
    }

    public void cleanup() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new IllegalStateException("No current context");
        }
        EventLoopInterop.cleanupEventLoop(context);
        Context.exit();
    }

    public void runResource(Resource scriptResource, Bindings globalBindings, Bindings arguments, UnaryCallback callback) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        CommonJsModule module = new CommonJsModule();
        Bindings scriptBindings = this.buildBindings(scriptResource, globalBindings, arguments, module);
        scriptContext.setBindings(scriptBindings, 100);
        scriptContext.setAttribute("javax.script.filename", scriptResource.getPath(), 100);
        this.runScript(scriptResource, scriptContext, callback, module);
    }

    public AsyncContainer runResource(Resource scriptResource, Bindings globalBindings, Bindings arguments) {
        AsyncContainer asyncContainer = new AsyncContainer();
        this.runResource(scriptResource, globalBindings, arguments, asyncContainer.createCompletionCallback());
        return asyncContainer;
    }

    private Bindings buildBindings(Resource scriptResource, Bindings local, Bindings arguments, CommonJsModule commonJsModule) {
        LazyBindings bindings = new LazyBindings();
        bindings.putAll(this.engineBindings);
        DependencyResolver dependencyResolver = new DependencyResolver(scriptResource, this, local);
        UseFunction useFunction = new UseFunction(dependencyResolver, arguments);
        bindings.put("use", (Object)useFunction);
        bindings.put("module", (Object)commonJsModule);
        bindings.put("exports", commonJsModule.getExports());
        bindings.put("console", (Object)new Console(LoggerFactory.getLogger((String)scriptResource.getName())));
        bindings.putAll(local);
        return bindings;
    }

    private void runScript(Resource scriptResource, ScriptContext scriptContext, UnaryCallback callback, CommonJsModule commonJsModule) {
        this.eventLoop.schedule(this.scriptTask(scriptResource, scriptContext, callback, commonJsModule));
    }

    private Task scriptTask(final Resource scriptResource, final ScriptContext scriptContext, final UnaryCallback callback, final CommonJsModule commonJsModule) {
        return new Task(new Runnable(){

            @Override
            public void run() {
                InputStreamReader reader;
                block8: {
                    reader = null;
                    try {
                        Object result;
                        if (JsEnvironment.this.jsEngine instanceof Compilable) {
                            reader = new ScriptNameAwareReader((Reader)new InputStreamReader((InputStream)scriptResource.adaptTo(InputStream.class), StandardCharsets.UTF_8), scriptResource.getPath());
                            result = ((Compilable)((Object)JsEnvironment.this.jsEngine)).compile(reader).eval(scriptContext);
                        } else {
                            reader = new InputStreamReader((InputStream)scriptResource.adaptTo(InputStream.class), StandardCharsets.UTF_8);
                            result = JsEnvironment.this.jsEngine.eval((Reader)reader, scriptContext);
                        }
                        if (commonJsModule.isModified()) {
                            result = commonJsModule.getExports();
                        }
                        if (result instanceof AsyncContainer) {
                            ((AsyncContainer)result).addListener(callback);
                            break block8;
                        }
                        callback.invoke(result);
                    }
                    catch (ScriptException e) {
                        try {
                            throw new SightlyException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(reader);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        });
    }
}

