/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.commands.AbstractCommandVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.Procedure;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalShadowChecker
extends AbstractCommandVisitor {
    private static final Logger log = LoggerFactory.getLogger(GlobalShadowChecker.class);
    private final Map<String, String> globals = new HashMap<String, String>();

    public GlobalShadowChecker(Set<String> globals) {
        for (String global : globals) {
            this.globals.put(global.toLowerCase(), global);
        }
    }

    public void visit(VariableBinding.Start variableBindingStart) {
        this.checkVariable(variableBindingStart.getVariableName());
    }

    public void visit(VariableBinding.Global globalAssignment) {
        this.checkVariable(globalAssignment.getVariableName());
    }

    public void visit(Loop.Start loopStart) {
        this.checkVariable(loopStart.getItemVariable());
        this.checkVariable(loopStart.getIndexVariable());
    }

    public void visit(Procedure.Start startProcedure) {
        this.checkVariable(startProcedure.getName());
    }

    private void checkVariable(String variableName) {
        if (this.globals.containsKey(variableName = variableName.toLowerCase())) {
            String originalName = this.globals.get(variableName);
            log.warn("Global variable '{}' is being overridden in template", (Object)originalName);
        }
    }
}

