/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.AbstractFilter;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;

public class URIManipulationFilter
extends AbstractFilter {
    public static final String SCHEME = "scheme";
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String APPEND_PATH = "appendPath";
    public static final String PREPEND_PATH = "prependPath";
    public static final String SELECTORS = "selectors";
    public static final String ADD_SELECTORS = "addSelectors";
    public static final String REMOVE_SELECTORS = "removeSelectors";
    public static final String EXTENSION = "extension";
    public static final String SUFFIX = "suffix";
    public static final String PREPEND_SUFFIX = "prependSuffix";
    public static final String APPEND_SUFFIX = "appendSuffix";
    public static final String FRAGMENT = "fragment";
    public static final String QUERY = "query";
    public static final String ADD_QUERY = "addQuery";
    public static final String REMOVE_QUERY = "removeQuery";
    private static final Set<ExpressionContext> APPLICABLE_CONTEXTS;

    private URIManipulationFilter() {
        super(APPLICABLE_CONTEXTS, new HashSet<String>(Arrays.asList(SCHEME, DOMAIN, PATH, APPEND_PATH, PREPEND_PATH, SELECTORS, ADD_SELECTORS, REMOVE_SELECTORS, EXTENSION, SUFFIX, PREPEND_SUFFIX, APPEND_SUFFIX, FRAGMENT, QUERY, ADD_QUERY, REMOVE_QUERY)), Collections.emptySet());
    }

    public static URIManipulationFilter getInstance() {
        return URIManipulationFilterLoader.INSTANCE;
    }

    @Override
    protected Expression apply(Expression expression, Map<String, ExpressionNode> options) {
        if (options.size() > 0) {
            RuntimeCall translation = new RuntimeCall("uriManipulation", expression.getRoot(), new MapLiteral(options));
            return expression.withNode(translation);
        }
        return expression;
    }

    static {
        HashSet<ExpressionContext> applicableContexts = new HashSet<ExpressionContext>(Arrays.asList(ExpressionContext.values()));
        applicableContexts.remove((Object)ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE);
        applicableContexts.remove((Object)ExpressionContext.PLUGIN_DATA_SLY_CALL);
        applicableContexts.remove((Object)ExpressionContext.PLUGIN_DATA_SLY_RESOURCE);
        applicableContexts.remove((Object)ExpressionContext.PLUGIN_DATA_SLY_INCLUDE);
        APPLICABLE_CONTEXTS = Collections.unmodifiableSet(applicableContexts);
    }

    private static final class URIManipulationFilterLoader {
        private static final URIManipulationFilter INSTANCE = new URIManipulationFilter();

        private URIManipulationFilterLoader() {
        }
    }
}

