/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.OutText;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.MarkupContext;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class ElementPlugin
extends AbstractPlugin {
    public ElementPlugin() {
        this.name = "element";
    }

    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private final ExpressionNode node;
            private String tagVar;
            {
                this.node = ElementPlugin.this.adjustContext(compilerContext, expression, MarkupContext.ELEMENT_NAME, ExpressionContext.ELEMENT).getRoot();
                this.tagVar = compilerContext.generateVariable("tagVar");
            }

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                stream.write(new VariableBinding.Start(this.tagVar, this.node));
            }

            @Override
            public void beforeTagOpen(PushStream stream) {
                stream.write(new Conditional.Start(this.tagVar, true));
                stream.write(new OutText("<"));
                stream.write(new OutputVariable(this.tagVar));
                stream.write(Conditional.END);
                stream.write(new Conditional.Start(this.tagVar, false));
            }

            @Override
            public void beforeAttributes(PushStream stream) {
                stream.write(Conditional.END);
            }

            @Override
            public void beforeTagClose(PushStream stream, boolean isSelfClosing) {
                if (!isSelfClosing) {
                    stream.write(new Conditional.Start(this.tagVar, true));
                    stream.write(new OutText("</"));
                    stream.write(new OutputVariable(this.tagVar));
                    stream.write(new OutText(">"));
                    stream.write(Conditional.END);
                }
                stream.write(new Conditional.Start(this.tagVar, false));
            }

            @Override
            public void afterTagClose(PushStream stream, boolean isSelfClosing) {
                stream.write(Conditional.END);
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(VariableBinding.END);
            }
        };
    }

    private Expression adjustContext(CompilerContext compilerContext, Expression expression, MarkupContext markupContext, ExpressionContext expressionContext) {
        RuntimeCall runtimeCall;
        ExpressionNode root = expression.getRoot();
        if (root instanceof RuntimeCall && (runtimeCall = (RuntimeCall)root).getFunctionName().equals("xss")) {
            return expression;
        }
        return compilerContext.adjustToContext(expression, markupContext, expressionContext);
    }
}

