/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.AbstractFilter;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;

public class XSSFilter
extends AbstractFilter {
    private XSSFilter() {
        if (XSSFilterLoader.INSTANCE != null) {
            throw new IllegalStateException("INSTANCE was already defined.");
        }
        this.priority = 110;
    }

    public static XSSFilter getInstance() {
        return XSSFilterLoader.INSTANCE;
    }

    @Override
    public Expression apply(Expression expression, ExpressionContext expressionContext) {
        if (expressionContext == ExpressionContext.PLUGIN_DATA_SLY_USE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_CALL) {
            return expression;
        }
        ExpressionNode context = expression.removeOption("context");
        if (context != null) {
            return expression.withNode(new RuntimeCall("xss", expression.getRoot(), context));
        }
        return expression;
    }

    private static final class XSSFilterLoader {
        private static final XSSFilter INSTANCE = new XSSFilter();

        private XSSFilterLoader() {
        }
    }
}

