/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={RuntimeExtension.class}, property={"org.apache.sling.scripting.sightly.extension.name=use"})
public class UseRuntimeExtension
implements RuntimeExtension {
    private final Map<ServiceReference, UseProvider> providersMap = new ConcurrentSkipListMap<ServiceReference, UseProvider>();

    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("use", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String identifier = runtimeObjectModel.toString(arguments[0]);
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            throw new SightlyException("data-sly-use needs to be passed an identifier");
        }
        Map useArgumentsMap = runtimeObjectModel.toMap(arguments[1]);
        SimpleBindings useArguments = new SimpleBindings(Collections.unmodifiableMap(useArgumentsMap));
        ArrayList<UseProvider> providers = new ArrayList<UseProvider>(this.providersMap.values());
        ListIterator<UseProvider> iterator = providers.listIterator(providers.size());
        while (iterator.hasPrevious()) {
            UseProvider provider = iterator.previous();
            ProviderOutcome outcome = provider.provide(identifier, renderContext, (Bindings)useArguments);
            if (outcome.isSuccess()) {
                return outcome.getResult();
            }
            Throwable failureCause = outcome.getCause();
            if (failureCause == null) continue;
            throw new SightlyException("Identifier " + identifier + " cannot be correctly instantiated by the Use API", failureCause);
        }
        throw new SightlyException("No use provider could resolve identifier " + identifier);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, service=UseProvider.class, cardinality=ReferenceCardinality.MULTIPLE)
    private void bindUseProvider(ServiceReference<UseProvider> serviceReference, UseProvider provider) {
        this.providersMap.put(serviceReference, provider);
    }

    private void unbindUseProvider(ServiceReference serviceReference) {
        this.providersMap.remove(serviceReference);
    }
}

