/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.utils;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.sightly.engine.ResourceResolution;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.jetbrains.annotations.NotNull;

public class ScriptUtils {
    private ScriptUtils() {
    }

    public static Resource resolveScript(ResourceResolver resolver, RenderContext renderContext, String scriptIdentifier) {
        SlingScriptHelper sling;
        SlingHttpServletRequest request = BindingsUtils.getRequest(renderContext.getBindings());
        Resource caller = ResourceResolution.getResourceForRequest(resolver, request);
        Resource result = ResourceResolution.getResourceFromSearchPath(caller, scriptIdentifier);
        if (result == null && (sling = BindingsUtils.getHelper(renderContext.getBindings())) != null) {
            caller = ScriptUtils.getResource(resolver, sling.getScript().getScriptResource());
            result = ResourceResolution.getResourceFromSearchPath(caller, scriptIdentifier);
        }
        return result;
    }

    private static Resource getResource(@NotNull ResourceResolver resolver, @NotNull Resource resource) {
        String path = resource.getPath();
        if (path.startsWith("/")) {
            Resource resolved = resolver.resolve(path);
            if (ResourceUtil.isNonExistingResource((Resource)resolved)) {
                return null;
            }
            return resolved;
        }
        for (String sp : resolver.getSearchPath()) {
            Resource resolved;
            String absolutePath = ResourceUtil.normalize((String)(sp + path));
            if (absolutePath == null || ResourceUtil.isNonExistingResource((Resource)(resolved = resolver.resolve(absolutePath)))) continue;
            return resolved;
        }
        return null;
    }
}

