/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.bundled;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import javax.script.Bindings;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.type.ResourceType;
import org.apache.sling.commons.compiler.source.JavaEscapeHelper;
import org.apache.sling.scripting.api.CachedScript;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.engine.BundledUnitManager;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderUnit;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.apache.sling.scripting.spi.bundle.TypeProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BundledUnitManagerImpl.class, BundledUnitManager.class})
public class BundledUnitManagerImpl
implements BundledUnitManager {
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference
    private ScriptCache scriptCache;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Nullable
    public RenderUnit getRenderUnit(@NotNull Bindings bindings) {
        Object renderUnit;
        BundledRenderUnit bundledRenderUnit = this.getBundledRenderUnit(bindings);
        if (bundledRenderUnit != null && (renderUnit = bundledRenderUnit.getUnit()) instanceof RenderUnit) {
            return (RenderUnit)renderUnit;
        }
        return null;
    }

    @Nullable
    public RenderUnit getRenderUnit(@NotNull Bindings bindings, @NotNull String identifier) {
        BundledRenderUnit bundledRenderUnit = this.getBundledRenderUnit(bindings);
        Resource currentResource = BindingsUtils.getResource(bindings);
        LinkedHashSet<String> defaultLocations = new LinkedHashSet<String>();
        for (String searchPath : this.resourceResolverFactory.getSearchPath()) {
            if (identifier.startsWith("/")) {
                defaultLocations.add(identifier);
                if (!identifier.startsWith(searchPath)) continue;
                defaultLocations.add(identifier.substring(searchPath.length()));
                continue;
            }
            String path = ResourceUtil.normalize((String)(searchPath + "/" + identifier));
            if (path == null) continue;
            defaultLocations.add(path);
        }
        if (currentResource != null && bundledRenderUnit != null) {
            for (TypeProvider provider : bundledRenderUnit.getTypeProviders()) {
                LinkedHashSet<String> locations = new LinkedHashSet<String>();
                if (!identifier.startsWith("/")) {
                    for (ResourceType type : provider.getBundledRenderUnitCapability().getResourceTypes()) {
                        locations.add(this.getResourceTypeQualifiedPath(identifier, type));
                    }
                }
                locations.addAll(defaultLocations);
                for (String renderUnitIdentifier : locations) {
                    String renderUnitBundledPath = renderUnitIdentifier;
                    if (renderUnitBundledPath.startsWith("/")) {
                        renderUnitBundledPath = renderUnitBundledPath.substring(1);
                    }
                    String className = JavaEscapeHelper.makeJavaPackage((String)renderUnitBundledPath);
                    try {
                        Class clazz = provider.getBundle().loadClass(className);
                        if (clazz.getSuperclass() != RenderUnit.class) continue;
                        return (RenderUnit)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException e) {
                        RenderUnit renderUnit;
                        URL bundledScriptURL = provider.getBundle().getEntry("javax.script/" + renderUnitBundledPath);
                        if (bundledScriptURL == null) continue;
                        SightlyScriptEngine sightlyScriptEngine = (SightlyScriptEngine)((Object)this.scriptEngineManager.getEngineByName("htl"));
                        if (sightlyScriptEngine == null) continue;
                        CachedScript cachedScript = this.scriptCache.getScript(bundledScriptURL.toExternalForm());
                        if (cachedScript != null) {
                            return ((SightlyCompiledScript)cachedScript.getCompiledScript()).getRenderUnit();
                        }
                        ScriptNameAwareReader reader = new ScriptNameAwareReader((Reader)new InputStreamReader(bundledScriptURL.openStream(), StandardCharsets.UTF_8), renderUnitIdentifier);
                        try {
                            SightlyCompiledScript compiledScript = (SightlyCompiledScript)sightlyScriptEngine.compile((Reader)reader);
                            renderUnit = compiledScript.getRenderUnit();
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (IOException | ScriptException compileException) {
                                throw new IllegalStateException(compileException);
                            }
                        }
                        reader.close();
                        return renderUnit;
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public URL getScript(Bindings bindings, String identifier) {
        BundledRenderUnit bundledRenderUnit = this.getBundledRenderUnit(bindings);
        Resource currentResource = BindingsUtils.getResource(bindings);
        if (currentResource != null && bundledRenderUnit != null) {
            for (TypeProvider provider : bundledRenderUnit.getTypeProviders()) {
                for (ResourceType type : provider.getBundledRenderUnitCapability().getResourceTypes()) {
                    URL bundledScriptURL;
                    String scriptBundledPath = this.getResourceTypeQualifiedPath(identifier, type);
                    if (scriptBundledPath.startsWith("/")) {
                        scriptBundledPath = scriptBundledPath.substring(1);
                    }
                    if ((bundledScriptURL = provider.getBundle().getEntry("javax.script/" + scriptBundledPath)) == null) continue;
                    return bundledScriptURL;
                }
            }
        }
        return null;
    }

    @NotNull
    private String getResourceTypeQualifiedPath(@NotNull String identifier, @NotNull ResourceType type) {
        if (!identifier.startsWith("/")) {
            return type.toString() + "/" + identifier;
        }
        return identifier;
    }

    @Override
    @Nullable
    public ClassLoader getBundledRenderUnitClassloader(Bindings bindings) {
        Object bru = bindings.get(BundledRenderUnit.VARIABLE);
        if (bru instanceof BundledRenderUnit) {
            BundledRenderUnit bundledRenderUnit = (BundledRenderUnit)bru;
            return ((BundleWiring)bundledRenderUnit.getBundle().adapt(BundleWiring.class)).getClassLoader();
        }
        return null;
    }

    @Nullable
    public <T> T getServiceForBundledRenderUnit(Bindings bindings, Class<T> clazz) {
        Object bru = bindings.get(BundledRenderUnit.VARIABLE);
        if (bru instanceof BundledRenderUnit) {
            BundledRenderUnit bundledRenderUnit = (BundledRenderUnit)bru;
            return (T)bundledRenderUnit.getService(clazz.getName());
        }
        return null;
    }

    @Nullable
    private BundledRenderUnit getBundledRenderUnit(Bindings bindings) {
        Object bru = bindings.get(BundledRenderUnit.VARIABLE);
        if (bru instanceof BundledRenderUnit) {
            return (BundledRenderUnit)bru;
        }
        return null;
    }
}

