/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.compiled;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.commons.compiler.source.JavaEscapeHelper;
import org.apache.sling.scripting.api.CachedScript;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.api.ScriptNameAware;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.compiler.CompilerMessage;
import org.apache.sling.scripting.sightly.compiler.SightlyCompiler;
import org.apache.sling.scripting.sightly.compiler.backend.BackendCompiler;
import org.apache.sling.scripting.sightly.impl.engine.ResourceBackedPojoChangeMonitor;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SightlyCompilationUnit;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SlingJavaImportsAnalyser;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.impl.utils.Patterns;
import org.apache.sling.scripting.sightly.impl.utils.ScriptUtils;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.GlobalShadowCheckBackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.JavaClassBackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.JavaImportsAnalyzer;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RenderUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingHTLMasterCompiler.class})
public class SlingHTLMasterCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingHTLMasterCompiler.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ClassLoaderWriter classLoaderWriter;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SightlyCompiler sightlyCompiler;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private JavaCompiler javaCompiler;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration;
    @Reference
    private ResourceBackedPojoChangeMonitor resourceBackedPojoChangeMonitor;
    @Reference
    private ScriptCache scriptCache;
    private static final String NO_SCRIPT = "NO_SCRIPT";
    private static final String JAVA_EXTENSION = ".java";
    static final String SIGHTLY_CONFIG_FILE = "/sightly.config";
    private final Map<String, Lock> compilationLocks = new HashMap<String, Lock>();
    private Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void activate() {
        LOGGER.info("Activating {}", (Object)this.getClass().getName());
        String version = System.getProperty("java.specification.version");
        this.options = new Options();
        this.options.put((Object)"generateDebugInfo", (Object)true);
        this.options.put((Object)"sourceVersion", (Object)version);
        this.options.put((Object)"targetVersion", (Object)version);
        this.options.put((Object)"classLoaderWriter", (Object)this.classLoaderWriter);
        this.options.put((Object)"forceCompilation", (Object)true);
        boolean newVersion = true;
        String versionInfo = null;
        String newVersionString = this.sightlyEngineConfiguration.getEngineVersion();
        try {
            InputStream is = this.classLoaderWriter.getInputStream(SIGHTLY_CONFIG_FILE);
            if (is != null) {
                versionInfo = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (newVersionString.equals(versionInfo)) {
                    newVersion = false;
                } else {
                    LOGGER.info("Detected stale classes generated by Apache Sling Scripting HTL engine version {}.", (Object)versionInfo);
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newVersion) {
            OutputStream os = this.classLoaderWriter.getOutputStream(SIGHTLY_CONFIG_FILE);
            try {
                IOUtils.write((String)this.sightlyEngineConfiguration.getEngineVersion(), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
            String scratchFolder = this.sightlyEngineConfiguration.getScratchFolder();
            boolean scratchFolderDeleted = this.classLoaderWriter.delete(scratchFolder);
            if (scratchFolderDeleted && StringUtils.isNotEmpty((CharSequence)versionInfo)) {
                LOGGER.info("Deleted stale classes generated by Apache Sling Scripting HTL engine version {}.", (Object)versionInfo);
            }
        }
        this.sightlyCompiler = SightlyCompiler.withKnownExpressionOptions(this.sightlyEngineConfiguration.getAllowedExpressionOptions());
    }

    public Object getResourceBackedUseObject(RenderContext renderContext, String className) {
        LOGGER.debug("Attempting to load class {}.", (Object)className);
        try {
            if (className.contains(".")) {
                Resource pojoResource = this.getPOJOFromFQCN(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), className);
                if (pojoResource != null) {
                    return this.getUseObjectAndRecompileIfNeeded(pojoResource);
                }
            } else {
                Resource pojoResource = ScriptUtils.resolveScript(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), renderContext, className + JAVA_EXTENSION);
                if (pojoResource != null) {
                    return this.getUseObjectAndRecompileIfNeeded(pojoResource);
                }
            }
        }
        catch (Exception e) {
            throw new SightlyException("Cannot obtain an instance for class " + className + ".", (Throwable)e);
        }
        return null;
    }

    public SightlyCompiledScript compileHTLScript(SightlyScriptEngine engine, final Reader script, ScriptContext scriptContext) throws ScriptException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.dynamicClassLoaderManager.getDynamicClassLoader());
        try {
            org.apache.sling.scripting.sightly.compiler.CompilationResult result;
            String scriptName;
            CachedScript cachedScript;
            String sName = NO_SCRIPT;
            if (script instanceof ScriptNameAware) {
                sName = ((ScriptNameAware)script).getScriptName();
            }
            if (sName.equals(NO_SCRIPT)) {
                sName = this.getScriptName(scriptContext);
            }
            if ((cachedScript = this.scriptCache.getScript(scriptName = sName)) != null && cachedScript.getCompiledScript() instanceof SightlyCompiledScript) {
                SightlyCompiledScript sightlyCompiledScript = (SightlyCompiledScript)cachedScript.getCompiledScript();
                return sightlyCompiledScript;
            }
            org.apache.sling.scripting.sightly.compiler.CompilationUnit compilationUnit = new org.apache.sling.scripting.sightly.compiler.CompilationUnit(){

                public String getScriptName() {
                    return scriptName;
                }

                public Reader getScriptReader() {
                    return script;
                }
            };
            GlobalShadowCheckBackendCompiler shadowCheckBackendCompiler = null;
            SlingJavaImportsAnalyser importsAnalyser = new SlingJavaImportsAnalyser(this.scriptingResourceResolverProvider);
            JavaClassBackendCompiler javaClassBackendCompiler = new JavaClassBackendCompiler((JavaImportsAnalyzer)importsAnalyser);
            if (scriptContext != null) {
                Bindings bindings = scriptContext.getBindings(100);
                Set globals = bindings.keySet();
                shadowCheckBackendCompiler = new GlobalShadowCheckBackendCompiler((BackendCompiler)javaClassBackendCompiler, globals);
            }
            org.apache.sling.scripting.sightly.compiler.CompilationResult compilationResult = result = shadowCheckBackendCompiler == null ? this.sightlyCompiler.compile(compilationUnit, (BackendCompiler)javaClassBackendCompiler) : this.sightlyCompiler.compile(compilationUnit, shadowCheckBackendCompiler);
            if (!result.getWarnings().isEmpty()) {
                for (CompilerMessage warning : result.getWarnings()) {
                    LOGGER.warn("Script {} {}:{}: {}", new Object[]{warning.getScriptName(), warning.getLine(), warning.getColumn(), warning.getMessage()});
                }
            }
            if (!result.getErrors().isEmpty()) {
                CompilerMessage error = (CompilerMessage)result.getErrors().get(0);
                throw new ScriptException(error.getMessage(), error.getScriptName(), error.getLine(), error.getColumn());
            }
            SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, scriptName);
            String javaSourceCode = javaClassBackendCompiler.build((ClassInfo)sourceIdentifier);
            Object renderUnit = this.compileSource(sourceIdentifier, javaSourceCode);
            if (renderUnit instanceof RenderUnit) {
                final SightlyCompiledScript compiledScript = new SightlyCompiledScript(engine, (RenderUnit)renderUnit);
                this.scriptCache.putScript(new CachedScript(){

                    public String getScriptPath() {
                        return scriptName;
                    }

                    public CompiledScript getCompiledScript() {
                        return compiledScript;
                    }
                });
                SightlyCompiledScript sightlyCompiledScript = compiledScript;
                return sightlyCompiledScript;
            }
            throw new SightlyException("Expected a RenderUnit.");
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderWriter.getClassLoader();
    }

    Resource getPOJOFromFQCN(ResourceResolver resolver, String fullyQualifiedClassName) {
        StringBuilder pathElements = new StringBuilder("/");
        String[] classElements = StringUtils.split((String)fullyQualifiedClassName, (char)'.');
        for (int i = 0; i < classElements.length; ++i) {
            pathElements.append(JavaEscapeHelper.unescapeAll((String)classElements[i]));
            if (i >= classElements.length - 1) continue;
            pathElements.append("/");
        }
        return resolver.getResource(pathElements.toString() + JAVA_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compileSource(SourceIdentifier sourceIdentifier, String sourceCode) {
        Lock lock;
        String fqcn = sourceIdentifier.getFullyQualifiedClassName();
        Map<String, Lock> map = this.compilationLocks;
        synchronized (map) {
            lock = this.compilationLocks.get(fqcn);
            if (lock == null) {
                lock = new ReentrantLock();
                this.compilationLocks.put(fqcn, lock);
            }
        }
        lock.lock();
        try {
            if (this.sightlyEngineConfiguration.keepGenerated()) {
                String path = "/" + fqcn.replace(".", "/") + JAVA_EXTENSION;
                OutputStream os = this.classLoaderWriter.getOutputStream(path);
                IOUtils.write((String)sourceCode, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                IOUtils.closeQuietly((OutputStream)os);
            }
            String[] sourceCodeLines = sourceCode.split("\\r\\n|[\\n\\x0B\\x0C\\r\\u0085\\u2028\\u2029]");
            boolean foundPackageDeclaration = false;
            for (String line : sourceCodeLines) {
                Matcher matcher = Patterns.JAVA_PACKAGE_DECLARATION.matcher(line);
                if (!matcher.matches()) continue;
                foundPackageDeclaration = true;
                break;
            }
            if (!foundPackageDeclaration) {
                sourceCode = "package " + sourceIdentifier.getPackageName() + ";\n" + sourceCode;
            }
            SightlyCompilationUnit compilationUnit = new SightlyCompilationUnit(sourceCode, fqcn);
            long start = System.currentTimeMillis();
            CompilationResult compilationResult = this.javaCompiler.compile(new CompilationUnit[]{compilationUnit}, this.options);
            long end = System.currentTimeMillis();
            List errors = compilationResult.getErrors();
            if (errors != null && !errors.isEmpty()) {
                throw new SightlyException(this.createErrorMsg(errors));
            }
            if (compilationResult.didCompile()) {
                LOGGER.debug("Class {} was compiled in {}ms.", (Object)fqcn, (Object)(end - start));
            }
            Object obj = this.classLoaderWriter.getClassLoader().loadClass(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SightlyException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private Object getUseObjectAndRecompileIfNeeded(Resource pojoResource) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, pojoResource.getPath());
        long sourceLastModifiedDateFromCache = this.resourceBackedPojoChangeMonitor.getLastModifiedDateForJavaUseObject(pojoResource.getPath());
        long classLastModifiedDate = this.classLoaderWriter.getLastModified("/" + sourceIdentifier.getFullyQualifiedClassName().replaceAll("\\.", "/") + ".class");
        if (sourceLastModifiedDateFromCache == 0L) {
            long sourceLastModifiedDate = pojoResource.getResourceMetadata().getModificationTime();
            this.resourceBackedPojoChangeMonitor.recordLastModifiedTimestamp(pojoResource.getPath(), sourceLastModifiedDate);
            if (classLastModifiedDate < 0L || sourceLastModifiedDate > classLastModifiedDate) {
                return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (Charset)StandardCharsets.UTF_8));
            }
            return this.classLoaderWriter.getClassLoader().loadClass(sourceIdentifier.getFullyQualifiedClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (sourceLastModifiedDateFromCache > classLastModifiedDate) {
            return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (Charset)StandardCharsets.UTF_8));
        }
        return this.classLoaderWriter.getClassLoader().loadClass(sourceIdentifier.getFullyQualifiedClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private String createErrorMsg(List<org.apache.sling.commons.compiler.CompilerMessage> errors) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Compilation errors in ");
        buffer.append(errors.get(0).getFile());
        buffer.append(":");
        StringBuilder errorsBuffer = new StringBuilder();
        boolean duplicateVariable = false;
        for (org.apache.sling.commons.compiler.CompilerMessage e : errors) {
            if (!duplicateVariable && e.getMessage().contains("Duplicate local variable")) {
                duplicateVariable = true;
                buffer.append(" Maybe you defined more than one identical block elements without defining a different variable for each one?");
            }
            errorsBuffer.append("\nLine ");
            errorsBuffer.append(e.getLine());
            errorsBuffer.append(", column ");
            errorsBuffer.append(e.getColumn());
            errorsBuffer.append(" : ");
            errorsBuffer.append(e.getMessage());
        }
        buffer.append((CharSequence)errorsBuffer);
        return buffer.toString();
    }

    private String getScriptName(ScriptContext scriptContext) {
        if (scriptContext != null) {
            Bindings bindings = scriptContext.getBindings(100);
            String scriptName = (String)bindings.get("javax.script.filename");
            if (scriptName != null && !"".equals(scriptName)) {
                return scriptName;
            }
            SlingScriptHelper sling = BindingsUtils.getHelper(bindings);
            if (sling != null) {
                return sling.getScript().getScriptResource().getPath();
            }
        }
        return NO_SCRIPT;
    }
}

