/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.RuntimeExtensionReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ExtensionRegistryService.class})
public class ExtensionRegistryService {
    private volatile Map<String, RuntimeExtension> mapping = new HashMap<String, RuntimeExtension>();
    private final Map<String, TreeSet<RuntimeExtensionReference>> extensions = new HashMap<String, TreeSet<RuntimeExtensionReference>>();

    public Map<String, RuntimeExtension> extensions() {
        return this.mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, service=RuntimeExtension.class, cardinality=ReferenceCardinality.MULTIPLE)
    protected void bindExtensionService(ServiceReference<RuntimeExtension> serviceReference, RuntimeExtension runtimeExtension) {
        RuntimeExtensionReference rer = new RuntimeExtensionReference(serviceReference, runtimeExtension);
        Map<String, TreeSet<RuntimeExtensionReference>> map = this.extensions;
        synchronized (map) {
            Set namedExtensions = this.extensions.computeIfAbsent(rer.getName(), key -> new TreeSet());
            if (namedExtensions.add(rer)) {
                this.mapping = this.getRuntimeExtensions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindExtensionService(ServiceReference<RuntimeExtension> serviceReference) {
        Map<String, TreeSet<RuntimeExtensionReference>> map = this.extensions;
        synchronized (map) {
            String name = PropertiesUtil.toString((Object)serviceReference.getProperty("org.apache.sling.scripting.sightly.extension.name"), (String)"");
            Set namedExtensions = this.extensions.get(name);
            boolean changed = false;
            if (namedExtensions != null) {
                for (RuntimeExtensionReference runtimeExtensionReference : namedExtensions) {
                    if (!serviceReference.equals(runtimeExtensionReference.getServiceReference())) continue;
                    namedExtensions.remove(runtimeExtensionReference);
                    if (namedExtensions.isEmpty()) {
                        this.extensions.remove(name);
                    }
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.mapping = this.getRuntimeExtensions();
            }
        }
    }

    private Map<String, RuntimeExtension> getRuntimeExtensions() {
        HashMap<String, RuntimeExtension> replacement = new HashMap<String, RuntimeExtension>();
        for (Map.Entry<String, TreeSet<RuntimeExtensionReference>> entry : this.extensions.entrySet()) {
            replacement.put(entry.getKey(), entry.getValue().last().getService());
        }
        return Collections.unmodifiableMap(replacement);
    }
}

