/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.runtime;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.ExtensionRegistryService;
import org.apache.sling.scripting.sightly.impl.engine.runtime.SlingRuntimeObjectModel;
import org.apache.sling.scripting.sightly.render.AbstractRuntimeObjectModel;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;

public class RenderContextImpl
implements RenderContext {
    private static final AbstractRuntimeObjectModel OBJECT_MODEL = new SlingRuntimeObjectModel();
    private final Bindings bindings;
    private final ExtensionRegistryService extensionRegistryService;

    public RenderContextImpl(ExtensionRegistryService extensionRegistryService, ScriptContext scriptContext) {
        this.extensionRegistryService = extensionRegistryService;
        this.bindings = scriptContext.getBindings(100);
    }

    public RuntimeObjectModel getObjectModel() {
        return OBJECT_MODEL;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public Object call(String functionName, Object ... arguments) {
        Map<String, RuntimeExtension> extensions = this.extensionRegistryService.extensions();
        RuntimeExtension extension = extensions.get(functionName);
        if (extension == null) {
            throw new SightlyException("Runtime extension is not available: " + functionName);
        }
        return extension.call((RenderContext)this, arguments);
    }
}

