/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.precompiled;

import javax.script.Bindings;
import javax.script.ScriptContext;
import org.apache.sling.scripting.bundle.tracker.BundledRenderUnit;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.render.RenderUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={})
public class PrecompiledUnitManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrecompiledUnitManager.class);
    private final ServiceRegistration<?> serviceRegistration;

    @Activate
    public PrecompiledUnitManager(BundleContext bundleContext) {
        this.serviceRegistration = this.register(bundleContext);
    }

    @Deactivate
    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    public SightlyCompiledScript evaluate(SightlyScriptEngine sightlyScriptEngine, ScriptContext scriptContext) {
        Object renderUnit;
        Bindings bindings = scriptContext.getBindings(100);
        Object bundledRenderUnit = bindings.get(BundledRenderUnit.VARIABLE);
        if (bundledRenderUnit instanceof BundledRenderUnit && (renderUnit = ((BundledRenderUnit)bundledRenderUnit).getUnit()) instanceof RenderUnit) {
            return new SightlyCompiledScript(sightlyScriptEngine, (RenderUnit)renderUnit);
        }
        return null;
    }

    public Object getBundledRenderUnitDependency(Bindings bindings, String identifier) {
        Object bru = bindings.get(BundledRenderUnit.VARIABLE);
        if (bru instanceof BundledRenderUnit) {
            BundledRenderUnit bundledRenderUnit = (BundledRenderUnit)bru;
            return bundledRenderUnit.getService(identifier);
        }
        return null;
    }

    private ServiceRegistration<?> register(BundleContext bundleContext) {
        try {
            PrecompiledUnitManager.class.getClassLoader().loadClass("org.apache.sling.scripting.bundle.tracker.BundledRenderUnit");
            return bundleContext.registerService(PrecompiledUnitManager.class, (Object)this, null);
        }
        catch (Throwable e) {
            LOGGER.info("No support for precompiled scripts.");
            return null;
        }
    }
}

