/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.compiled;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.scripting.api.ScriptNameAware;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.compiler.CompilerMessage;
import org.apache.sling.scripting.sightly.compiler.SightlyCompiler;
import org.apache.sling.scripting.sightly.compiler.backend.BackendCompiler;
import org.apache.sling.scripting.sightly.impl.engine.ResourceBackedPojoChangeMonitor;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SightlyCompilationUnit;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SlingJavaImportsAnalyser;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.impl.utils.Patterns;
import org.apache.sling.scripting.sightly.impl.utils.ScriptUtils;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.GlobalShadowCheckBackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.JavaClassBackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.JavaEscapeUtils;
import org.apache.sling.scripting.sightly.java.compiler.JavaImportsAnalyzer;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RenderUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingHTLMasterCompiler.class})
public class SlingHTLMasterCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingHTLMasterCompiler.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ClassLoaderWriter classLoaderWriter;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SightlyCompiler sightlyCompiler;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private JavaCompiler javaCompiler;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration;
    @Reference
    private ResourceBackedPojoChangeMonitor resourceBackedPojoChangeMonitor;
    private static final String NO_SCRIPT = "NO_SCRIPT";
    private static final Pattern MANGLED_CHAR_PATTERN = Pattern.compile("(.*)(__[0-9a-f]{4}__)(.*)");
    private static final char[] ambiguousSymbols = new char[]{'-', '_', '.'};
    static final String SIGHTLY_CONFIG_FILE = "/sightly.config";
    private final Map<String, Lock> compilationLocks = new HashMap<String, Lock>();
    private Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void activate() {
        LOGGER.info("Activating {}", (Object)this.getClass().getName());
        String version = System.getProperty("java.specification.version");
        this.options = new Options();
        this.options.put((Object)"generateDebugInfo", (Object)true);
        this.options.put((Object)"sourceVersion", (Object)version);
        this.options.put((Object)"targetVersion", (Object)version);
        this.options.put((Object)"classLoaderWriter", (Object)this.classLoaderWriter);
        this.options.put((Object)"forceCompilation", (Object)true);
        boolean newVersion = true;
        String versionInfo = null;
        String newVersionString = this.sightlyEngineConfiguration.getEngineVersion();
        try {
            InputStream is = this.classLoaderWriter.getInputStream(SIGHTLY_CONFIG_FILE);
            if (is != null) {
                versionInfo = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if (newVersionString.equals(versionInfo)) {
                    newVersion = false;
                } else {
                    LOGGER.info("Detected stale classes generated by Apache Sling Scripting HTL engine version {}.", (Object)versionInfo);
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newVersion) {
            OutputStream os = this.classLoaderWriter.getOutputStream(SIGHTLY_CONFIG_FILE);
            try {
                IOUtils.write((String)this.sightlyEngineConfiguration.getEngineVersion(), (OutputStream)os, (String)"UTF-8");
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
            String scratchFolder = this.sightlyEngineConfiguration.getScratchFolder();
            boolean scratchFolderDeleted = this.classLoaderWriter.delete(scratchFolder);
            if (scratchFolderDeleted && StringUtils.isNotEmpty((CharSequence)versionInfo)) {
                LOGGER.info("Deleted stale classes generated by Apache Sling Scripting HTL engine version {}.", (Object)versionInfo);
            }
        }
        this.sightlyCompiler = SightlyCompiler.withKnownExpressionOptions(this.sightlyEngineConfiguration.getAllowedExpressionOptions());
    }

    public Object getResourceBackedUseObject(RenderContext renderContext, String className) {
        LOGGER.debug("Attempting to load class {}.", (Object)className);
        try {
            if (className.contains(".")) {
                Resource pojoResource = this.getPOJOFromFQCN(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), className);
                if (pojoResource != null) {
                    return this.getUseObjectAndRecompileIfNeeded(pojoResource);
                }
            } else {
                Resource pojoResource = ScriptUtils.resolveScript(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), renderContext, className + ".java");
                if (pojoResource != null) {
                    return this.getUseObjectAndRecompileIfNeeded(pojoResource);
                }
            }
        }
        catch (Exception e) {
            throw new SightlyException("Cannot obtain an instance for class " + className + ".", (Throwable)e);
        }
        return null;
    }

    public SightlyCompiledScript compileHTLScript(SightlyScriptEngine engine, final Reader script, ScriptContext scriptContext) throws ScriptException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.dynamicClassLoaderManager.getDynamicClassLoader());
        try {
            org.apache.sling.scripting.sightly.compiler.CompilationResult result;
            String sName = NO_SCRIPT;
            if (script instanceof ScriptNameAware) {
                sName = ((ScriptNameAware)script).getScriptName();
            }
            if (sName.equals(NO_SCRIPT)) {
                sName = this.getScriptName(scriptContext);
            }
            final String scriptName = sName;
            org.apache.sling.scripting.sightly.compiler.CompilationUnit compilationUnit = new org.apache.sling.scripting.sightly.compiler.CompilationUnit(){

                public String getScriptName() {
                    return scriptName;
                }

                public Reader getScriptReader() {
                    return script;
                }
            };
            GlobalShadowCheckBackendCompiler shadowCheckBackendCompiler = null;
            SlingJavaImportsAnalyser importsAnalyser = new SlingJavaImportsAnalyser(this.scriptingResourceResolverProvider);
            JavaClassBackendCompiler javaClassBackendCompiler = new JavaClassBackendCompiler((JavaImportsAnalyzer)importsAnalyser);
            if (scriptContext != null) {
                Bindings bindings = scriptContext.getBindings(100);
                Set globals = bindings.keySet();
                shadowCheckBackendCompiler = new GlobalShadowCheckBackendCompiler((BackendCompiler)javaClassBackendCompiler, globals);
            }
            org.apache.sling.scripting.sightly.compiler.CompilationResult compilationResult = result = shadowCheckBackendCompiler == null ? this.sightlyCompiler.compile(compilationUnit, (BackendCompiler)javaClassBackendCompiler) : this.sightlyCompiler.compile(compilationUnit, shadowCheckBackendCompiler);
            if (result.getWarnings().size() > 0) {
                for (CompilerMessage warning : result.getWarnings()) {
                    LOGGER.warn("Script {} {}:{}: {}", new Object[]{warning.getScriptName(), warning.getLine(), warning.getColumn(), warning.getMessage()});
                }
            }
            if (result.getErrors().size() > 0) {
                CompilerMessage error = (CompilerMessage)result.getErrors().get(0);
                throw new ScriptException(error.getMessage(), error.getScriptName(), error.getLine(), error.getColumn());
            }
            SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, scriptName);
            String javaSourceCode = javaClassBackendCompiler.build((ClassInfo)sourceIdentifier);
            Object renderUnit = this.compileSource(sourceIdentifier, javaSourceCode);
            if (renderUnit instanceof RenderUnit) {
                SightlyCompiledScript sightlyCompiledScript = new SightlyCompiledScript(engine, (RenderUnit)renderUnit);
                return sightlyCompiledScript;
            }
            throw new SightlyException("Expected a RenderUnit.");
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderWriter.getClassLoader();
    }

    Resource getPOJOFromFQCN(ResourceResolver resolver, String fullyQualifiedClassName) {
        StringBuilder pathElements = new StringBuilder("/");
        String[] classElements = StringUtils.split((String)fullyQualifiedClassName, (char)'.');
        for (int i = 0; i < classElements.length; ++i) {
            String classElem = classElements[i];
            Matcher matcher = MANGLED_CHAR_PATTERN.matcher(classElem);
            if (matcher.matches()) {
                String group = matcher.group(2);
                char unmangled = JavaEscapeUtils.unmangle((String)group);
                classElem = classElem.replaceAll(group, Character.toString(unmangled));
                while (matcher.find()) {
                    group = matcher.group(2);
                    unmangled = JavaEscapeUtils.unmangle((String)group);
                    classElem = classElem.replaceAll(group, Character.toString(unmangled));
                }
            } else {
                int underscoreIndex = classElem.indexOf(95);
                if (underscoreIndex > -1) {
                    if (underscoreIndex == classElem.length() - 1) {
                        classElem = classElem.substring(0, classElem.length() - 1);
                    } else if (underscoreIndex == 0 && !Character.isJavaIdentifierStart(classElem.charAt(1))) {
                        classElem = classElem.substring(1);
                    }
                }
            }
            pathElements.append(classElem);
            if (i >= classElements.length - 1) continue;
            pathElements.append("/");
        }
        Set<String> possiblePOJOPaths = SlingHTLMasterCompiler.getPossiblePojoPaths(pathElements.toString() + ".java");
        for (String possiblePath : possiblePOJOPaths) {
            Resource r = resolver.getResource(possiblePath);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static Set<String> getPossiblePojoPaths(String originalPath) {
        LinkedHashSet<String> possiblePaths = new LinkedHashSet<String>();
        possiblePaths.add(originalPath);
        HashMap<Integer, Character> chars = new HashMap<Integer, Character>();
        for (char symbol : ambiguousSymbols) {
            String pathCopy = originalPath.substring(0, originalPath.lastIndexOf("/"));
            int actualIndex = 0;
            boolean firstPass = true;
            while (pathCopy.indexOf(symbol) != -1) {
                int pos = pathCopy.indexOf(symbol);
                actualIndex += pos;
                if (!firstPass) {
                    ++actualIndex;
                }
                chars.put(actualIndex, Character.valueOf(symbol));
                pathCopy = pathCopy.substring(pos + 1);
                firstPass = false;
            }
        }
        if (chars.size() > 0) {
            ArrayList<char[]> possibleArrangements = new ArrayList<char[]>();
            SlingHTLMasterCompiler.populateArray(possibleArrangements, new char[chars.size()], 0);
            Integer[] indexes = chars.keySet().toArray(new Integer[0]);
            for (char[] arrangement : possibleArrangements) {
                char[] possiblePath = originalPath.toCharArray();
                for (int i = 0; i < arrangement.length; ++i) {
                    char currentSymbol = arrangement[i];
                    int currentIndex = indexes[i];
                    possiblePath[currentIndex] = currentSymbol;
                }
                possiblePaths.add(new String(possiblePath));
            }
        }
        return possiblePaths;
    }

    private static void populateArray(ArrayList<char[]> arrayCollection, char[] symbolsArrangementArray, int index) {
        if (symbolsArrangementArray.length > 0) {
            if (index == symbolsArrangementArray.length) {
                arrayCollection.add((char[])symbolsArrangementArray.clone());
            } else {
                char[] cArray = ambiguousSymbols;
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    char symbol;
                    symbolsArrangementArray[index] = symbol = cArray[i];
                    SlingHTLMasterCompiler.populateArray(arrayCollection, symbolsArrangementArray, index + 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compileSource(SourceIdentifier sourceIdentifier, String sourceCode) {
        Lock lock;
        String fqcn = sourceIdentifier.getFullyQualifiedClassName();
        Map<String, Lock> map = this.compilationLocks;
        synchronized (map) {
            lock = this.compilationLocks.get(fqcn);
            if (lock == null) {
                lock = new ReentrantLock();
                this.compilationLocks.put(fqcn, lock);
            }
        }
        lock.lock();
        try {
            if (this.sightlyEngineConfiguration.keepGenerated()) {
                String path = "/" + fqcn.replaceAll("\\.", "/") + ".java";
                OutputStream os = this.classLoaderWriter.getOutputStream(path);
                IOUtils.write((String)sourceCode, (OutputStream)os, (String)"UTF-8");
                IOUtils.closeQuietly((OutputStream)os);
            }
            String[] sourceCodeLines = sourceCode.split("\\r\\n|[\\n\\x0B\\x0C\\r\\u0085\\u2028\\u2029]");
            boolean foundPackageDeclaration = false;
            for (String line : sourceCodeLines) {
                Matcher matcher = Patterns.JAVA_PACKAGE_DECLARATION.matcher(line);
                if (!matcher.matches()) continue;
                foundPackageDeclaration = true;
                break;
            }
            if (!foundPackageDeclaration) {
                sourceCode = "package " + sourceIdentifier.getPackageName() + ";\n" + sourceCode;
            }
            SightlyCompilationUnit compilationUnit = new SightlyCompilationUnit(sourceCode, fqcn);
            long start = System.currentTimeMillis();
            CompilationResult compilationResult = this.javaCompiler.compile(new CompilationUnit[]{compilationUnit}, this.options);
            long end = System.currentTimeMillis();
            List errors = compilationResult.getErrors();
            if (errors != null && errors.size() > 0) {
                throw new SightlyException(this.createErrorMsg(errors));
            }
            if (compilationResult.didCompile()) {
                LOGGER.debug("Class {} was compiled in {}ms.", (Object)fqcn, (Object)(end - start));
            }
            Object obj = this.classLoaderWriter.getClassLoader().loadClass(fqcn).newInstance();
            return obj;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SightlyException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private Object getUseObjectAndRecompileIfNeeded(Resource pojoResource) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, pojoResource.getPath());
        long sourceLastModifiedDateFromCache = this.resourceBackedPojoChangeMonitor.getLastModifiedDateForJavaUseObject(pojoResource.getPath());
        long classLastModifiedDate = this.classLoaderWriter.getLastModified("/" + sourceIdentifier.getFullyQualifiedClassName().replaceAll("\\.", "/") + ".class");
        if (sourceLastModifiedDateFromCache == 0L) {
            long sourceLastModifiedDate = pojoResource.getResourceMetadata().getModificationTime();
            this.resourceBackedPojoChangeMonitor.recordLastModifiedTimestamp(pojoResource.getPath(), sourceLastModifiedDate);
            if (classLastModifiedDate < 0L || sourceLastModifiedDate > classLastModifiedDate) {
                return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (String)"UTF-8"));
            }
            return this.classLoaderWriter.getClassLoader().loadClass(sourceIdentifier.getFullyQualifiedClassName()).newInstance();
        }
        if (sourceLastModifiedDateFromCache > classLastModifiedDate) {
            return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (String)"UTF-8"));
        }
        return this.classLoaderWriter.getClassLoader().loadClass(sourceIdentifier.getFullyQualifiedClassName()).newInstance();
    }

    private String createErrorMsg(List<org.apache.sling.commons.compiler.CompilerMessage> errors) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Compilation errors in ");
        buffer.append(errors.get(0).getFile());
        buffer.append(":");
        StringBuilder errorsBuffer = new StringBuilder();
        boolean duplicateVariable = false;
        for (org.apache.sling.commons.compiler.CompilerMessage e : errors) {
            if (!duplicateVariable && e.getMessage().contains("Duplicate local variable")) {
                duplicateVariable = true;
                buffer.append(" Maybe you defined more than one identical block elements without defining a different variable for each one?");
            }
            errorsBuffer.append("\nLine ");
            errorsBuffer.append(e.getLine());
            errorsBuffer.append(", column ");
            errorsBuffer.append(e.getColumn());
            errorsBuffer.append(" : ");
            errorsBuffer.append(e.getMessage());
        }
        buffer.append((CharSequence)errorsBuffer);
        return buffer.toString();
    }

    private String getScriptName(ScriptContext scriptContext) {
        if (scriptContext != null) {
            Bindings bindings = scriptContext.getBindings(100);
            String scriptName = (String)bindings.get("javax.script.filename");
            if (scriptName != null && !"".equals(scriptName)) {
                return scriptName;
            }
            SlingScriptHelper sling = BindingsUtils.getHelper(bindings);
            if (sling != null) {
                return sling.getScript().getScriptResource().getPath();
            }
        }
        return NO_SCRIPT;
    }
}

