/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.Reader;
import java.io.StringReader;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.ExtensionRegistryService;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngineFactory;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SlingHTLMasterCompiler;
import org.apache.sling.scripting.sightly.impl.engine.precompiled.PrecompiledUnitManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SightlyScriptEngine
extends AbstractSlingScriptEngine
implements Compilable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SightlyScriptEngine.class);
    private SlingHTLMasterCompiler slingHTLMasterCompiler;
    private PrecompiledUnitManager precompiledUnitManager;
    private ExtensionRegistryService extensionRegistryService;

    SightlyScriptEngine(SightlyScriptEngineFactory factory, ExtensionRegistryService extensionRegistryService, SlingHTLMasterCompiler slingHTLMasterCompiler, PrecompiledUnitManager precompiledUnitManager) {
        super((ScriptEngineFactory)((Object)factory));
        this.extensionRegistryService = extensionRegistryService;
        this.slingHTLMasterCompiler = slingHTLMasterCompiler;
        this.precompiledUnitManager = precompiledUnitManager;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        if (this.slingHTLMasterCompiler != null) {
            return this.slingHTLMasterCompiler.compileHTLScript(this, script, null);
        }
        throw new ScriptException("Missing compilation support.");
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        this.checkArguments(reader, scriptContext);
        try {
            SightlyCompiledScript compiledScript = null;
            if (this.precompiledUnitManager != null) {
                compiledScript = this.precompiledUnitManager.evaluate(this, scriptContext);
            } else if (this.slingHTLMasterCompiler != null) {
                compiledScript = this.slingHTLMasterCompiler.compileHTLScript(this, reader, scriptContext);
            }
            if (compiledScript != null) {
                return compiledScript.eval(scriptContext);
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        LOGGER.warn("Did not find a compilable or executable unit.");
        return null;
    }

    public ExtensionRegistryService getExtensionRegistryService() {
        return this.extensionRegistryService;
    }

    private void checkArguments(Reader reader, ScriptContext scriptContext) {
        if (reader == null) {
            throw new NullPointerException("Reader cannot be null");
        }
        if (scriptContext == null) {
            throw new NullPointerException("ScriptContext cannot be null");
        }
    }
}

