/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.api.ScriptNameAware;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.compiler.CompilationResult;
import org.apache.sling.scripting.sightly.compiler.CompilationUnit;
import org.apache.sling.scripting.sightly.compiler.CompilerMessage;
import org.apache.sling.scripting.sightly.compiler.SightlyCompiler;
import org.apache.sling.scripting.sightly.compiler.backend.BackendCompiler;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.SightlyJavaCompilerService;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngineFactory;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.GlobalShadowCheckBackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.JavaClassBackendCompiler;
import org.apache.sling.scripting.sightly.java.compiler.JavaEscapeUtils;
import org.apache.sling.scripting.sightly.java.compiler.JavaImportsAnalyzer;
import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SightlyScriptEngine
extends AbstractSlingScriptEngine
implements Compilable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SightlyScriptEngine.class);
    public static final String NO_SCRIPT = "NO_SCRIPT";
    private SightlyCompiler sightlyCompiler;
    private SightlyJavaCompilerService javaCompilerService;
    private final SightlyEngineConfiguration configuration;
    private final ScriptingResourceResolverProvider scriptingResourceResolverProvider;
    private final SlingJavaImportsAnalyser importsAnalyser;

    public SightlyScriptEngine(ScriptEngineFactory scriptEngineFactory, SightlyCompiler sightlyCompiler, SightlyJavaCompilerService javaCompilerService, SightlyEngineConfiguration configuration, ScriptingResourceResolverProvider scriptingResourceResolverProvider) {
        super(scriptEngineFactory);
        this.sightlyCompiler = sightlyCompiler;
        this.javaCompilerService = javaCompilerService;
        this.configuration = configuration;
        this.scriptingResourceResolverProvider = scriptingResourceResolverProvider;
        this.importsAnalyser = new SlingJavaImportsAnalyser();
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        return this.internalCompile(script, null);
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        this.checkArguments(reader, scriptContext);
        try {
            SightlyCompiledScript compiledScript = this.internalCompile(reader, scriptContext);
            return compiledScript.eval(scriptContext);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    private SightlyCompiledScript internalCompile(final Reader script, ScriptContext scriptContext) throws ScriptException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((SightlyScriptEngineFactory)((Object)this.getFactory())).getClassLoader());
        try {
            CompilationResult result;
            String sName = NO_SCRIPT;
            if (script instanceof ScriptNameAware) {
                sName = ((ScriptNameAware)script).getScriptName();
            }
            if (sName.equals(NO_SCRIPT)) {
                sName = this.getScriptName(scriptContext);
            }
            final String scriptName = sName;
            CompilationUnit compilationUnit = new CompilationUnit(){

                public String getScriptName() {
                    return scriptName;
                }

                public Reader getScriptReader() {
                    return script;
                }
            };
            JavaClassBackendCompiler javaClassBackendCompiler = new JavaClassBackendCompiler((JavaImportsAnalyzer)this.importsAnalyser);
            GlobalShadowCheckBackendCompiler shadowCheckBackendCompiler = null;
            if (scriptContext != null) {
                Bindings bindings = scriptContext.getBindings(100);
                Set globals = bindings.keySet();
                shadowCheckBackendCompiler = new GlobalShadowCheckBackendCompiler((BackendCompiler)javaClassBackendCompiler, globals);
            }
            CompilationResult compilationResult = result = shadowCheckBackendCompiler == null ? this.sightlyCompiler.compile(compilationUnit, (BackendCompiler)javaClassBackendCompiler) : this.sightlyCompiler.compile(compilationUnit, shadowCheckBackendCompiler);
            if (result.getWarnings().size() > 0) {
                for (CompilerMessage warning : result.getWarnings()) {
                    LOGGER.warn("Script {} {}:{}: {}", new Object[]{warning.getScriptName(), warning.getLine(), warning.getColumn(), warning.getMessage()});
                }
            }
            if (result.getErrors().size() > 0) {
                CompilerMessage error = (CompilerMessage)result.getErrors().get(0);
                throw new ScriptException(error.getMessage(), error.getScriptName(), error.getLine(), error.getColumn());
            }
            SourceIdentifier sourceIdentifier = new SourceIdentifier(this.configuration, scriptName);
            String javaSourceCode = javaClassBackendCompiler.build((ClassInfo)sourceIdentifier);
            Object renderUnit = this.javaCompilerService.compileSource(sourceIdentifier, javaSourceCode);
            if (renderUnit instanceof RenderUnit) {
                SightlyCompiledScript sightlyCompiledScript = new SightlyCompiledScript((ScriptEngine)((Object)this), (RenderUnit)renderUnit);
                return sightlyCompiledScript;
            }
            throw new SightlyException("Expected a RenderUnit.");
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void checkArguments(Reader reader, ScriptContext scriptContext) {
        if (reader == null) {
            throw new NullPointerException("Reader cannot be null");
        }
        if (scriptContext == null) {
            throw new NullPointerException("ScriptContext cannot be null");
        }
    }

    private String getScriptName(ScriptContext scriptContext) {
        if (scriptContext != null) {
            Bindings bindings = scriptContext.getBindings(100);
            String scriptName = (String)bindings.get("javax.script.filename");
            if (scriptName != null && !"".equals(scriptName)) {
                return scriptName;
            }
            SlingScriptHelper sling = BindingsUtils.getHelper(bindings);
            if (sling != null) {
                return sling.getScript().getScriptResource().getPath();
            }
        }
        return NO_SCRIPT;
    }

    class SlingJavaImportsAnalyser
    implements JavaImportsAnalyzer {
        SlingJavaImportsAnalyser() {
        }

        public boolean allowImport(String importedClass) {
            for (String searchPath : SightlyScriptEngine.this.scriptingResourceResolverProvider.getRequestScopedResourceResolver().getSearchPath()) {
                String subPackage = JavaEscapeUtils.makeJavaPackage((String)searchPath);
                if (!importedClass.startsWith(subPackage)) continue;
                return false;
            }
            return true;
        }
    }
}

