/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.CompilerMessage;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.engine.ResourceBackedPojoChangeMonitor;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.utils.Patterns;
import org.apache.sling.scripting.sightly.impl.utils.ScriptUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SightlyJavaCompilerService.class})
public class SightlyJavaCompilerService {
    private static final Logger LOG = LoggerFactory.getLogger(SightlyJavaCompilerService.class);
    @Reference
    private ClassLoaderWriter classLoaderWriter = null;
    @Reference
    private JavaCompiler javaCompiler = null;
    @Reference
    private ResourceBackedPojoChangeMonitor resourceBackedPojoChangeMonitor = null;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider = null;
    private Map<String, Lock> compilationLocks = new HashMap<String, Lock>();
    private Options options;

    public Object getResourceBackedUseObject(RenderContext renderContext, String className) {
        LOG.debug("Attempting to load class {}.", (Object)className);
        try {
            if (className.contains(".")) {
                Resource pojoResource = SourceIdentifier.getPOJOFromFQCN(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), null, className);
                if (pojoResource != null) {
                    return this.getUseObjectAndRecompileIfNeeded(pojoResource);
                }
            } else {
                Resource pojoResource = ScriptUtils.resolveScript(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), renderContext, className + ".java");
                if (pojoResource != null) {
                    return this.getUseObjectAndRecompileIfNeeded(pojoResource);
                }
            }
        }
        catch (Exception e) {
            throw new SightlyException("Cannot obtain an instance for class " + className + ".", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object compileSource(SourceIdentifier sourceIdentifier, String sourceCode) {
        Lock lock;
        String fqcn = sourceIdentifier.getFullyQualifiedClassName();
        Map<String, Lock> map = this.compilationLocks;
        synchronized (map) {
            lock = this.compilationLocks.get(fqcn);
            if (lock == null) {
                lock = new ReentrantLock();
                this.compilationLocks.put(fqcn, lock);
            }
        }
        lock.lock();
        try {
            if (this.sightlyEngineConfiguration.keepGenerated()) {
                String path = "/" + fqcn.replaceAll("\\.", "/") + ".java";
                OutputStream os = this.classLoaderWriter.getOutputStream(path);
                IOUtils.write((String)sourceCode, (OutputStream)os, (String)"UTF-8");
                IOUtils.closeQuietly((OutputStream)os);
            }
            String[] sourceCodeLines = sourceCode.split("\\r\\n|[\\n\\x0B\\x0C\\r\\u0085\\u2028\\u2029]");
            boolean foundPackageDeclaration = false;
            for (String line : sourceCodeLines) {
                Matcher matcher = Patterns.JAVA_PACKAGE_DECLARATION.matcher(line);
                if (!matcher.matches()) continue;
                foundPackageDeclaration = true;
                break;
            }
            if (!foundPackageDeclaration) {
                sourceCode = "package " + sourceIdentifier.getPackageName() + ";\n" + sourceCode;
            }
            SightlyCompilationUnit compilationUnit = new SightlyCompilationUnit(sourceCode, fqcn);
            long start = System.currentTimeMillis();
            CompilationResult compilationResult = this.javaCompiler.compile(new CompilationUnit[]{compilationUnit}, this.options);
            long end = System.currentTimeMillis();
            List errors = compilationResult.getErrors();
            if (errors != null && errors.size() > 0) {
                throw new SightlyException(this.createErrorMsg(errors));
            }
            if (compilationResult.didCompile()) {
                LOG.debug("Class {} was compiled in {}ms.", (Object)fqcn, (Object)(end - start));
            }
            Object obj = this.classLoaderWriter.getClassLoader().loadClass(fqcn).newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new SightlyException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private Object getUseObjectAndRecompileIfNeeded(Resource pojoResource) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, pojoResource.getPath());
        long sourceLastModifiedDateFromCache = this.resourceBackedPojoChangeMonitor.getLastModifiedDateForJavaUseObject(pojoResource.getPath());
        long classLastModifiedDate = this.classLoaderWriter.getLastModified("/" + sourceIdentifier.getFullyQualifiedClassName().replaceAll("\\.", "/") + ".class");
        if (sourceLastModifiedDateFromCache == 0L) {
            long sourceLastModifiedDate = pojoResource.getResourceMetadata().getModificationTime();
            this.resourceBackedPojoChangeMonitor.recordLastModifiedTimestamp(pojoResource.getPath(), sourceLastModifiedDate);
            if (classLastModifiedDate < 0L || sourceLastModifiedDate > classLastModifiedDate) {
                return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (String)"UTF-8"));
            }
            return this.classLoaderWriter.getClassLoader().loadClass(sourceIdentifier.getFullyQualifiedClassName()).newInstance();
        }
        if (sourceLastModifiedDateFromCache > classLastModifiedDate) {
            return this.compileSource(sourceIdentifier, IOUtils.toString((InputStream)((InputStream)pojoResource.adaptTo(InputStream.class)), (String)"UTF-8"));
        }
        return this.classLoaderWriter.getClassLoader().loadClass(sourceIdentifier.getFullyQualifiedClassName()).newInstance();
    }

    @Activate
    protected void activate() {
        LOG.info("Activating {}", (Object)this.getClass().getName());
        String version = System.getProperty("java.specification.version");
        this.options = new Options();
        this.options.put((Object)"generateDebugInfo", (Object)true);
        this.options.put((Object)"sourceVersion", (Object)version);
        this.options.put((Object)"targetVersion", (Object)version);
        this.options.put((Object)"classLoaderWriter", (Object)this.classLoaderWriter);
        this.options.put((Object)"forceCompilation", (Object)true);
    }

    private String createErrorMsg(List<CompilerMessage> errors) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Compilation errors in ");
        buffer.append(errors.get(0).getFile());
        buffer.append(":");
        StringBuilder errorsBuffer = new StringBuilder();
        boolean duplicateVariable = false;
        for (CompilerMessage e : errors) {
            if (!duplicateVariable && e.getMessage().contains("Duplicate local variable")) {
                duplicateVariable = true;
                buffer.append(" Maybe you defined more than one identical block elements without defining a different variable for each one?");
            }
            errorsBuffer.append("\nLine ");
            errorsBuffer.append(e.getLine());
            errorsBuffer.append(", column ");
            errorsBuffer.append(e.getColumn());
            errorsBuffer.append(" : ");
            errorsBuffer.append(e.getMessage());
        }
        buffer.append((CharSequence)errorsBuffer);
        return buffer.toString();
    }

    private static class SightlyCompilationUnit
    implements CompilationUnit {
        private String fqcn;
        private String sourceCode;

        SightlyCompilationUnit(String sourceCode, String fqcn) throws Exception {
            this.sourceCode = sourceCode;
            this.fqcn = fqcn;
        }

        public Reader getSource() throws IOException {
            return new InputStreamReader(IOUtils.toInputStream((String)this.sourceCode, (String)"UTF-8"), "UTF-8");
        }

        public String getMainClassName() {
            return this.fqcn;
        }

        public long getLastModified() {
            return System.currentTimeMillis();
        }
    }
}

