/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.scripting.sightly.SightlyException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceBackedPojoChangeMonitor.class, ResourceChangeListener.class}, property={"resource.paths=glob:**/*.java", "resource.change.types=CHANGED", "resource.change.types=REMOVED"})
public class ResourceBackedPojoChangeMonitor
implements ResourceChangeListener,
ExternalResourceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBackedPojoChangeMonitor.class);
    private Map<String, Long> slyJavaUseMap = new ConcurrentHashMap<String, Long>();

    public void recordLastModifiedTimestamp(String path, long timestamp) {
        if (path == null) {
            throw new SightlyException("Path value cannot be null.");
        }
        this.slyJavaUseMap.put(path, timestamp);
    }

    public long getLastModifiedDateForJavaUseObject(String path) {
        if (path == null) {
            return 0L;
        }
        Long date = this.slyJavaUseMap.get(path);
        return date != null ? date : 0L;
    }

    public void onChange(@Nonnull List<ResourceChange> changes) {
        for (ResourceChange change : changes) {
            String path = change.getPath();
            ResourceChange.ChangeType changeType = change.getType();
            switch (changeType) {
                case CHANGED: {
                    if (!this.slyJavaUseMap.containsKey(path)) break;
                    this.slyJavaUseMap.put(path, System.currentTimeMillis());
                    break;
                }
                case REMOVED: {
                    if (!this.slyJavaUseMap.containsKey(path)) break;
                    this.slyJavaUseMap.remove(path);
                    break;
                }
            }
            LOG.debug("Java Use Object {} was {}.", (Object)path, (Object)changeType.toString());
        }
    }
}

