/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sling.scripting.jsp.taglib;

import javax.servlet.jsp.tagext.TagSupport;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;

/**
 * Abstract class for Tags for interactiving with Context-Aware Configuration
 * resources to extend.
 */
public abstract class AbstractCATag extends TagSupport {

    /** Serialization UID */
    private static final long serialVersionUID = -3083138119694952836L;

    /** The bucket. */
    private String bucket;

    /** The name. */
    private String name;

    /** The resource for which to get the configuration. */
    private transient Resource resource;

    /** The var. */
    private String var;

    /**
     * @return the bucket
     */
    public String getBucket() {
        return bucket;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @return the resource
     */
    public Resource getResource() {
        return resource;
    }

    /**
     * Method for retrieving the ConfigurationResourceResolver from the page
     * context.
     * 
     * @return the resource resolver
     */
    protected ConfigurationResourceResolver getConfigurationResourceResolver() {
        final SlingBindings bindings = (SlingBindings) pageContext.getRequest()
                .getAttribute(SlingBindings.class.getName());
        final SlingScriptHelper scriptHelper = bindings.getSling();
        return scriptHelper.getService(ConfigurationResourceResolver.class);
    }

    /**
     * Gets the variable name to which to save the list of children.
     * 
     * @return the variable name
     */
    public String getVar() {
        return var;
    }

    /**
     * @param bucket the bucket to set
     */
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @param resource the resource to set
     */
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    /**
     * Sets the variable name to which to save the list of children.
     * 
     * @param var the variable name
     */
    public void setVar(String var) {
        this.var = var;
    }
}
