/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.util.Arrays;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParentTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(GetParentTag.class);
    private static final long serialVersionUID = -3419869755342010983L;
    private Resource resource;
    private String level;
    private String var;

    public int doEndTag() {
        log.trace("doEndTag");
        Resource parent = null;
        if (this.level != null) {
            String[] segments = this.resource.getPath().split("\\/");
            int end = Integer.parseInt(this.level, 10);
            String parentPath = "/" + StringUtils.join((Object[])Arrays.copyOfRange(segments, 1, end + 1), (String)"/");
            log.debug("Retrieving {} parent resource at path {}", (Object)this.level, (Object)parentPath);
            parent = this.resource.getResourceResolver().getResource(parentPath);
        } else {
            log.debug("Retrieving parent resource");
            parent = this.resource.getParent();
        }
        log.debug("Saving {} to variable {}", (Object)parent, (Object)this.var);
        this.pageContext.setAttribute(this.var, (Object)parent);
        return 6;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getLevel() {
        return this.level;
    }

    public String getVar() {
        return this.var;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

