/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.util.Iterator;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindResourcesTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(FindResourcesTag.class);
    private static final long serialVersionUID = 8717969268407440925L;
    private String query;
    private String language;
    private String var;

    public int doEndTag() {
        log.trace("doEndTag");
        log.debug("Finding resources using query: {} of language {}", (Object)this.query, (Object)this.language);
        ResourceResolver resolver = this.getResourceResolver();
        Iterator resources = resolver.findResources(this.query, this.language);
        log.debug("Saving resources to variable {}", (Object)this.var);
        this.pageContext.setAttribute(this.var, (Object)resources);
        return 6;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getQuery() {
        return this.query;
    }

    protected ResourceResolver getResourceResolver() {
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        ResourceResolver resolver = scriptHelper.getRequest().getResourceResolver();
        return resolver;
    }

    public String getVar() {
        return this.var;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

