/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.java.impl.CompilerOptions;
import org.apache.sling.scripting.java.impl.JavaServletConfig;
import org.apache.sling.scripting.java.impl.JavaServletContext;
import org.apache.sling.scripting.java.impl.ServletWrapper;
import org.apache.sling.scripting.java.impl.SlingIOProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptEngineFactory.class, ResourceChangeListener.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Java Servlet Script Handler", "resource.change.types=CHANGED", "resource.change.types=REMOVED", "resource.paths=glob:**/*.java"})
@Designate(ocd=Config.class)
public class JavaScriptEngineFactory
extends AbstractScriptEngineFactory
implements ResourceChangeListener,
ExternalResourceChangeListener {
    public static final String DESCRIPTION = "Java Servlet Script Handler";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String VERSION_AUTO = "auto";
    @Reference
    private JavaCompiler javaCompiler;
    @Reference(target="(name=org.apache.sling)")
    private ServletContext slingServletContext;
    private SlingIOProvider ioProvider;
    private JavaServletContext javaServletContext;
    private ServletConfig servletConfig;
    public static final String SCRIPT_TYPE = "java";

    public JavaScriptEngineFactory() {
        this.setExtensions(new String[]{SCRIPT_TYPE});
    }

    public ScriptEngine getScriptEngine() {
        return new JavaScriptEngine(this);
    }

    public String getLanguageName() {
        return "Java Servlet Compiler";
    }

    public String getLanguageVersion() {
        return "1.5";
    }

    public Object getParameter(String name) {
        if ("THREADING".equals(name)) {
            return "STATELESS";
        }
        return super.getParameter(name);
    }

    @Activate
    protected void activate(Config config, Map<String, Object> props) {
        CompilerOptions opts = CompilerOptions.createOptions(config);
        this.ioProvider = new SlingIOProvider(this.javaCompiler, opts);
        this.javaServletContext = new JavaServletContext(this.ioProvider, this.slingServletContext);
        this.servletConfig = new JavaServletConfig(this.javaServletContext, props);
        this.logger.info("Activating Apache Sling Script Engine for Java with options {}", (Object)opts);
    }

    @Deactivate
    protected void deactivate() {
        if (this.ioProvider != null) {
            this.ioProvider.destroy();
            this.ioProvider = null;
        }
        this.javaServletContext = null;
        this.servletConfig = null;
        this.logger.info("Deactivating Apache Sling Script Engine for Java");
    }

    private void callServlet(Bindings bindings, SlingScriptHelper scriptHelper, ScriptContext context) {
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        ResourceResolver resolver = (ResourceResolver)context.getAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", -314);
        if (resolver == null) {
            resolver = scriptHelper.getScript().getScriptResource().getResourceResolver();
        }
        this.ioProvider.setRequestResourceResolver(resolver);
        SlingHttpServletRequest request = slingBindings.getRequest();
        Object oldValue = request.getAttribute(SlingBindings.class.getName());
        try {
            ServletWrapper servlet = this.getWrapperAdapter(scriptHelper);
            request.setAttribute(SlingBindings.class.getName(), (Object)slingBindings);
            servlet.service((HttpServletRequest)request, (HttpServletResponse)slingBindings.getResponse());
        }
        catch (SlingException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SlingIOException(ioe);
        }
        catch (ServletException se) {
            throw new SlingServletException(se);
        }
        catch (Exception ex) {
            throw new SlingException(null, (Throwable)ex);
        }
        finally {
            request.setAttribute(SlingBindings.class.getName(), oldValue);
            this.ioProvider.resetRequestResourceResolver();
        }
    }

    private ServletWrapper getWrapperAdapter(SlingScriptHelper scriptHelper) throws SlingException {
        SlingScript script = scriptHelper.getScript();
        String scriptName = script.getScriptResource().getPath();
        ServletWrapper wrapper = this.ioProvider.getServletCache().getWrapper(scriptName);
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = new ServletWrapper(this.servletConfig, this.ioProvider, scriptName, scriptHelper);
        wrapper = this.ioProvider.getServletCache().addWrapper(scriptName, wrapper);
        return wrapper;
    }

    public void onChange(List<ResourceChange> resourceChange) {
        for (ResourceChange change : resourceChange) {
            ResourceChange.ChangeType topic = change.getType();
            if (topic.equals((Object)ResourceChange.ChangeType.CHANGED)) {
                this.handleModification(change.getPath(), false);
                continue;
            }
            if (!topic.equals((Object)ResourceChange.ChangeType.REMOVED)) continue;
            this.handleModification(change.getPath(), true);
        }
    }

    private void handleModification(String scriptName, boolean remove) {
        this.ioProvider.getServletCache().removeWrapper(scriptName, remove);
    }

    private static class JavaScriptEngine
    extends AbstractSlingScriptEngine {
        JavaScriptEngine(JavaScriptEngineFactory factory) {
            super((ScriptEngineFactory)((Object)factory));
        }

        public Object eval(Reader script, ScriptContext context) throws ScriptException {
            Bindings props = context.getBindings(100);
            SlingScriptHelper scriptHelper = (SlingScriptHelper)props.get("sling");
            if (scriptHelper != null) {
                ((JavaScriptEngineFactory)((Object)this.getFactory())).callServlet(props, scriptHelper, context);
            }
            return null;
        }
    }

    @ObjectClassDefinition(name="Apache Sling Java Script Handler", description="The Java Script Handler supports development of Java Servlets to render response content. ")
    public static @interface Config {
        @AttributeDefinition(name="Generate Debug Info", description="Should the class file be compiled with debugging information? true or false, default true.")
        public boolean java_classdebuginfo() default true;

        @AttributeDefinition(name="Source Encoding", description="")
        public String java_javaEncoding() default "UTF-8";

        @AttributeDefinition(name="Source VM", description="Java Specification to be used to read the source files. If left empty or the value \"auto\" is specified, the current vm version will be used.")
        public String java_compilerSourceVM() default "auto";

        @AttributeDefinition(name="Target VM", description="Target Java version for compilation. If left empty or the value \"auto\" is specified, the current vm version will be used.")
        public String java_compilerTargetVM() default "auto";
    }
}

