/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.groovy.internal;

import groovy.text.GStringTemplateEngine;
import groovy.text.TemplateEngine;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.groovy.internal.GspScriptEngine;
import org.apache.sling.scripting.groovy.internal.GspScriptEngineFactoryConfiguration;
import org.codehaus.groovy.util.ReleaseInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptEngineFactory.class}, property={"service.description=Apache Sling Scripting Groovy GSP ScriptEngineFactory", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=GspScriptEngineFactoryConfiguration.class)
public class GspScriptEngineFactory
extends AbstractScriptEngineFactory {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile DynamicClassLoaderManager dynamicClassLoaderManager;
    private GspScriptEngineFactoryConfiguration configuration;
    private BundleContext bundleContext;
    private TemplateEngine templateEngine;
    private ServiceRegistration<TemplateEngine> serviceRegistration;
    private final Logger logger = LoggerFactory.getLogger(GspScriptEngineFactory.class);

    @Activate
    private void activate(GspScriptEngineFactoryConfiguration configuration, BundleContext bundleContext) {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.bundleContext = bundleContext;
        this.configure(configuration);
        this.templateEngine = new GStringTemplateEngine(this.dynamicClassLoaderManager.getDynamicClassLoader());
        this.registerTemplateEngine();
    }

    @Modified
    private void modified(GspScriptEngineFactoryConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.unregisterTemplateEngine();
        this.templateEngine = null;
        this.bundleContext = null;
    }

    private void configure(GspScriptEngineFactoryConfiguration configuration) {
        this.setExtensions(configuration.extensions());
        this.setMimeTypes(configuration.mimeTypes());
        this.setNames(configuration.names());
    }

    public String getLanguageName() {
        return "Groovy Server Pages";
    }

    public String getLanguageVersion() {
        return ReleaseInfo.getVersion();
    }

    public ScriptEngine getScriptEngine() {
        return new GspScriptEngine(this);
    }

    private void registerTemplateEngine() {
        if (this.templateEngine == null) {
            return;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.description", "Groovy's GStringTemplateEngine");
        ((Dictionary)properties).put("service.vendor", "The Apache Software Foundation");
        this.logger.info("registering {} as service {} with properties {}", new Object[]{this.templateEngine, TemplateEngine.class.getName(), properties});
        this.serviceRegistration = this.bundleContext.registerService(TemplateEngine.class, (Object)this.templateEngine, properties);
    }

    private void unregisterTemplateEngine() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }
}

