/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.groovy.scripting.internal;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;

public class GSPScriptEngine
extends AbstractSlingScriptEngine {
    private TemplateEngine templateEngine;

    public GSPScriptEngine(ScriptEngineFactory scriptEngineFactory, ClassLoader classLoader) {
        super(scriptEngineFactory);
        this.templateEngine = new GStringTemplateEngine(classLoader);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        Template template = null;
        try {
            template = this.templateEngine.createTemplate(reader);
        }
        catch (IOException e) {
            throw new ScriptException("Unable to compile GSP script: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ScriptException("Unable to compile GSP script: " + e.getMessage());
        }
        Bindings bindings = ctx.getBindings(100);
        Writable result = template.make((Map)bindings);
        try {
            result.writeTo(ctx.getWriter());
        }
        catch (IOException e) {
            throw new ScriptException("Unable to write result of script execution: " + e.getMessage());
        }
        return null;
    }
}

