/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.impl.ScriptCacheImplConfiguration;
import org.apache.sling.scripting.core.impl.jsr223.SlingScriptEngineManager;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventHandler.class}, property={"event.topics=org/apache/sling/scripting/core/impl/jsr223/SlingScriptEngineManager/*"}, configurationPid={"org.apache.sling.scripting.core.impl.ScriptCacheImpl"})
public class ScriptCacheInvalidator
implements ResourceChangeListener,
ExternalResourceChangeListener,
EventHandler {
    private final Logger logger = LoggerFactory.getLogger(ScriptCacheInvalidator.class);
    private final BundleContext bundleContext;
    private final Set<String> extensions = new TreeSet<String>();
    private final String[] additionalExtensions;
    private volatile ServiceRegistration<ResourceChangeListener> resourceChangeListener;
    private final SlingScriptEngineManager slingScriptEngineManager;
    private final ExecutorService threadPool;
    private final ScriptCache scriptCache;

    @Activate
    public ScriptCacheInvalidator(@Reference SlingScriptEngineManager slingScriptEngineManager, @Reference ScriptCache scriptCache, ScriptCacheImplConfiguration configuration, BundleContext bundleCtx) {
        this.slingScriptEngineManager = slingScriptEngineManager;
        this.scriptCache = scriptCache;
        this.threadPool = Executors.newSingleThreadExecutor();
        this.bundleContext = bundleCtx;
        this.additionalExtensions = configuration.org_apache_sling_scripting_cache_additional__extensions();
        this.handleEvent(null);
    }

    @Deactivate
    protected void deactivate() {
        if (this.resourceChangeListener != null) {
            this.resourceChangeListener.unregister();
            this.resourceChangeListener = null;
        }
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("Unable to shutdown script cache thread in time");
        }
    }

    public void onChange(@NotNull List<ResourceChange> list) {
        Runnable eventTask = () -> {
            for (ResourceChange change : list) {
                this.scriptCache.removeScript(change.getPath());
            }
        };
        this.threadPool.execute(eventTask);
    }

    private void configureListener() {
        this.scriptCache.clear();
        if (this.extensions.isEmpty()) {
            if (this.resourceChangeListener != null) {
                this.resourceChangeListener.unregister();
                this.resourceChangeListener = null;
            }
        } else {
            Dictionary resourceChangeListenerProperties;
            ArrayList<String> globPatterns = new ArrayList<String>(this.extensions.size());
            for (String extension : this.extensions) {
                globPatterns.add("glob:**/*.".concat(extension));
            }
            Object[] paths = globPatterns.toArray(new String[globPatterns.size()]);
            if (this.resourceChangeListener != null) {
                resourceChangeListenerProperties = this.resourceChangeListener.getReference().getProperties();
                if (!Arrays.equals(paths, (String[])resourceChangeListenerProperties.get("resource.paths"))) {
                    resourceChangeListenerProperties.put("resource.paths", paths);
                    this.resourceChangeListener.setProperties(resourceChangeListenerProperties);
                }
            } else {
                resourceChangeListenerProperties = new Hashtable();
                resourceChangeListenerProperties.put("resource.paths", paths);
                resourceChangeListenerProperties.put("resource.change.types", new String[]{ResourceChange.ChangeType.CHANGED.name(), ResourceChange.ChangeType.REMOVED.name()});
                this.resourceChangeListener = this.bundleContext.registerService(ResourceChangeListener.class, (Object)this, resourceChangeListenerProperties);
            }
        }
    }

    private void initializeExtensions() {
        this.extensions.clear();
        for (ScriptEngineFactory factory : this.slingScriptEngineManager.getEngineFactories()) {
            ScriptEngine scriptEngine = factory.getScriptEngine();
            if (!(scriptEngine instanceof Compilable)) continue;
            this.extensions.addAll(factory.getExtensions());
        }
        if (this.additionalExtensions != null) {
            this.extensions.addAll(Arrays.asList(this.additionalExtensions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        Set<String> set = this.extensions;
        synchronized (set) {
            this.initializeExtensions();
            this.configureListener();
        }
    }
}

