/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.core.ScriptHelper;
import org.apache.sling.scripting.core.impl.bundled.BundledScriptContext;
import org.apache.sling.scripting.core.impl.bundled.ExecutableUnit;
import org.apache.sling.scripting.core.impl.bundled.LogWriter;
import org.apache.sling.scripting.core.impl.bundled.SlingScriptAdapter;
import org.apache.sling.scripting.core.impl.helper.ProtectedBindings;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptContextProvider.class})
public class ScriptContextProvider {
    private static final Set<String> PROTECTED_BINDINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("request", "response", "reader", "resource", "resolver", "out", "log", "sling", "javax.script.filename", BundledRenderUnit.VARIABLE)));
    @Reference
    private BindingsValuesProvidersByContext bvpTracker;
    @Reference
    private ScriptEngineManager scriptEngineManager;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;

    public ExecutableContext prepareScriptContext(SlingHttpServletRequest request, SlingHttpServletResponse response, ExecutableUnit executable) throws IOException {
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(executable.getScriptEngineName());
        if (scriptEngine == null && (scriptEngine = this.scriptEngineManager.getEngineByExtension(executable.getScriptExtension())) == null) {
            throw new IllegalStateException(String.format("Cannot find a script engine with name %s and extension %s for executable %s.", executable.getScriptEngineName(), executable.getScriptExtension(), executable.getPath()));
        }
        LazyBindings bindings = new LazyBindings();
        bindings.put("properties", (Object)request.getResource().getValueMap());
        bindings.put("request", (Object)request);
        bindings.put("response", (Object)response);
        bindings.put("reader", (Object)request.getReader());
        bindings.put("resource", (Object)request.getResource());
        bindings.put("resolver", (Object)request.getResource().getResourceResolver());
        bindings.put("out", (Object)response.getWriter());
        Logger scriptLogger = LoggerFactory.getLogger((String)executable.getName());
        bindings.put("log", (Object)scriptLogger);
        bindings.put("sling", (Object)new ScriptHelper(executable.getBundleContext(), new SlingScriptAdapter(request.getResourceResolver(), executable.getPath(), "sling/bundle/resource"), request, response));
        bindings.put(BundledRenderUnit.VARIABLE, (Object)executable);
        bindings.put("javax.script.filename", (Object)executable.getPath());
        bindings.put("javax.script.filename".replaceAll("\\.", "_"), (Object)executable.getPath());
        ProtectedBindings protectedBindings = new ProtectedBindings((Bindings)bindings, PROTECTED_BINDINGS);
        for (BindingsValuesProvider bindingsValuesProvider : this.bvpTracker.getBindingsValuesProviders(scriptEngine.getFactory(), "request")) {
            bindingsValuesProvider.addBindings((Bindings)protectedBindings);
        }
        BundledScriptContext scriptContext = new BundledScriptContext();
        HashMap<String, LazyBindings.Supplier> slingBindingsSuppliers = new HashMap<String, LazyBindings.Supplier>();
        slingBindingsSuppliers.put("org.apache.sling.api.scripting.ScriptResourceResolver", () -> this.scriptingResourceResolverProvider.getRequestScopedResourceResolver());
        LazyBindings slingScopeBindings = new LazyBindings(slingBindingsSuppliers);
        scriptContext.setBindings((Bindings)slingScopeBindings, -314);
        scriptContext.setBindings((Bindings)bindings, 100);
        scriptContext.setWriter(response.getWriter());
        scriptContext.setErrorWriter(new LogWriter(scriptLogger));
        scriptContext.setReader(request.getReader());
        return new ExecutableContext(scriptContext, executable, scriptEngine);
    }

    static class ExecutableContext {
        private final ScriptContext scriptContext;
        private final ExecutableUnit executable;
        private final ScriptEngine scriptEngine;

        private ExecutableContext(ScriptContext scriptContext, ExecutableUnit executable, ScriptEngine scriptEngine) {
            this.scriptContext = scriptContext;
            this.executable = executable;
            this.scriptEngine = scriptEngine;
        }

        void eval() throws ScriptException {
            this.executable.eval(this.scriptEngine, this.scriptContext);
        }

        void clean() {
            Object scriptHelper;
            Bindings engineBindings = this.scriptContext.getBindings(100);
            if (engineBindings != null && engineBindings.containsKey("sling") && (scriptHelper = engineBindings.get("sling")) instanceof ScriptHelper) {
                ((ScriptHelper)scriptHelper).cleanup();
            }
            this.executable.releaseDependencies();
        }
    }
}

