/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.jsr223;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.core.impl.jsr223.SortableScriptEngineFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptEngineManager.class, SlingScriptEngineManager.class}, reference={@Reference(name="ScriptEngineFactory", bind="bindScriptEngineFactory", unbind="unbindScriptEngineFactory", updated="updatedScriptEngineFactory", service=ScriptEngineFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class SlingScriptEngineManager
extends ScriptEngineManager
implements BundleListener {
    private ScriptEngineManager internalManager;
    private final Set<Bundle> engineSpiBundles = new HashSet<Bundle>();
    private final Set<ServiceReference<ScriptEngineFactory>> serviceReferences = new HashSet<ServiceReference<ScriptEngineFactory>>();
    private final SortedSet<SortableScriptEngineFactory> factories = new TreeSet<SortableScriptEngineFactory>();
    private BundleContext bundleContext;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile EventAdmin eventAdmin;
    static final String EVENT_TOPIC_SCRIPT_MANAGER_UPDATED = "org/apache/sling/scripting/core/impl/jsr223/SlingScriptEngineManager/UPDATED";
    static final String ENGINE_FACTORY_SERVICE = "META-INF/services/" + ScriptEngineFactory.class.getName();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Logger logger = LoggerFactory.getLogger(SlingScriptEngineManager.class);

    @Override
    public ScriptEngine getEngineByName(String shortName) {
        this.readWriteLock.readLock().lock();
        try {
            ScriptEngine scriptEngine = this.internalManager.getEngineByName(shortName);
            return scriptEngine;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public List<ScriptEngine> getEnginesByName(String shortName) {
        this.readWriteLock.readLock().lock();
        try {
            List<ScriptEngine> list = this.factories.stream().filter(factory -> factory.getEngineName().contains(shortName)).map(factory -> factory.getDelegate().getScriptEngine()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public ScriptEngine getEngineByExtension(String extension) {
        this.readWriteLock.readLock().lock();
        try {
            ScriptEngine scriptEngine = this.internalManager.getEngineByExtension(extension);
            return scriptEngine;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public List<ScriptEngine> getEnginesByExtension(String extension) {
        this.readWriteLock.readLock().lock();
        try {
            List<ScriptEngine> list = this.factories.stream().filter(factory -> factory.getExtensions().contains(extension)).map(factory -> factory.getDelegate().getScriptEngine()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public ScriptEngine getEngineByMimeType(String mimeType) {
        this.readWriteLock.readLock().lock();
        try {
            ScriptEngine scriptEngine = this.internalManager.getEngineByMimeType(mimeType);
            return scriptEngine;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public List<ScriptEngine> getEnginesByMimeType(String mimeType) {
        this.readWriteLock.readLock().lock();
        try {
            List<ScriptEngine> list = this.factories.stream().filter(factory -> factory.getMimeTypes().contains(mimeType)).map(factory -> factory.getDelegate().getScriptEngine()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public List<ScriptEngineFactory> getEngineFactories() {
        this.readWriteLock.readLock().lock();
        try {
            ArrayList<SortableScriptEngineFactory> list = new ArrayList<SortableScriptEngineFactory>(this.factories.size());
            list.addAll(this.factories);
            List<ScriptEngineFactory> list2 = Collections.unmodifiableList(list);
            return list2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void registerEngineName(String name, ScriptEngineFactory factory) {
        this.readWriteLock.writeLock().lock();
        try {
            this.internalManager.registerEngineName(name, factory);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        this.readWriteLock.writeLock().lock();
        try {
            this.internalManager.registerEngineMimeType(type, factory);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        this.readWriteLock.writeLock().lock();
        try {
            this.internalManager.registerEngineExtension(extension, factory);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2 && event.getBundle().getBundleId() > 0L && event.getBundle().getEntry(ENGINE_FACTORY_SERVICE) != null) {
            Set<Bundle> set = this.engineSpiBundles;
            synchronized (set) {
                this.engineSpiBundles.add(event.getBundle());
            }
            this.updateFactories();
        } else if (event.getType() == 4) {
            boolean refresh;
            Set<Bundle> set = this.engineSpiBundles;
            synchronized (set) {
                refresh = this.engineSpiBundles.remove(event.getBundle());
            }
            if (refresh) {
                this.updateFactories();
            }
        }
    }

    public Map<String, Object> getServiceProperties(ScriptEngineFactory factory) {
        this.readWriteLock.readLock().lock();
        try {
            Map map = this.factories.stream().filter(f -> f.getDelegate().equals(factory)).findFirst().map(SortableScriptEngineFactory::getServiceProperties).orElse(null);
            return map;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        bundleContext.addBundleListener((BundleListener)this);
        this.updateFactories();
    }

    @Deactivate
    private void deactivate(BundleContext bundleContext) {
        bundleContext.removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindScriptEngineFactory(ServiceReference<ScriptEngineFactory> serviceReference, ScriptEngineFactory factory) {
        Set<ServiceReference<ScriptEngineFactory>> set = this.serviceReferences;
        synchronized (set) {
            this.serviceReferences.add(serviceReference);
        }
        this.updateFactories();
        this.postEvent("javax/script/ScriptEngineFactory/ADDED", factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindScriptEngineFactory(ServiceReference<ScriptEngineFactory> serviceReference, ScriptEngineFactory factory) {
        Set<ServiceReference<ScriptEngineFactory>> set = this.serviceReferences;
        synchronized (set) {
            this.serviceReferences.remove(serviceReference);
            if (this.bundleContext != null) {
                this.bundleContext.ungetService(serviceReference);
            }
        }
        this.updateFactories();
        this.postEvent("javax/script/ScriptEngineFactory/REMOVED", factory);
    }

    private void updatedScriptEngineFactory(ServiceReference<ScriptEngineFactory> serviceReference, ScriptEngineFactory factory) {
        this.updateFactories();
        this.postEvent("javax/script/ScriptEngineFactory/UPDATED", factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFactories() {
        this.readWriteLock.writeLock().lock();
        try {
            this.internalManager = this.getInternalScriptEngineManager();
            this.factories.clear();
            long fakeBundleIdCounter = Long.MIN_VALUE;
            for (ScriptEngineFactory factory : this.internalManager.getEngineFactories()) {
                SortableScriptEngineFactory sortableScriptEngineFactory = new SortableScriptEngineFactory(factory, fakeBundleIdCounter++, 0, null);
                this.factories.add(sortableScriptEngineFactory);
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                for (Bundle bundle : this.engineSpiBundles) {
                    try {
                        ScriptEngineManager manager = new ScriptEngineManager(((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
                        for (ScriptEngineFactory scriptEngineFactory : manager.getEngineFactories()) {
                            SortableScriptEngineFactory sortableScriptEngineFactory = new SortableScriptEngineFactory(scriptEngineFactory, bundle.getBundleId(), 0, null);
                            this.factories.add(sortableScriptEngineFactory);
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error("Unable to process bundle " + bundle.getSymbolicName(), (Throwable)ex);
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if (this.bundleContext != null) {
                for (ServiceReference serviceReference : this.serviceReferences) {
                    ScriptEngineFactory scriptEngineFactory = (ScriptEngineFactory)this.bundleContext.getService(serviceReference);
                    HashMap<String, Object> factoryProperties = new HashMap<String, Object>(serviceReference.getPropertyKeys().length);
                    for (String key : serviceReference.getPropertyKeys()) {
                        factoryProperties.put(key, serviceReference.getProperty(key));
                    }
                    SortableScriptEngineFactory sortableScriptEngineFactory = new SortableScriptEngineFactory(scriptEngineFactory, serviceReference.getBundle().getBundleId(), PropertiesUtil.toInteger(serviceReference.getProperty("service.ranking"), 0), factoryProperties);
                    this.factories.add(sortableScriptEngineFactory);
                }
            }
            for (ScriptEngineFactory scriptEngineFactory : this.factories) {
                this.registerAssociations(scriptEngineFactory);
            }
            if (this.eventAdmin != null) {
                this.eventAdmin.postEvent(new Event(EVENT_TOPIC_SCRIPT_MANAGER_UPDATED, Collections.EMPTY_MAP));
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private ScriptEngineManager getInternalScriptEngineManager() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager(ClassLoader.getSystemClassLoader());
            return scriptEngineManager;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    private void registerAssociations(ScriptEngineFactory factory) {
        for (String extension : factory.getExtensions()) {
            if (extension != null && !extension.isEmpty()) {
                this.internalManager.registerEngineExtension(extension, factory);
                continue;
            }
            this.logger.warn("Could not register an empty or null extension for script engine factory {}.", (Object)factory.getEngineName());
        }
        for (String mimeType : factory.getMimeTypes()) {
            if (mimeType != null && !mimeType.isEmpty()) {
                this.internalManager.registerEngineMimeType(mimeType, factory);
                continue;
            }
            this.logger.warn("Could not register an empty or null mime type for script engine factory {}.", (Object)factory.getEngineName());
        }
        for (String name : factory.getNames()) {
            if (name != null && !name.isEmpty()) {
                this.internalManager.registerEngineName(name, factory);
                continue;
            }
            this.logger.warn("Could not register an empty or null engine name for script engine factory {}.", (Object)factory.getEngineName());
        }
    }

    private void postEvent(String topic, ScriptEngineFactory scriptEngineFactory) {
        if (this.eventAdmin != null) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("engineName", scriptEngineFactory.getEngineName());
            ((Dictionary)props).put("engineVersion", scriptEngineFactory.getEngineVersion());
            ((Dictionary)props).put("extensions", scriptEngineFactory.getExtensions().toArray(new String[0]));
            ((Dictionary)props).put("languageName", scriptEngineFactory.getLanguageName());
            ((Dictionary)props).put("languageVersion", scriptEngineFactory.getLanguageVersion());
            ((Dictionary)props).put("mimeTypes", scriptEngineFactory.getMimeTypes().toArray(new String[0]));
            this.eventAdmin.postEvent(new Event(topic, props));
        }
    }
}

