/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl.bundled;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.core.impl.bundled.AbstractBundledRenderUnit;
import org.apache.sling.scripting.core.impl.bundled.ScriptContextProvider;
import org.apache.sling.servlets.resolver.bundle.tracker.TypeProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class Script
extends AbstractBundledRenderUnit {
    private final URL url;
    private String sourceCode;
    private CompiledScript compiledScript = null;
    private Lock compilationLock = new ReentrantLock();
    private Lock readLock = new ReentrantLock();

    Script(@NotNull Set<TypeProvider> providers, @NotNull BundleContext context, @NotNull Bundle bundle, @NotNull String path, @NotNull URL url, @NotNull String scriptEngineName, @NotNull String scriptExtension, @NotNull ScriptContextProvider scriptContextProvider) {
        super(providers, context, bundle, path, scriptEngineName, scriptExtension, scriptContextProvider);
        this.url = url;
    }

    private String getSourceCode() throws IOException {
        if (this.sourceCode == null) {
            this.readLock.lock();
            try {
                if (this.sourceCode == null) {
                    this.sourceCode = IOUtils.toString((InputStream)this.url.openStream(), (Charset)StandardCharsets.UTF_8);
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return this.sourceCode;
    }

    @NotNull
    public String getName() {
        return this.url.getPath();
    }

    public InputStream getInputStream() {
        try {
            return IOUtils.toInputStream((String)this.getSourceCode());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void eval(@NotNull ScriptEngine scriptEngine, @NotNull ScriptContext context) throws ScriptException {
        try {
            if (scriptEngine instanceof Compilable && (this.compiledScript == null || !scriptEngine.getFactory().equals(this.compiledScript.getEngine().getFactory()))) {
                this.compilationLock.lock();
                try {
                    if (this.compiledScript == null || !scriptEngine.getFactory().equals(this.compiledScript.getEngine().getFactory())) {
                        this.compiledScript = ((Compilable)((Object)scriptEngine)).compile(new ScriptNameAwareReader(new StringReader(this.getSourceCode()), this.getName()));
                    }
                }
                finally {
                    this.compilationLock.unlock();
                }
            }
            if (this.compiledScript != null) {
                this.compiledScript.eval(context);
            } else {
                scriptEngine.eval(this.getSourceCode(), context);
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }
}

